/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoControllableFolder
extends JzRepoControllableResource {
    public static final String CHILD_LIST_SEPARATOR_STRING = String.valueOf(',');

    public JzRepoControllableFolder(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableFolderImpl.class;
    }

    public static JzRepoResource doCreate(JzProvider provider, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        IVersionable resource = (IVersionable)IFolder.ITEM_TYPE.createItem();
        JzLocation actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, resource, feedback);
        JzRepoControllableFolder result = new JzRepoControllableFolder(provider, (Location)actualAddedItemLocation);
        return result;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.childMap(false, this.getConfiguration(feedback), feedback);
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            Map<String, SrvcResource> map = this.childMap(false, this.getConfiguration(feedback), feedback);
            ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
            result.addAll(map.values());
            return result;
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return null;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public void doBindChild(String newBindingName, Location genericLocation, Folder.BindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
        JzLocation currentLoc = JzLocation.create(genericLocation);
        JzRepoControllableResource childCR = (JzRepoControllableResource)this.provider().lookup((Location)currentLoc, feedback);
        if (childCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_NO_CHILD_AT_LOCATION, (Object)currentLoc.string(), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        this.rebindChildHelper((IVersionableHandle)childCR.getItemHandle(feedback), newBindingName, feedback);
    }

    public void doRebindChild(String bindingName, Location currentParentLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
        JzProvider provider = this.provider();
        JzRepoControllableFolder currentParent = (JzRepoControllableFolder)provider.get(currentParentLocation, feedback);
        IVersionableHandle childHandle = currentParent.getChild(sourceBindingName, feedback);
        this.rebindChildHelper(childHandle, bindingName, feedback);
    }

    public void doRebindAll(String bindingName, Location sourceLocation, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
        JzProvider provider = this.provider();
        JzRepoControllableResource sourceCR = (JzRepoControllableResource)provider.get(sourceLocation, feedback);
        IVersionableHandle sourceHandle = (IVersionableHandle)sourceCR.getItemHandle(feedback);
        this.rebindChildHelper(sourceHandle, bindingName, feedback);
    }

    private void rebindChildHelper(IVersionableHandle childHandle, String newBindingName, SrvcFeedback feedback) throws WvcmException {
        IConfiguration config = this.getConfiguration(feedback.nest(10));
        try {
            IVersionable itemToRebind = (IVersionable)config.fetchCompleteItem(childHandle, JzProvider.getMonitor(feedback, 20)).getWorkingCopy();
            itemToRebind.setName(newBindingName);
            itemToRebind.setParent((IFolderHandle)this.getItemHandle(feedback.nest(40)));
            JzLocation reboundLocation = this.location().child(newBindingName);
            this.commit(itemToRebind, reboundLocation, feedback);
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(e.getMessage(), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback.nest(40));
        IVersionableHandle deleteMe = this.getChild(bindingName, feedback.nest(55));
        boolean itemToUnbindIsAFolder = deleteMe.getItemType().equals(IFolder.ITEM_TYPE);
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(70));
        IWorkspaceConnection.IDeleteOp configurationOp = itemToUnbindIsAFolder ? wsConn.configurationOpFactory().deleteSubtree((IFolderHandle)deleteMe) : wsConn.configurationOpFactory().delete(deleteMe);
        this.commit((IWorkspaceConnection.IConfigurationOp)configurationOp, this.location().child(bindingName), feedback);
    }

    public IVersionableHandle getChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        try {
            IVersionableHandle result = this.getConfiguration(feedback.nest(20)).resolvePath((IFolderHandle)this.getItemHandle(feedback.nest(40)), new String[]{bindingName}, JzProvider.getMonitor(feedback, 100));
            if (result == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_CHILD_NOT_FOUND_WITH_NAME, (Object)bindingName, (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static SrvcResource doCreateVersionControlledResource(JzProvider provider, Location genericLewLocation, Location genericVersionToRestoreLoc, SrvcFeedback feedback) throws WvcmException {
        JzLocation versionToRestoreLoc;
        JzRepoVersion versionToRestore;
        JzRepoComponent versionToRestoreComponent;
        JzLocation newLocation = JzLocation.create(genericLewLocation);
        JzLocation parent = newLocation.parent();
        JzRepoControllableFolder restoreToThisFolder = (JzRepoControllableFolder)provider.get((Location)parent, feedback.nest(5));
        JzRepoComponent restoreToThisComponent = restoreToThisFolder.getJzRepoComponent(feedback.nest(10));
        if (!restoreToThisComponent.isSameObject(versionToRestoreComponent = (versionToRestore = (JzRepoVersion)provider.get((Location)(versionToRestoreLoc = JzLocation.create(genericVersionToRestoreLoc)), feedback.nest(15))).getJzRepoComponent(feedback.nest(20)), feedback.nest(25))) {
            IFolderHandle rootFolderHandle = versionToRestoreComponent.getRootFolderHandle(feedback.nest(30));
            IFolderHandle parentFolderHandle = versionToRestore.getParentFolderHandle(feedback.nest(35));
            if (!parentFolderHandle.sameItemId((IItemHandle)rootFolderHandle)) {
                throw new WvcmException(Messages.JzRepoControllableFolder_ERROR_NO_CROSS_COMPONENT_MOVES, WvcmException.ReasonCode.FORBIDDEN);
            }
            JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, newLocation.getWorkspaceLocation(), feedback.nest(40));
            ws.ensureComponentInConfiguration(versionToRestoreComponent, feedback.nest(45));
            restoreToThisComponent = versionToRestoreComponent;
            JzLocation parentLoc = ws.computeBcfLoc(versionToRestoreComponent);
            restoreToThisFolder = (JzRepoControllableFolder)JzRepoControllableFolder.createFromVersionable(provider, parentLoc, (IVersionableHandle)rootFolderHandle);
        }
        return restoreToThisFolder.doCreateVersionControlledResource(newLocation, versionToRestore, feedback);
    }

    public static SrvcResource doCreateBaselineControlledFolder(JzProvider provider, Location genericLewLocation, Location genericBaselineToRestoreLoc, SrvcFeedback feedback) throws WvcmException {
        JzLocation newLocation = JzLocation.create(genericLewLocation);
        JzLocation baselineToRestoreLoc = JzLocation.create(genericBaselineToRestoreLoc);
        JzLocation compLoc = baselineToRestoreLoc.getComponentLocation();
        JzRepoComponent comp = (JzRepoComponent)provider.get((Location)compLoc, feedback.nest(10));
        JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, newLocation.getWorkspaceLocation(), feedback.nest(20));
        ws.ensureComponentInConfiguration(comp, feedback.nest(30));
        JzLocation resultLoc = ws.computeBcfLoc(comp);
        JzRepoControllableFolder result = (JzRepoControllableFolder)provider.get((Location)resultLoc, feedback);
        return result;
    }

    public JzRepoControllableResource doCreateVersionControlledResource(JzLocation newLocationHint, JzRepoVersion item, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        IFolderHandle newParentHandle = (IFolderHandle)this.getItemHandle(feedback.nest(20));
        String bindingName = newLocationHint.lastSegment();
        JzLocation newLocation = this.location().child(bindingName);
        if (provider.isDebugLogEnabled()) {
            this.logDebug(String.format("restoring URI: %s to location: %s", item.location().string(), newLocation.string()));
        }
        IVersionable itemToCatalog = item.getWorkingCopy(feedback.nest(40));
        itemToCatalog.setName(bindingName);
        itemToCatalog.setParent(newParentHandle);
        this.commit(itemToCatalog, newLocation, feedback);
        return JzRepoControllableFolder.createFromVersionable(provider, newLocation, (IVersionableHandle)itemToCatalog);
    }

    public JzLocation doAddItem(String bindingName, IVersionable addMe, SrvcFeedback feedback) throws WvcmException {
        IFolderHandle parentHandle = (IFolderHandle)this.getItemHandle(feedback.nest(50));
        addMe.setName(bindingName);
        addMe.setParent(parentHandle);
        JzLocation resultLoc = this.location().child(bindingName);
        this.commit(addMe, resultLoc, feedback);
        return resultLoc;
    }

    public IVersionableHandle getVersionableHandle(String[] path, SrvcFeedback feedback) throws WvcmException {
        IVersionableHandle result = this.lookupVersionableHandle(path, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_PATHNAME_NOT_FOUND, (Object)JzProvider.myToString(JzProvider.FWDSLASH, path), (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IVersionableHandle lookupVersionableHandle(String[] path, SrvcFeedback feedback) throws WvcmException {
        IVersionableHandle result = null;
        JzLocation myLoc = this.location();
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback.nest(10));
        JzRepoComponent comp = ws.lookupJzRepoComponent(myLoc.getComponentLocation(), feedback.nest(25));
        IConfiguration config = ws.ensureComponentInConfiguration(comp, feedback.nest(40));
        try {
            IFolderHandle rootFolderHandle = config.rootFolderHandle(JzProvider.getMonitor(feedback, 50));
            result = config.resolvePath(rootFolderHandle, path, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (ItemNotFoundException e) {
            String msg = NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_UNRESOLVED_PATHNAME, (Object[])path, (Object[])new Object[0]);
            this.logIgnoredExceptionAsNotAlwaysVisible("JzRepoControllable.lookupVersionableHandle", (Exception)((Object)e), msg);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        return result;
    }
}

