/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoConfiguration
extends JzRepoResource {
    JzRepoWorkspace _myWsCache = null;
    JzRepoComponent _myCompCache = null;

    public JzRepoConfiguration(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ConfigurationImpl.class;
    }

    public JzRepoWorkspace getMyWorkspace(SrvcFeedback feedback) throws WvcmException {
        if (this._myWsCache == null) {
            this._myWsCache = this.getWvcmWorkspace(feedback);
        }
        return this._myWsCache;
    }

    public JzRepoComponent getMyComponent(SrvcFeedback feedback) throws WvcmException {
        if (this._myCompCache == null) {
            this._myCompCache = this.getMyWorkspace(feedback.nest(30)).getJzRepoComponent(this.location().getComponentLocation(), feedback);
        }
        return this._myCompCache;
    }

    private static JzRepoComponent getJzRepoComponent(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.get((Location)myLoc.getWorkspaceLocation(), feedback.nest(50));
        JzRepoComponent c = ws.getJzRepoComponent(myLoc.getComponentLocation(), feedback);
        return c;
    }

    public static JzRepoConfiguration lookup(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoConfiguration result = null;
        try {
            JzRepoComponent myComp = JzRepoConfiguration.getJzRepoComponent(provider, myLoc, feedback);
            if (myComp != null) {
                JzLocation configLoc = JzLocation.createConfigurationLoc(myLoc.getWorkspaceLocation(), myComp.location());
                result = new JzRepoConfiguration(provider, (Location)configLoc);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoConfiguration.lookup", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent c = this.getMyComponent(feedback.nest(30));
        c.createBaselineIfNeeded(this.getMyWorkspace(feedback.nest(60)), "Laswell", null, feedback);
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Configuration.CHECKED_IN)) {
            return this.getLatestBaseline(feedback);
        }
        if (propertyName.equals((Object)Configuration.VERSION_HISTORY)) {
            return this.getMyComponent(feedback);
        }
        if (propertyName.equals((Object)Configuration.ROOT_FOLDER)) {
            return this.getRootFolder(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public JzRepoResource getLatestBaseline(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getMyWorkspace(feedback.nest(10));
        JzRepoComponent c = this.getMyComponent(feedback.nest(30));
        this.logDebug("getting baseline in ws: " + ws.location().string());
        return c.lookupLatestBaseline((IFlowNodeConnection)ws.getConnection(feedback.nest(60)), feedback);
    }

    public SrvcResource getRootFolder(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent myComp = this.getMyComponent(feedback.nest(30));
        JzLocation parentLoc = this.getMyWorkspace(feedback.nest(60)).computeBcfLoc(myComp);
        JzRepoControllableFolder result = (JzRepoControllableFolder)JzRepoConfiguration.createFromVersionable(this.provider(), parentLoc, (IVersionableHandle)myComp.getRootFolderHandle(feedback));
        return result;
    }

    public void commit(IWorkspaceConnection.IConfigurationOp configOp, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        if (configOp != null) {
            HashMap<JzLocation, IWorkspaceConnection.IConfigurationOp> op = new HashMap<JzLocation, IWorkspaceConnection.IConfigurationOp>();
            op.put(location, configOp);
            this.commit(op, feedback);
        }
    }

    IChangeSetHandle createChangeSet(SrvcFeedback feedback) throws WvcmException {
        try {
            IChangeSetHandle result = this.getWorkspaceConnection(feedback.nest(10)).createChangeSet(this.getMyComponent(feedback.nest(30)).getComponentItemHandle(feedback.nest(50)), JzProvider.getMonitor(feedback, 100));
            this.logCreation("ChangeSet", JzRepoChangeSet.create(this.provider(), result, feedback).location());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public IChangeSetHandle getActiveChangeSetHandle(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(30));
        IComponentHandle cH = this.getMyComponent(feedback.nest(60)).getComponentItemHandle(feedback.nest(80));
        List sets = wsConn.activeChangeSets(cH);
        int count = sets.size();
        IChangeSetHandle result = null;
        if (count > 1) {
            throw new IllegalStateException("got too many active change sets: " + Integer.toString(count));
        }
        if (count == 1) {
            this.logDebug("reusing active change set");
            result = (IChangeSetHandle)sets.get(0);
        } else {
            result = this.createChangeSet(feedback);
        }
        return result;
    }

    public void commit(Map<JzLocation, IWorkspaceConnection.IConfigurationOp> opDescs, SrvcFeedback feedback) throws WvcmException {
        if (opDescs != null) {
            IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(20));
            IChangeSetHandle activeCS = this.getActiveChangeSetHandle(feedback.nest(30));
            if (this.provider().isDebugLogEnabled()) {
                JzLocation[] locations = opDescs.keySet().toArray(new JzLocation[opDescs.size()]);
                this.logDebug("committing: " + this.join(JzProvider.COMMA_SPACE, locations));
            }
            try {
                wsConn.commit(activeCS, opDescs.values(), JzProvider.getMonitor(feedback, 100));
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
        }
    }

    public String join(String separator, JzLocation ... values) {
        if (values.length == 0) {
            return JzProvider.EMPTY_STRING;
        }
        StringBuilder buf = new StringBuilder(values[0].string());
        int i = 1;
        while (i < values.length) {
            buf.append(separator);
            buf.append(values[i].string());
            ++i;
        }
        return buf.toString();
    }

    public void closeCurrentActivity(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        provider.applyDeferredContentCommits(this, feedback.nest(10));
        JzRepoWorkspace ws = this.getMyWorkspace(feedback.nest(20));
        IWorkspaceConnection wsConn = ws.getConnection(feedback.nest(30));
        JzRepoComponent comp = this.getMyComponent(feedback.nest(40));
        try {
            List activeCSs = wsConn.activeChangeSets(comp.getComponentItemHandle(feedback.nest(50)));
            int count = activeCSs.size();
            if (count > 0) {
                wsConn.closeChangeSets((Collection)activeCSs, JzProvider.getMonitor(feedback, 100));
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }
}

