/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ActivityImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoWorkItem;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoChangeSet
extends JzRepoResource {
    public JzRepoChangeSet(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ActivityImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Activity.TASK_LIST)) {
            return this.getTaskList(feedback);
        }
        if (propertyName.equals((Object)Resource.COMMENT)) {
            return this.getComment(feedback);
        }
        if (propertyName.equals((Object)Activity.ORIGIN_WORKSPACE)) {
            return null;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<SrvcResource> getTaskList(SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>();
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        IChangeSetHandle chs = (IChangeSetHandle)this.getItemHandle(feedback);
        try {
            List cachedLinks = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)chs, (IProgressMonitor)JzProvider.getMonitor(feedback, 100));
            for (ILink link : cachedLinks) {
                IReference targetRef;
                if (!link.getLinkTypeId().equals("com.ibm.team.filesystem.workitems.change_set") || !(targetRef = link.getTargetRef()).isItemReference()) continue;
                IWorkItemHandle wiHandle = (IWorkItemHandle)((IItemReference)targetRef).getReferencedItem();
                JzRepoWorkItem task = JzRepoWorkItem.create(provider, wiHandle);
                results.add(task);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private String getComment(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        try {
            IChangeSet cs = (IChangeSet)provider.getRepo().itemManager().fetchPartialItem(this.getItemHandle(feedback), 0, Collections.singletonList(IChangeSet.COMMENT_PROPERTY), JzProvider.getMonitor(feedback, 100));
            return cs.getComment();
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.COMMENT) && value instanceof String) {
            this.setComment((String)value, feedback);
        } else if (propertyName.equals((Object)Activity.TASK_LIST)) {
            this.setTaskList((List)value, feedback);
        } else {
            propertyName.equals((Object)Activity.ORIGIN_WORKSPACE);
        }
    }

    private void setTaskList(List<JzRepoWorkItem> workItems, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.provider();
        ITeamRepository repo = provider.getRepo();
        IChangeSetHandle csh = (IChangeSetHandle)this.getItemHandle(feedback);
        ArrayList<IItemHandle> workItemHandles = new ArrayList<IItemHandle>(workItems.size());
        for (JzRepoWorkItem wi : workItems) {
            IItemHandle itemHandle = wi.getItemHandle(feedback);
            if (itemHandle.getOrigin() == null) {
                throw new IllegalArgumentException("work item handle origin must not be null");
            }
            workItemHandles.add(itemHandle);
        }
        IWorkItemHandle[] workItemHandlesArray = workItemHandles.toArray(new IWorkItemHandle[0]);
        try {
            IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
            workItemManager.createLink(null, csh, workItemHandlesArray, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    private void setComment(String comment, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceManager wm = this.getWorkspaceManager();
        try {
            wm.setComment((IChangeSetHandle)this.getItemHandle(feedback), comment, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static JzRepoChangeSet lookup(JzProvider provider, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoChangeSet result = null;
        IItemHandle myItemHandle = JzRepoChangeSet.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = JzRepoChangeSet.create(provider, loc, myItemHandle);
        }
        return result;
    }

    public static JzRepoChangeSet create(JzProvider provider, JzLocation loc, IItemHandle myItemHandle) {
        JzRepoChangeSet result = new JzRepoChangeSet(provider, (Location)loc);
        result.setItemHandle(myItemHandle);
        return result;
    }

    public static JzRepoChangeSet create(JzProvider provider, IChangeSetHandle changeSetHandle, SrvcFeedback feedback) throws WvcmException {
        JzLocation myLoc = JzLocation.createChangeSetLocation(JzRepoChangeSet.getCurrentStateDisplayName((IItemHandle)changeSetHandle));
        return JzRepoChangeSet.create(provider, myLoc, (IItemHandle)changeSetHandle);
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IChangeSetHandle csh = JzRepoWorkspace.doCreateGeneratedChangeSet(provider, locationHint, updates, updated, feedback);
        return JzRepoChangeSet.create(provider, csh, feedback);
    }
}

