/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IBaselineHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoBaseline
extends JzRepoResource {
    public JzRepoBaseline(JzProvider provider, JzLocation loc) {
        super(provider, (Location)loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return BaselineImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Baseline.VERSION_HISTORY)) {
            JzLocation compLoc = this.location().getComponentLocation();
            JzRepoComponent myComp = (JzRepoComponent)this.provider().lookup((Location)compLoc, feedback);
            return myComp;
        }
        if (propertyName.equals((Object)Baseline.VERSION_LIST)) {
            return this.getVersionList(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_NAME)) {
            return this.getConnection(feedback).getName();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<JzRepoVersion> getVersionList(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = (JzRepoComponent)this.provider().get((Location)this.location().getComponentLocation(), feedback);
        ArrayList<JzRepoVersion> result = new ArrayList<JzRepoVersion>();
        JzRepoBaseline.getVersionList(this.provider(), comp, this.getConfiguration(feedback), result, feedback);
        return result;
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource otherBaselineGeneric, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        IBaselineConnection thisConn = this.getConnection(feedback);
        JzRepoBaseline otherBl = (JzRepoBaseline)otherBaselineGeneric;
        this.logDebug(String.format("comparing this BL: %s with other BL: %s", this.location().string(), otherBl.location().string()));
        List nullCHL = Collections.EMPTY_LIST;
        return this.computeWvcmCompareReport((IConnection)thisConn, (IConnection)otherBl.getConnection(feedback), Collections.singletonList(thisConn.getComponent()), nullCHL, flags, feedback);
    }

    public IBaselineConnection getConnection(SrvcFeedback feedback) throws WvcmException {
        IBaselineHandle blH = (IBaselineHandle)this.getItemHandle(feedback);
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        try {
            IBaselineConnection result = workspaceManager.getBaselineConnection(blH, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static JzRepoBaseline lookup(JzProvider provider, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        JzRepoBaseline result = null;
        try {
            result = new JzRepoBaseline(provider, location);
            result.getConnection(feedback);
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoBaseline.lookup", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory, SrvcFeedback feedback) throws WvcmException {
        return ((JzRepoVersionHistory)genericVersionHistory).lookupVersion(this.getConnection(feedback).configuration(), feedback);
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        return ((JzRepoFolderItem)folderVersion).childMap(true, this.getConnection(feedback).configuration(), feedback);
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        return ((JzRepoFolderItem)folderVersion).childList(this.getConnection(feedback).configuration(), feedback);
    }
}

