/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.connector.scm.client.FB;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootBaseline;
import com.ibm.team.connector.scm.client.JzRepoRootVersion;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkItem;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzProvider
extends SrvcProvider {
    public static final String EMPTY_STRING = new String();
    public static final String UNDERSCORE = String.valueOf('_');
    public static final String COMMA = String.valueOf(',');
    public static final String SPACE = String.valueOf(' ');
    public static final String COMMA_SPACE = String.valueOf(COMMA) + SPACE;
    public static final String DASH_DASH = "--";
    public static final String DOUBLE_QUOTE = String.valueOf('\"');
    public static final String FWDSLASH = String.valueOf('/');
    public static final String BACKSLASH = String.valueOf('\\');
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String COMMAND_STRING = "cccToolsCommand";
    public static final String WINDOWS = "windows";
    public static final String UPDATE_SYNC_STREAM_LICENSE_ID = "com.ibm.team.connector.scm.cc.update-sync-stream";
    public static final String IMPORT_STREAM_LICENSE_ID = "com.ibm.team.connector.scm.cc.import-stream";
    public static final String EV_PREFIX = "com.ibm.team.connector.scm.client.";
    public static final PropertyNameList.PropertyName<String> PN_PROCESS_AREA_ID = new PropertyNameList.PropertyName("com.ibm.team.connector.scm", "TEAM_AREA_ID");
    private static final String IA_TEMPLATE_ID_NAME = String.valueOf(InteropStream.IA_PREFIX) + "WORKITEM_TEMPLATE_ID";
    private static final String OLD_DEFAULT_TEMPLATE_ID = "do not use a template for workitem creation";
    private static final String IA_SYNC_VIA_BUILD = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_VIA_BUILD";
    private static final String DEFAULT_SYNC_VIA_BUILD = "true";
    public static final String SYNC_USER_ID_BASENAME = "SYNC_USER_ID";
    public static final String IA_SYNC_USER_ID = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_USER_ID";
    public static final String DEFAULT_SYNC_USER_ID = "ccsync";
    public static final String IA_TEAM_AREA_PATH = String.valueOf(InteropStream.IA_PREFIX) + "TEAM_AREA_PATH";
    private static final String IA_DEFAULT_COMPONENT_RI = "defaultComponentRI";
    private static final String IA_BUILD_DEF_LOC_STR = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_DEF_LOC_STR";
    private static final String IA_BUILD_RESULT_LOC_STR = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_RESULT_LOC_STR";
    public static final String IA_BUILD_ENGINE_NAME = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_ENGINE_NAME";
    public static final String IA_BUILD_KIND = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_KIND";
    public static final String IA_REPOSITORY_URI = String.valueOf(InteropStream.IA_PREFIX) + "REPOSITORY_URI";
    public static final String IA_BUILD_CLI_PATH = String.valueOf(InteropStream.IA_PREFIX) + "CLI_PATH";
    public static final String IA_INSTALL_LOCATION_BASENAME = "INSTALL_LOCATION";
    public static final String IA_INSTALL_PATH = String.valueOf(InteropStream.IA_PREFIX) + "INSTALL_LOCATION";
    public static final String IA_SLEEP_TIME = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_ENGINE_SLEEP_TIME";
    public static final String IA_SYNC_HOST = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_HOST";
    public static final String IA_SYNC_HOST_IS_WINDOWS = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_HOST_IS_WINDOWS";
    public static final String IA_SCRIPT_LOCATION_PREFIX_BASENAME = "SCRIPT_LOCATION_PREFIX";
    public static final String IA_STREAM_SCRIPT_DIR_BASENAME = "STREAM_SCRIPT_DIR";
    public static final String IA_STREAM_SCRIPT_DIR_PATH = String.valueOf(InteropStream.IA_PREFIX) + "STREAM_SCRIPT_DIR";
    public static final String IA_SYMLINKS_SUPPORTED = String.valueOf(InteropStream.IA_PREFIX) + "SYMLINKS_SUPPORTED";
    public static final String IA_SCRIPT_LOCATION_PREFIX = String.valueOf(InteropStream.IA_PREFIX) + "SCRIPT_LOCATION_PREFIX";
    public static final String IA_ALLOW_MOD_MOD_MERGE = String.valueOf(InteropStream.IA_PREFIX) + "ALLOW_MOD_MOD_MERGE";
    public static final BuildKind DEFAULT_BUILD_KIND = BuildKind.CLI;
    public static final String BUILD_CLI_PATH_DEFAULT = "eclipse" + File.separator + "ccc";
    public static final String IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS = String.valueOf(InteropStream.IA_PREFIX) + "DEFER_CONTENT_OPS";
    public static final String IA_REPOSITORY_ROOT_UUID = String.valueOf(InteropStream.IA_PREFIX) + "REPOSITORY_ROOT_UUID";
    public static final String DEFAULT_SLEEP_TIME = "120";
    public static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = "false";
    public static final String DEFAULT_SCRIPT_LOCATION_PREFIX = JzProvider.myToString(File.separator, System.getProperty("user.home"), "ClearCaseConnector");
    private static final Long MILLIS_PER_MINUTE = new Long(60000L);
    private static final Long DEFAULT_MAX_COMMIT_LAG = 5L * MILLIS_PER_MINUTE;
    public static SimpleDateFormat timeFormatter = new SimpleDateFormat("HH.mm.ss");
    private ITeamRepository _jazzRepository;
    private static String fallbackUri;
    private Log _log = null;
    private OpsForAllConfigurations deferrals = new OpsForAllConfigurations();

    public static int FB_BASE(int begin, int end, int count, int size) {
        return begin + (end - begin) * count / size;
    }

    public JzProvider() {
    }

    public JzProvider(ProviderFactory.Callback callback, Map<String, String> args) throws WvcmException {
        this();
        this.initialize(args, callback);
    }

    public static void setFallbackUri(String repositoryURI) {
        fallbackUri = repositoryURI;
    }

    public void initialize(Map<String, String> args, ProviderFactory.Callback callback) throws WvcmException {
        args.put("com.ibm.rational.wvcm.DISPLAYNAME", "Jazz");
        args.put("com.ibm.rational.wvcm.VERSION_KNOWS_PARENT", "true");
        if (args.get(InteropStream.IA_DESYNC) == null) {
            args.put(InteropStream.IA_DESYNC, EMPTY_STRING);
        }
        if (JzProvider.getTemplateId(args) == null) {
            JzProvider.setTemplateId(args, EMPTY_STRING);
        }
        if (JzProvider.getSyncViaBuild(args) == null) {
            JzProvider.setSyncViaBuild(args, "true");
        }
        if (JzProvider.getSyncUserId(args) == null) {
            this.setSyncUserIdToDefault(args);
        }
        if (JzProvider.getBuildKind(args) == null) {
            JzProvider.setBuildKind(args, DEFAULT_BUILD_KIND);
        }
        if (this.getMaxContentCommitDeferralMillis(args) == null) {
            this.setMaxContentCommitDeferralMillis(args, DEFAULT_MAX_COMMIT_LAG.toString());
        }
        if (JzProvider.getBuildCliPath(args) == null) {
            JzProvider.setBuildCliPath(args, BUILD_CLI_PATH_DEFAULT);
        }
        if (JzProvider.getInstallLocation(args) == null) {
            JzProvider.setInstallLocation(args, EMPTY_STRING);
        }
        if (JzProvider.getBuildEngineSleepTime(args) == null) {
            JzProvider.setBuildEngineSleepTime(args, DEFAULT_SLEEP_TIME);
        }
        if (JzProvider.getSyncHost(args) == null) {
            JzProvider.setSyncHost(args, JzProvider.getLocalHostname());
        }
        if (JzProvider.getSyncHostIsWindows(args) == null) {
            JzProvider.setSyncHostIsWindows(args, JzProvider.getIsThisHostWindows());
        }
        if (args.get("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION") == null) {
            args.put("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION", String.valueOf(300000));
        }
        if (args.get(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE) == null) {
            args.put(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE, "false");
        }
        if (!args.containsKey(IA_SCRIPT_LOCATION_PREFIX)) {
            args.put(IA_SCRIPT_LOCATION_PREFIX, DEFAULT_SCRIPT_LOCATION_PREFIX);
        }
        String repoUriString = JzProvider.getRepositoryURI(args);
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        if (repoUriString == null) {
            throw new IllegalArgumentException("Repository URI String must not be null");
        }
        String uuidString = JzProvider.lookupRepoRootUuid(args);
        UUID storedRepoUuid = uuidString == null ? null : UUID.valueOf((String)uuidString);
        this._jazzRepository = JzProvider.findTeamRepository(repoUriString, storedRepoUuid);
        if (this._jazzRepository == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_NO_CONNECTION_FOUND_FOR_URI, (Object)repoUriString, (Object[])new Object[0]), WvcmException.ReasonCode.CONFLICT);
        }
        if (storedRepoUuid == null) {
            JzProvider.setRepoRootUuid(args, this._jazzRepository.root().getItemId().getUuidValue());
        }
        if (JzProvider.getSymlinksSupported(args) == null) {
            boolean doesServerSupportSymlinks;
            try {
                doesServerSupportSymlinks = FileSystemCore.getFileSystemManager((ITeamRepository)this.getRepo()).serverSupportsSymbolicLinks(null);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException((Exception)((Object)e));
            }
            if (doesServerSupportSymlinks) {
                JzProvider.setSymlinksSupported(args, "true");
            }
        }
        super.initialize(args, callback);
    }

    private static ITeamRepository findTeamRepository(String repoUriString, UUID storedRepoUuid) {
        ITeamRepository result = null;
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUriString, 4);
        if (JzProvider.checkTeamRepository(repo, storedRepoUuid)) {
            result = repo;
        }
        if (result == null && fallbackUri != null && JzProvider.checkTeamRepository(repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(fallbackUri, 4), storedRepoUuid)) {
            result = repo;
        }
        if (result == null && storedRepoUuid != null) {
            ITeamRepository[] repos;
            ITeamRepository[] iTeamRepositoryArray = repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository candidate = iTeamRepositoryArray[n2];
                if (JzProvider.checkTeamRepository(candidate, storedRepoUuid)) {
                    result = candidate;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private static boolean checkTeamRepository(ITeamRepository repo, UUID storedRepoUuid) {
        boolean result = false;
        if (repo != null && repo.loggedIn()) {
            result = true;
            if (storedRepoUuid != null) {
                result = repo.root().getItemId().equals((Object)storedRepoUuid);
            }
        }
        return result;
    }

    public static void setRepoRootUuid(Map<String, String> args, String repoUuidValue) {
        args.put(IA_REPOSITORY_ROOT_UUID, repoUuidValue);
    }

    public void setRepoRootUuid(Map<String, String> args) {
        JzProvider.setRepoRootUuid(args, this.getRepo().root().getItemId().getUuidValue());
    }

    public static String lookupRepoRootUuid(Map<String, String> args) {
        return args.get(IA_REPOSITORY_ROOT_UUID);
    }

    public String lookupRepoRootUuid() {
        return JzProvider.lookupRepoRootUuid(this._initArgs);
    }

    public boolean setRepoRootUuidIfNecessary(Map<String, String> args) {
        boolean isNecessary;
        boolean bl = isNecessary = !args.containsKey(IA_REPOSITORY_ROOT_UUID);
        if (isNecessary) {
            this.setRepoRootUuid(args);
        }
        return isNecessary;
    }

    public static final boolean isThisHostWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static String getIsThisHostWindows() {
        return JzProvider.isThisHostWindows() ? "true" : "false";
    }

    public static String getLocalHostname() throws WvcmException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new WvcmException(Messages.JzProvider_ERROR_COULD_NOT_GET_LOCAL_HOSTNAME, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static ITeamRepository doLogin(String repoUriString, String authLoginName, String authPassword) {
        try {
            return JzProvider.doLoginThrowsTRE(repoUriString, authLoginName, authPassword, true);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException("login failed", e);
        }
    }

    public static ITeamRepository doLoginThrowsTRE(String repoUriString, final String authLoginName, final String authPassword, boolean managed) throws TeamRepositoryException {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        ITeamRepository result = managed ? teamRepositoryService.getTeamRepository(repoUriString, 2) : teamRepositoryService.getUnmanagedRepository(repoUriString);
        result.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getPassword() {
                        return authPassword;
                    }

                    public String getUserId() {
                        return authLoginName;
                    }
                };
            }
        });
        result.login(null);
        if (managed) {
            teamRepositoryService.addTeamRepository(result);
        }
        return result;
    }

    public static Feedback nonNullFeedback(Feedback feedback) {
        return feedback != null ? feedback : DetailedFeedback.fb(null);
    }

    public ResourceList<Folder> activityFolderList(PropertyRequestItem.PropertyRequest propertyRequest) throws WvcmException {
        throw new WvcmException("activityFolderList is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    public JzRepoControllableFolder doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        boolean isSymbolicLinkControlledFolderLocation;
        JzLocation jzLoc = JzLocation.create(location);
        boolean isBaselineControlledFolderLocation = jzLoc.kind() == JzLocation.Kind.BaselineControlledFolder;
        boolean bl = isSymbolicLinkControlledFolderLocation = jzLoc.kind() == JzLocation.Kind.SymbolicLink;
        if (isBaselineControlledFolderLocation) {
            JzRepoBaselineControlledFolder result = JzRepoBaselineControlledFolder.doCreateResource(this, jzLoc, feedback);
            return result;
        }
        if (isSymbolicLinkControlledFolderLocation) {
            JzRepoResource result = JzRepoSymbolicLink.doCreateSymbolicLink(this, jzLoc, updates, updated, feedback);
            result.doWriteProperties(updates, updated, feedback);
            return (JzRepoControllableFolder)result;
        }
        JzRepoResource result = JzRepoControllableFolder.doCreate(this, jzLoc, feedback);
        return (JzRepoControllableFolder)result;
    }

    public SrvcResource doCreateControllableResource(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableResource.doCreateControllableResource(this, JzLocation.create(genericLocation), feedback);
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoSymbolicLink.doCreateSymbolicLink(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        if (isStream) {
            return JzRepoStream.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
        }
        return JzRepoChangeSet.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedWorkspace(Location locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkspace.doCreateGeneratedWorkspace(this, JzLocation.create(locationHint), updates, updated, feedback);
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateVersionControlledResource(this, location, versionLoc, feedback);
    }

    public JzRepoControllableFolder doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource folder = this.lookup(location, feedback);
        if (folder != null) {
            if (folder instanceof JzRepoBaselineControlledFolder) {
                return (JzRepoBaselineControlledFolder)folder;
            }
            throw new WvcmException("Must be a controllable folder", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        return (JzRepoBaselineControlledFolder)this.doCreateControllableFolder(location, (Map)updates, (List)updated, feedback);
    }

    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateBaselineControlledFolder(this, location, baselineLoc, feedback);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkItem.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doFind(Resource query, SrvcFeedback feedback) throws WvcmException {
        List<SrvcResource> result = this.doFind(query, false, feedback);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List<SrvcResource> doFindAll(Resource query, SrvcFeedback feedback) throws WvcmException {
        return this.doFind(query, true, feedback);
    }

    private List<SrvcResource> doFind(Resource query, boolean all, SrvcFeedback feedback) throws WvcmException {
        Object compNameVal;
        Object requestedIdVal;
        List<SrvcResource> result = Collections.emptyList();
        if (query instanceof Task && (requestedIdVal = query.lookupProperty(InteropStream.PN_TASK_ID)) instanceof String) {
            String requestedId = (String)requestedIdVal;
            JzRepoWorkItem requestedItem = JzRepoWorkItem.lookupById(this, requestedId, feedback);
            result = new ArrayList(1);
            result.add(requestedItem);
            return result;
        }
        if (query instanceof Component && (compNameVal = query.lookupProperty(Component.DISPLAY_NAME)) instanceof String) {
            String compName = (String)compNameVal;
            JzLocation compLoc = JzLocation.createComponentNameLocation(compName);
            JzRepoComponent comp = (JzRepoComponent)this.lookup((Location)compLoc, feedback);
            result = new ArrayList<SrvcResource>(1);
            result.add(comp);
            return result;
        }
        if (query instanceof VersionHistory || query instanceof Task || query instanceof Component) {
            return this.doFindClone(query, all, feedback);
        }
        if (query instanceof Stream) {
            if (!all) {
                throw new WvcmException("doFindStream NYI when all is false", WvcmException.ReasonCode.FORBIDDEN);
            }
            return this.doFindStream(feedback);
        }
        if (query instanceof Version) {
            return this.doFindVersionInWorkspace((Version)query, all, feedback);
        }
        if (query instanceof Configuration) {
            Configuration confQuery = (Configuration)query;
            Component queryComp = (Component)confQuery.getVersionHistory();
            JzLocation compLoc = JzLocation.create(queryComp.getPathnameLocation());
            JzLocation wsLoc = JzLocation.create(confQuery.getWorkspace().getPathnameLocation());
            JzRepoWorkspace jzWS = new JzRepoWorkspace(this, wsLoc);
            IConfiguration conf = jzWS.lookupConfiguration(compLoc, feedback);
            if (conf != null) {
                result = new ArrayList<SrvcResource>(1);
                JzLocation configLoc = JzLocation.createConfigurationLoc(wsLoc, compLoc);
                JzRepoConfiguration config = (JzRepoConfiguration)this.lookup((Location)configLoc, feedback);
                result.add(config);
            }
            return result;
        }
        if (query instanceof ControllableResource) {
            JzLocation wsLoc;
            JzRepoWorkspace jzWS;
            result = new ArrayList<SrvcResource>(1);
            ControllableResource crQuery = (ControllableResource)query;
            VersionHistory queryVh = crQuery.getVersionHistory();
            Location vhLoc = queryVh.getPathnameLocation();
            JzRepoVersionHistory jzV = (JzRepoVersionHistory)this.get(vhLoc, feedback);
            JzRepoControllableResource cr = jzV.createControllableResource(jzWS = new JzRepoWorkspace(this, wsLoc = JzLocation.create(crQuery.getWorkspace().getPathnameLocation())), feedback);
            if (cr != null) {
                cr = (JzRepoControllableResource)this.lookup((Location)cr.location(), feedback);
                result.add(cr);
            }
            return result;
        }
        throw new WvcmException("Unhandled query", WvcmException.ReasonCode.FORBIDDEN);
    }

    private List<SrvcResource> doFindVersionInWorkspace(Version query, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(1);
        ResourceList workspaceQueryList = query.getInWorkspaceList();
        JzLocation workspaceLoc = JzLocation.create(((Workspace)workspaceQueryList.get(0)).getPathnameLocation());
        JzRepoWorkspace workspace = (JzRepoWorkspace)this.get((Location)workspaceLoc, feedback);
        VersionHistory vhQuery = query.getVersionHistory();
        JzLocation vhLoc = JzLocation.create(vhQuery.getPathnameLocation());
        JzRepoVersionHistory vh = (JzRepoVersionHistory)this.get((Location)vhLoc, feedback);
        JzRepoVersion resultVersion = JzRepoWorkspace.locateByHistory(this, workspace.getConnection(feedback), vh, feedback);
        if (resultVersion != null) {
            JzLocation vLoc = resultVersion.location();
            feedback.setResourceCache((Location)vLoc, this.createContextProxy(resultVersion, (Location)vLoc, workspace, feedback));
        }
        results.add(resultVersion);
        return results;
    }

    private List<SrvcResource> doFindClone(Resource query, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>(1);
        String cloneValue = (String)query.getProperty(InteropStream.PN_CLONE);
        if (query instanceof VersionHistory && !(query instanceof Component)) {
            List<JzRepoVersionHistory> jrvhs = JzRepoVersionHistory.getClonesOfTargets(this, Collections.singletonList(cloneValue), feedback);
            JzRepoVersionHistory jrvh = jrvhs.get(0);
            result.add(jrvh);
        } else {
            JzLocation resultLoc;
            JzRepoWorkItem resultWI;
            IItemHandle foundItem = JzRepoResource.lookupByCloneValue(this, InteropStream.PN_CLONE, cloneValue, feedback);
            if (foundItem == null) {
                result.add(null);
            } else if (query instanceof Component) {
                JzRepoComponent comp = JzRepoComponent.create((IComponentHandle)foundItem, this);
                result.add(comp);
            } else if (query instanceof Task && (resultWI = (JzRepoWorkItem)this.lookup((Location)(resultLoc = JzLocation.createWorkItemLoc(JzRepoResource.getCurrentStateDisplayName(foundItem))), feedback)) != null) {
                result.add(resultWI);
            }
        }
        return result;
    }

    private List<SrvcResource> doFindStream(SrvcFeedback feedback) throws WvcmException {
        IProcessArea processAreaHandle = this.getProcessArea(feedback.nest(10));
        List<IProcessArea> processAreaHandles = Collections.singletonList(processAreaHandle);
        List<SrvcResource> streams = this.findStreams(processAreaHandles, feedback);
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(streams.size());
        results.addAll(streams);
        return results;
    }

    public List<Stream> findStreams(List<IProcessAreaHandle> processAreaHandles, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback f) throws WvcmException {
        List<IWorkspace> streams = this.findStreams(processAreaHandles, JzProvider.getMonitor(f, 50));
        ArrayList<Stream> results = new ArrayList<Stream>(streams.size());
        for (IWorkspace stream : streams) {
            JzLocation streamLoc = JzRepoStream.createStreamLocation((IItemHandle)stream);
            Stream result = (Stream)this.buildProxy((Location)streamLoc, propertyRequest, f);
            results.add(result);
        }
        return results;
    }

    private List<SrvcResource> findStreams(List<IProcessAreaHandle> processAreaHandles, SrvcFeedback f) throws WvcmException {
        List<IWorkspace> streams = this.findStreams(processAreaHandles, JzProvider.getMonitor(f, 50));
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(streams.size());
        for (IWorkspace stream : streams) {
            JzLocation streamLoc = JzRepoStream.createStreamLocation((IItemHandle)stream);
            JzRepoStream result = (JzRepoStream)this.lookup((Location)streamLoc, f);
            results.add(result);
        }
        return results;
    }

    private List<IWorkspace> findStreams(List<IProcessAreaHandle> processAreaHandles, IProgressMonitor monitor) throws WvcmException {
        if (processAreaHandles.size() == 0) {
            return new ArrayList<IWorkspace>();
        }
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        criteria.getFilterByOwnerOptional().addAll(processAreaHandles);
        try {
            List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepo()).findWorkspaces(criteria, Integer.MAX_VALUE, monitor);
            List streams = this.getRepo().itemManager().fetchCompleteItems(handles, 0, monitor);
            return streams;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public ITeamRepository getRepo() {
        return this._jazzRepository;
    }

    public String lookupProcessAreaPathInitArg() {
        return JzProvider.getProcessAreaPath(this._initArgs);
    }

    public static String getProcessAreaPath(Map<String, String> args) {
        String result = args.get(IA_TEAM_AREA_PATH);
        if (result != null) {
            return result;
        }
        return args.get("processAreaPath");
    }

    public static void setProcessAreaPathInitArg(Map<String, String> args, String path) {
        args.put(IA_TEAM_AREA_PATH, path);
    }

    public JzLocation location(String string) throws WvcmException {
        return new JzLocation(string);
    }

    public JzRepoResource get(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource result = this.lookup(genericLocation, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_NOT_FOUND_WITH_LOC_STRING, (Object)genericLocation.string(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public JzRepoResource lookup(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        if (genericLocation == null) {
            return null;
        }
        JzLocation loc = JzLocation.create(genericLocation);
        JzRepoResource result = null;
        JzLocation.Kind kind = loc.kind();
        try {
            switch (kind) {
                case Baseline: {
                    result = JzRepoBaseline.lookup(this, loc, feedback);
                    break;
                }
                case BaselineControlledFolder: {
                    result = JzRepoBaselineControlledFolder.lookup(this, loc, feedback);
                    break;
                }
                case ChangeSet: {
                    result = JzRepoChangeSet.lookup(this, loc, feedback);
                    break;
                }
                case ControllableFolder: 
                case ControllableResource: 
                case FileSysPath: 
                case NewControllableFolder: 
                case SymbolicLink: {
                    result = JzRepoControllableResource.lookup(this, loc, feedback);
                    break;
                }
                case Component: {
                    result = JzRepoComponent.lookup(this, loc, feedback);
                    break;
                }
                case Configuration: {
                    result = JzRepoConfiguration.lookup(this, loc, feedback);
                    break;
                }
                case Pathname: {
                    result = this.lookupByPathname(loc, feedback);
                    break;
                }
                case RootVersion: {
                    result = new JzRepoRootVersion(this, (Location)loc);
                    break;
                }
                case RootBaseline: {
                    result = new JzRepoRootBaseline(this, loc);
                    break;
                }
                case Stream: {
                    result = JzRepoStream.lookup(this, loc);
                    break;
                }
                case Version: {
                    result = this.resolveVersion(loc, feedback);
                    break;
                }
                case VersionHistory: {
                    result = JzRepoVersionHistory.lookup(this, loc, feedback);
                    break;
                }
                case Workspace: {
                    result = JzRepoWorkspace.lookup(this, loc, feedback);
                    break;
                }
                case WorkItem: {
                    result = JzRepoWorkItem.lookup(this, loc);
                }
            }
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                this.logIgnoredExceptionAsNotAlwaysVisible("JzProvider.lookup", (Exception)((Object)e));
            }
            throw e;
        }
        return result;
    }

    private JzRepoResource lookupByPathname(JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoResource result = null;
        try {
            String wsUuid;
            JzRepoWorkspace ws;
            String pathKind;
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(loc.getPath()));
            if (segments.size() > 2 && (pathKind = (String)segments.remove(0)).equalsIgnoreCase(JzLocation.kindWorkspaceString) && (ws = JzRepoWorkspace.lookupByPathname(this, wsUuid = (String)segments.remove(0))) != null) {
                JzLocation resultLoc = ws.location();
                for (String segment : segments) {
                    resultLoc = resultLoc.child(segment);
                }
                result = this.lookup((Location)resultLoc, feedback);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            this.logIgnoredExceptionAsNotAlwaysVisible("JzProvider.lookupByPathname", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    public JzRepoVersion resolveVersion(JzLocation loc, SrvcFeedback feedback) {
        JzRepoVersion result;
        block3: {
            result = null;
            try {
                IVersionableHandle h = (IVersionableHandle)JzRepoResource.getItemHandle(this, loc);
                if (h != null) {
                    result = JzRepoVersion.createAppropriateProxy(this, loc, (IItemHandle)h, feedback);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof Exception)) break block3;
                this.logIgnoredExceptionAsAlwaysVisible("JzProvider.resolveVersion", (Exception)e);
            }
        }
        return result;
    }

    public ResourceList<Folder> workspaceFolderList(PropertyRequestItem.PropertyRequest propertyRequest) {
        ResourceList resList = this.resourceList((Resource[])new Folder[0]);
        resList.add((Object)this.folder(JzLocation.workspaceFolderList()));
        return resList;
    }

    public JzLocation rootLocation() {
        return JzLocation.root();
    }

    public JzLocation relativeRootLocation() {
        return JzLocation.relativeRoot();
    }

    public IProcessAreaHandle lookupProcessAreaHandle(SrvcFeedback feedback) throws WvcmException {
        IProcessArea result = null;
        String processAreaPath = this.lookupProcessAreaPathInitArg();
        if (processAreaPath != null) {
            try {
                result = (IProcessAreaHandle)JzRepoResource.lookupItemHandle(this, new URI(processAreaPath));
            }
            catch (URISyntaxException e) {
                throw new WvcmException("lookupProcessAreaByPath: " + processAreaPath, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
            }
        } else {
            result = JzProvider.lookupProcessArea("Interop SCM", this.getRepo(), feedback);
        }
        return result;
    }

    public static IProcessArea lookupProcessArea(String processAreaName, ITeamRepository teamRepository, SrvcFeedback feedback) throws WvcmException {
        IProcessClientService processClientLibrary = (IProcessClientService)teamRepository.getClientLibrary(IProcessClientService.class);
        try {
            IProcessArea area = processClientLibrary.findProcessArea(new URI(JzProvider.convertToURI(processAreaName)), IProcessClientService.ALL_PROPERTIES, JzProvider.getMonitor(feedback, 100));
            return area;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
        catch (URISyntaxException e) {
            throw JzProvider.wrapException(e);
        }
    }

    private static String convertToURI(String path) throws WvcmException {
        try {
            path = URLEncoder.encode(path, "UTF-8");
            return path.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new WvcmException("huh?", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static IQueryService getQueryService(ITeamRepository teamRepository) {
        IClientLibraryContext context = (IClientLibraryContext)teamRepository;
        IQueryService qs = (IQueryService)context.getServiceInterface(IQueryService.class);
        return qs;
    }

    private Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        }
        return this._log;
    }

    public boolean isDebugLogEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public void logCreation(String objectKind, JzLocation requestedLocation, String resourceIdentifer, String otherInfo) {
        if (this.isDebugLogEnabled()) {
            this.logDebug("created " + objectKind + "at requested location: " + requestedLocation.string() + " with resource Id: " + resourceIdentifer + " " + otherInfo);
        }
    }

    public void logCreation(String objectKind, JzLocation objectLocation) {
        if (this.isDebugLogEnabled()) {
            this.logDebug("created " + objectKind + " with location: " + objectLocation.string());
        }
    }

    public void logInfo(String msg) {
        System.out.println(msg);
    }

    public void logDebug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public void logIgnoredExceptionAsNotAlwaysVisible(String methodName, Exception e) {
        this.logDebug("Ignored Exception: method: " + methodName + " is ignoring exception: " + e.getMessage());
    }

    public void logIgnoredExceptionAsNotAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.logDebug("Ignored Exception: method: " + methodName + " is ignoring exception: " + e.getMessage() + "with extra description: " + extraDescription);
    }

    public void logIgnoredExceptionAsAlwaysVisible(String methodName, Exception e) {
        this.logInfo(NLS.bind((String)Messages.JzProvider_IGNORED_EXCEPTION, (Object)methodName, (Object[])new Object[]{e.getMessage()}));
    }

    public void logIgnoredExceptionAsAlwaysVisible(String methodName, Exception e, String extraDescription) {
        this.logInfo(NLS.bind((String)Messages.JzProvider_IGNORED_EXCEPTION_WITH_EXTRA_DESCRIPTION, (Object)methodName, (Object[])new Object[]{e.getMessage(), extraDescription}));
    }

    public IProjectArea getProjectArea(SrvcFeedback feedback) throws WvcmException {
        IProjectAreaHandle projectAreaHandle;
        IProcessArea processArea = this.getProcessArea(feedback);
        IProjectArea result = ItemUtil.equivItemRef((IItemHandle)processArea, (IItemHandle)(projectAreaHandle = processArea.getProjectArea())) ? (IProjectArea)processArea : (IProjectArea)this.fetchCompleteProcessArea((IProcessAreaHandle)projectAreaHandle, feedback);
        return result;
    }

    public IProcessArea getProcessArea(SrvcFeedback feedback) throws WvcmException {
        IProcessAreaHandle h = this.lookupProcessAreaHandle(feedback);
        if (h == null) {
            throw new IllegalStateException("Could not get team area handle from JzProvider initArgs");
        }
        return this.fetchCompleteProcessArea(h, feedback);
    }

    public IProcessArea fetchCompleteProcessArea(IProcessAreaHandle processAreaHandle, SrvcFeedback feedback) throws WvcmException {
        ITeamRepository repo = this.getRepo();
        try {
            IProcessArea result = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public String setDefaultComponentRI(String value) {
        return this._initArgs.put(IA_DEFAULT_COMPONENT_RI, value);
    }

    public String getDefaultComponentRI() {
        return (String)this._initArgs.get(IA_DEFAULT_COMPONENT_RI);
    }

    public static void setTemplateId(Map<String, String> args, String templateId) {
        args.put(IA_TEMPLATE_ID_NAME, templateId);
    }

    public static String getTemplateId(Map<String, String> args) {
        return args.get(IA_TEMPLATE_ID_NAME);
    }

    public String getTemplateId() {
        return JzProvider.getTemplateId(this._initArgs);
    }

    public boolean templateIdHasInitialValue() {
        return this.getTemplateId().equals(OLD_DEFAULT_TEMPLATE_ID) || this.getTemplateId().length() == 0;
    }

    public static String getSyncViaBuild(Map<String, String> args) {
        return args.get(IA_SYNC_VIA_BUILD);
    }

    public String getSyncViaBuild() {
        return JzProvider.getSyncViaBuild(this._initArgs);
    }

    public static void setSyncViaBuild(Map<String, String> args, String value) {
        args.put(IA_SYNC_VIA_BUILD, value);
    }

    public static String getRepositoryURI(Map<String, String> args) {
        String result = args.get(IA_REPOSITORY_URI);
        if (result != null) {
            return result;
        }
        return args.get("RepositoryURI");
    }

    public String getRepositoryURI() {
        return JzProvider.getRepositoryURI(this._initArgs);
    }

    public static String getSyncUserId(Map<String, String> args) {
        return args.get(IA_SYNC_USER_ID);
    }

    public String getSyncUserId() {
        return JzProvider.getSyncUserId(this._initArgs);
    }

    public static void setSyncUserId(Map<String, String> args, String value) {
        args.put(IA_SYNC_USER_ID, value);
    }

    private void setSyncUserIdToDefault(Map<String, String> args) {
        String systemSyncUserIdString = System.getProperty(IA_SYNC_USER_ID);
        String idString = systemSyncUserIdString != null ? systemSyncUserIdString : DEFAULT_SYNC_USER_ID;
        JzProvider.setSyncUserId(args, idString);
    }

    public String lookupBuildDefinitionLocationString() {
        return (String)this._initArgs.get(IA_BUILD_DEF_LOC_STR);
    }

    public void setBuildDefinitionLocationString(String locString) {
        this._initArgs.put(IA_BUILD_DEF_LOC_STR, locString);
    }

    public String lookupBuildResultLocationString() {
        return (String)this._initArgs.get(IA_BUILD_RESULT_LOC_STR);
    }

    public static void setBuildResultLocationString(Map<String, String> args, String locString) {
        args.put(IA_BUILD_RESULT_LOC_STR, locString);
    }

    public static String lookupBuildEngineName(Map<String, String> args) {
        return args.get(IA_BUILD_ENGINE_NAME);
    }

    public String lookupBuildEngineBasename() {
        return JzProvider.lookupBuildEngineName(this._initArgs);
    }

    public static void setBuildEngineName(Map<String, String> args, String name) {
        if (name == null) {
            args.remove(IA_BUILD_ENGINE_NAME);
        } else {
            args.put(IA_BUILD_ENGINE_NAME, name);
        }
    }

    public void setBuildEngineName(String name) {
        JzProvider.setBuildEngineName(this._initArgs, name);
    }

    public static void setInstallLocation(Map<String, String> args, String path) {
        args.put(IA_INSTALL_PATH, path);
    }

    public static String getInstallLocation(Map<String, String> args) {
        return args.get(IA_INSTALL_PATH);
    }

    public String getInstallLocation() {
        String installLocationValue = JzProvider.getInstallLocation(this._initArgs);
        if (installLocationValue == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.JzProvider_ERROR_INSTALL_PATH_PROP_MUST_BE_NON_NULL_WITH_PROPNAME, (Object)IA_INSTALL_PATH, (Object[])new Object[0]));
        }
        return installLocationValue;
    }

    public static void setBuildEngineSleepTime(Map<String, String> args, String sleepTimeString) {
        args.put(IA_SLEEP_TIME, sleepTimeString);
    }

    public String getBuildEngineSleepTime() {
        return JzProvider.getBuildEngineSleepTime(this._initArgs);
    }

    public static String getBuildEngineSleepTime(Map<String, String> args) {
        return args.get(IA_SLEEP_TIME);
    }

    public static void setSyncHost(Map<String, String> args, String hostname) {
        args.put(IA_SYNC_HOST, hostname);
    }

    public void setSyncHost(String hostname) {
        JzProvider.setSyncHost(this._initArgs, hostname);
    }

    public static String getSyncHost(Map<String, String> args) {
        return args.get(IA_SYNC_HOST);
    }

    public String getSyncHost() {
        return JzProvider.getSyncHost(this._initArgs);
    }

    public static void setSyncHostIsWindows(Map<String, String> args, String syncHostIsWindows) {
        args.put(IA_SYNC_HOST_IS_WINDOWS, syncHostIsWindows);
    }

    public void setSyncHostIsWindows(String syncHostIsWindows) {
        JzProvider.setSyncHostIsWindows(this._initArgs, syncHostIsWindows);
    }

    public static String getSyncHostIsWindows(Map<String, String> args) {
        return args.get(IA_SYNC_HOST_IS_WINDOWS);
    }

    public String getSyncHostIsWindows() {
        return JzProvider.getSyncHostIsWindows(this._initArgs);
    }

    public static String getSymlinksSupported(Map<String, String> args) {
        return args.get(IA_SYMLINKS_SUPPORTED);
    }

    public String getSymlinksSupported() {
        String areSymlinksSupported = JzProvider.getSymlinksSupported(this._initArgs);
        if (areSymlinksSupported != null) {
            return areSymlinksSupported;
        }
        return "false";
    }

    public static void setSymlinksSupported(Map<String, String> args, String symlinksSupported) {
        args.put(IA_SYMLINKS_SUPPORTED, symlinksSupported);
    }

    public void setSymlinksSupported(String symlinksSupported) {
        JzProvider.setSymlinksSupported(this._initArgs, symlinksSupported);
    }

    public String getScriptLocationPrefix() {
        return JzProvider.getScriptLocationPrefix(this._initArgs);
    }

    public static void setScriptLocationPrefix(Map<String, String> args, String value) {
        args.put(IA_SCRIPT_LOCATION_PREFIX, value);
    }

    public static String getScriptLocationPrefix(Map<String, String> args) {
        return args.get(IA_SCRIPT_LOCATION_PREFIX);
    }

    public void forEachExternalProxyWithTargetItemAndUri(IVisitCloneExternalProxy visitor) throws WvcmException {
        IInteropManager interopManager = (IInteropManager)this.getRepo().getClientLibrary(IInteropManager.class);
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            IExternalProxyHandle[] externalProxyHandles;
            IExternalProxyHandle[] iExternalProxyHandleArray = externalProxyHandles = interopManager.findProxiesBySyncRule(null, (IProgressMonitor)monitor);
            int n = externalProxyHandles.length;
            int n2 = 0;
            while (n2 < n) {
                boolean continueOn;
                IExternalProxyHandle externalProxyHandle = iExternalProxyHandleArray[n2];
                URI otherUri = interopManager.getUri(externalProxyHandle, (IProgressMonitor)monitor);
                IItemHandle thisItem = interopManager.getTargetItem(externalProxyHandle, (IProgressMonitor)monitor);
                if (otherUri == null || thisItem == null || !CcConnectorUtils.CLONED_ITEM_TYPES.contains(thisItem.getItemType()) || (continueOn = visitor.visit(externalProxyHandle, thisItem, otherUri))) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static InteropStream.LineSeparator lookupLineSeparator(Resource resource) {
        if (resource == null) {
            return null;
        }
        Object valLS = resource.lookupProperty(InteropStream.PN_LINE_SEPARATOR);
        if (valLS instanceof String) {
            return InteropStream.LineSeparator.valueOf((String)((String)valLS));
        }
        return null;
    }

    public static FileLineDelimiter getLineDelimiter(InteropStream.LineSeparator lineSeparator) {
        if (lineSeparator.equals((Object)InteropStream.LineSeparator.UNSPECIFIED)) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        if (lineSeparator.equals((Object)InteropStream.LineSeparator.LF)) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if (lineSeparator.equals((Object)InteropStream.LineSeparator.CR)) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        if (lineSeparator.equals((Object)InteropStream.LineSeparator.CRLF)) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if (lineSeparator.equals((Object)InteropStream.LineSeparator.PLATFORM)) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        throw new IllegalArgumentException("Unknown line separator value");
    }

    public static String getBuildKindValue(Map<String, String> args) {
        String value = args.get(IA_BUILD_KIND);
        return value;
    }

    public static BuildKind getBuildKind(Map<String, String> args) {
        String value = JzProvider.getBuildKindValue(args);
        BuildKind result = value == null ? null : BuildKind.valueOf(value);
        return result;
    }

    public BuildKind getBuildKind(BuildKind defaultBuildKind) {
        return JzProvider.getBuildKind(this._initArgs);
    }

    public static void setBuildKind(Map<String, String> args, BuildKind value) {
        args.put(IA_BUILD_KIND, value.name());
    }

    public static String getBuildCliPath(Map<String, String> args) {
        return args.get(IA_BUILD_CLI_PATH);
    }

    public static void setBuildCliPath(Map<String, String> args, String value) {
        args.put(IA_BUILD_CLI_PATH, value);
    }

    public String getBuildCliPath() {
        return JzProvider.getBuildCliPath(this._initArgs);
    }

    public boolean allowModModMerge(Map<String, String> args) {
        String value = args.get(IA_ALLOW_MOD_MOD_MERGE);
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public boolean allowModModMerge() {
        return this.allowModModMerge(this._initArgs);
    }

    public static void setAllowModModMerge(Map<String, String> args, boolean boolValue) {
        args.put(IA_ALLOW_MOD_MOD_MERGE, boolValue ? "true" : "false");
    }

    private void setMaxContentCommitDeferralMillis(Map<String, String> args, String value) {
        args.put(IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS, value);
    }

    private String getMaxContentCommitDeferralMillis(Map<String, String> args) {
        return args.get(IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS);
    }

    public boolean areContentCommitsDeferred() {
        return this.getMaxCommitLag() > 0L;
    }

    private Long getMaxCommitLag() {
        Long result = new Long(0L);
        String value = this.getMaxContentCommitDeferralMillis(this._initArgs);
        try {
            result = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            boolean oldValueCommitsAreDeferred = value != null && Boolean.valueOf(value) != false;
            result = oldValueCommitsAreDeferred ? DEFAULT_MAX_COMMIT_LAG : 0L;
        }
        return result;
    }

    public String lookupStreamScriptDir() {
        return (String)this._initArgs.get(IA_STREAM_SCRIPT_DIR_PATH);
    }

    public void setStreamScriptDir(String streamScriptDir) {
        Map args = this._initArgs;
        JzProvider.setStreamScriptDir(args, streamScriptDir);
    }

    public static void setStreamScriptDir(Map<String, String> args, String streamScriptDir) {
        args.put(IA_STREAM_SCRIPT_DIR_PATH, streamScriptDir);
    }

    public void deferOrCommitContentOp(JzRepoConfiguration wvcmConfiguration, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        Long timeOfFirstDeferredOp = this.deferrals.add(wvcmConfiguration, configOp, location);
        Long now = System.currentTimeMillis();
        Long ageOfFirstDeferredOp = now - timeOfFirstDeferredOp;
        if (ageOfFirstDeferredOp >= this.getMaxCommitLag()) {
            this.deferrals.applyDeferredContentCommits(feedback);
        }
    }

    public static String myToString(String separator, String ... parts) {
        if (parts == null) {
            return new String();
        }
        StringBuffer result = new StringBuffer();
        boolean needSep = false;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String onePart = stringArray[n2];
            if (needSep) {
                result.append(separator);
            } else {
                needSep = true;
            }
            result.append(onePart);
            ++n2;
        }
        return result.toString();
    }

    public IContributor getContributor(String userId, SrvcFeedback feedback) throws WvcmException {
        try {
            IContributorManager s = this.getRepo().contributorManager();
            IContributor result = s.fetchContributorByUserId(userId, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public List<Object> doFind(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        BatchedQueryKind queryKind = BatchedQueryKind.UNOPTIMIZED;
        ArrayList<String> cloneValues = new ArrayList<String>(queries.size());
        ArrayList<ControllableResource> findCrQueries = new ArrayList<ControllableResource>(queries.size());
        for (Resource query : queries) {
            if (query instanceof VersionHistory) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_VH_CLONES.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_VH_CLONES;
                    cloneValues.add((String)query.getProperty(InteropStream.PN_CLONE));
                    continue;
                }
                throw new IllegalStateException("found VersionHistory query after finding query kind : " + queryKind.name());
            }
            if (query instanceof ControllableResource) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_CR_IN_WORKSPACE.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_CR_IN_WORKSPACE;
                    findCrQueries.add((ControllableResource)query);
                    continue;
                }
                throw new IllegalStateException("found ControllableResource query after finding query kind : " + queryKind.name());
            }
            if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind)) continue;
            throw new IllegalStateException("found unoptimized query after finding query kind : " + queryKind.name());
        }
        ArrayList<Object> results = new ArrayList(queries.size());
        switch (queryKind) {
            case FIND_VH_CLONES: {
                List<JzRepoVersionHistory> vhClones = JzRepoVersionHistory.getClonesOfTargets(this, cloneValues, feedback);
                results.addAll(vhClones);
                break;
            }
            case FIND_CR_IN_WORKSPACE: {
                List<JzRepoControllableResource> crs = JzRepoVersionHistory.computeControllableResources(this, findCrQueries, feedback);
                results.addAll(crs);
                break;
            }
            default: {
                results = super.doFind(queries, feedback);
            }
        }
        return results;
    }

    public static IProgressMonitor getMonitor(Feedback feedback, int percentDone) {
        if (feedback != null && feedback instanceof FB) {
            return ((FB)feedback).getMonitor(percentDone);
        }
        return new NullProgressMonitor();
    }

    public static IProgressMonitor getMonitor(SrvcFeedback srvcFeedback, int percentDone) {
        if (srvcFeedback != null) {
            return JzProvider.getMonitor(srvcFeedback.get_feedback(), percentDone);
        }
        return new NullProgressMonitor();
    }

    public JzRepoResource doWriteContent(Location location, InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableResource srvcResource = (JzRepoControllableResource)this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = (JzRepoControllableResource)JzRepoControllableResource.doCreateResourceWithContent(this, JzLocation.create(location), input, contentIdentifier, updates, updated, feedback);
        } else {
            srvcResource.doWriteContent(input, contentIdentifier, updates, updated, feedback);
        }
        return srvcResource;
    }

    public List<Object> doUpdateContextProperties(List<Location> locations, Location contextLocation, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, SrvcFeedback feedback) throws WvcmException {
        boolean requiresUnbatched = false;
        int size = locations.size();
        ArrayList<Object> results = new ArrayList<Object>(size);
        HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>();
        int i = 0;
        while (i < size) {
            Map<PropertyNameList.PropertyName<?>, PropValue> updates = updatesList.get(i);
            if (updates.size() > 0) {
                for (PropertyNameList.PropertyName<?> propertyName : updates.keySet()) {
                    if (InteropStream.PN_CLONE.equals(propertyName)) continue;
                    requiresUnbatched = true;
                    break;
                }
            } else {
                requiresUnbatched = true;
            }
            if (requiresUnbatched) {
                return super.doUpdateContextProperties(locations, contextLocation, updatesList, updatedList, feedback);
            }
            JzRepoResource jrr = this.get(locations.get(i), feedback);
            results.add((Object)jrr);
            PropValue propValue = updates.get(InteropStream.PN_CLONE);
            String value = (String)propValue.get_value();
            sources2Values.put(jrr, value);
            ++i;
        }
        JzRepoResource.storeInteropCloneValues(this, sources2Values, feedback);
        ArrayList<PropertyNameList.PropertyName> cloneUpdate = new ArrayList<PropertyNameList.PropertyName>();
        cloneUpdate.add(InteropStream.PN_CLONE);
        int i2 = 0;
        while (i2 < locations.size()) {
            updatedList.add(cloneUpdate);
            ++i2;
        }
        return results;
    }

    public static WvcmException wrapExceptionGivenExternalizedMsg(String externalizedMsg, Exception e) {
        return new WvcmException(externalizedMsg, null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
    }

    public static WvcmException wrapException(Exception e) {
        return new WvcmException(e.getMessage(), null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
    }

    public static void validateNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("parameter must not be null: " + name);
        }
    }

    public static void validateNotEmpty(String parameterName, String parameterValue) throws IllegalArgumentException {
        JzProvider.validateNotNull("parameterName", parameterName);
        JzProvider.validateNotNull(parameterName, parameterValue);
        if (parameterValue.length() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} must not be empty", (Object)parameterName, (Object[])new Object[0]));
        }
    }

    public static boolean testingThrownException(String triggerEvName) {
        String testingThrownExceptions = System.getProperty(triggerEvName, null);
        if (testingThrownExceptions == null) {
            testingThrownExceptions = System.getenv(triggerEvName);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(testingThrownExceptions);
    }

    public void assertLicenseForSyncUser(IContributor contributor, boolean isImportOnlyStream, Feedback feedback) throws WvcmException {
        ILicenseClient clientLibrary = (ILicenseClient)this.getRepo().getClientLibrary(ILicenseClient.class);
        String operationId = JzProvider.getLicenseOperationId(isImportOnlyStream);
        try {
            clientLibrary.assertLicenseForContributor(operationId, (IContributorHandle)contributor, JzProvider.getMonitor(feedback, 100));
            boolean testingThrownExceptions = JzProvider.testingThrownException("com.ibm.team.connector.scm.client.forceLicensingException");
            if (testingThrownExceptions) {
                throw new LicenseNotGrantedException("This is a test of the exception for : com.ibm.team.connector.scm.cc.update-sync-stream");
            }
        }
        catch (LicenseNotGrantedException e) {
            String msg = isImportOnlyStream ? Messages.JzProvider_ERROR_USER_NOT_LICENSED_TO_IMPORT : Messages.JzProvider_ERROR_SYNC_USER_NOT_LICENSED_TO_SYNC;
            throw new WvcmException(NLS.bind((String)msg, (Object)contributor.getName(), (Object[])new Object[0]), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            String msg = isImportOnlyStream ? Messages.JzProvider_ERROR_CANT_CHECK_LICENSE_TO_IMPORT : Messages.JzProvider_ERROR_CANT_CHECK_LICENSE_TO_SYNC;
            throw new WvcmException(msg, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static String getLicenseOperationId(boolean isImportOnlyStream) {
        String operationId = isImportOnlyStream ? IMPORT_STREAM_LICENSE_ID : UPDATE_SYNC_STREAM_LICENSE_ID;
        return operationId;
    }

    public IProcessArea getOwnerProcessArea(String processAreaLocString, SrvcFeedback feedback) throws WvcmException {
        JzLocation processAreaLoc = new JzLocation(processAreaLocString);
        IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)JzRepoResource.lookupItemHandle(this, processAreaLoc);
        if (processAreaHandle == null) {
            throw new WvcmException(NLS.bind((String)Messages.ERROR_PROCESS_AREA_NOT_FOUND_WITH_URI_STRING0, (Object)processAreaLocString, (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        IProcessArea result = this.fetchCompleteProcessArea(processAreaHandle, feedback);
        return result;
    }

    public void applyDeferredContentCommits(SrvcFeedback feedback) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(feedback);
    }

    public void applyDeferredContentCommits(JzRepoConfiguration config, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(config, loc, feedback);
    }

    public void applyDeferredContentCommits(JzRepoConfiguration config, SrvcFeedback feedback) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(config, feedback);
    }

    public IBuildResult lookupBuildResult(SrvcFeedback feedback) throws WvcmException, TeamRepositoryException {
        IBuildResult buildResult = null;
        String buildResultLocationString = this.lookupBuildResultLocationString();
        if (buildResultLocationString != null) {
            try {
                ITeamRepository repo = this.getRepo();
                URI buildDefUri = new URI(buildResultLocationString);
                com.ibm.team.repository.common.Location usableLoc = com.ibm.team.repository.common.Location.location((com.ibm.team.repository.common.Location)com.ibm.team.repository.common.Location.location((URI)buildDefUri), (String)repo.getRepositoryURI(), null);
                buildResult = (IBuildResult)repo.itemManager().fetchPartialItem(usableLoc, 0, null, JzProvider.getMonitor(feedback, 55));
            }
            catch (URISyntaxException e) {
                JzProvider.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoWorkItem_WARN_CANT_CONS_URI, (Object)buildResultLocationString, (Object[])new Object[0]), e);
            }
        }
        return buildResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchedQueryKind {
        UNOPTIMIZED,
        FIND_VH_CLONES,
        FIND_CR_IN_WORKSPACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuildKind {
        ANT,
        CLI;

    }

    public static interface IVisitCloneExternalProxy {
        public boolean visit(IExternalProxyHandle var1, IItemHandle var2, URI var3) throws WvcmException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OpsForAllConfigurations {
        private Map<JzRepoConfiguration, Map<JzLocation, IWorkspaceConnection.IConfigurationOp>> deferredContentOps = new HashMap<JzRepoConfiguration, Map<JzLocation, IWorkspaceConnection.IConfigurationOp>>();
        Long timeOfFirstDeferredOp = null;

        OpsForAllConfigurations() {
        }

        public Long add(JzRepoConfiguration wvcmConfiguration, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) {
            if (this.timeOfFirstDeferredOp == null) {
                this.timeOfFirstDeferredOp = System.currentTimeMillis();
            }
            if (!this.deferredContentOps.containsKey((Object)wvcmConfiguration)) {
                this.deferredContentOps.put(wvcmConfiguration, new HashMap());
            }
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> deferredOps = this.deferredContentOps.get((Object)wvcmConfiguration);
            deferredOps.put(location, configOp);
            return this.timeOfFirstDeferredOp;
        }

        public void applyDeferredContentCommits(SrvcFeedback feedback) throws WvcmException {
            Set<JzRepoConfiguration> configs = this.deferredContentOps.keySet();
            for (JzRepoConfiguration config : configs) {
                this.applyDeferredContentCommits(config, feedback);
            }
            this.timeOfFirstDeferredOp = null;
        }

        public void applyDeferredContentCommits(JzRepoConfiguration config, SrvcFeedback feedback) throws WvcmException {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese = this.deferredContentOps.get((Object)config);
            if (commitThese != null) {
                this.commit(config, commitThese, feedback);
            }
        }

        private void commit(JzRepoConfiguration config, Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese, SrvcFeedback feedback) throws WvcmException {
            int count = commitThese.size();
            if (count > 0) {
                JzProvider.this.logDebug("committing deferred operations: " + String.valueOf(count));
                config.commit(commitThese, feedback);
                commitThese.clear();
            }
        }

        public void applyDeferredContentCommits(JzRepoConfiguration config, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese = this.deferredContentOps.get((Object)config);
            if (commitThese != null && commitThese.containsKey((Object)loc)) {
                config.commit(commitThese.get((Object)loc), loc, feedback);
                commitThese.remove((Object)loc);
            }
        }
    }
}

