/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FB
implements Feedback {
    private SubMonitor m_progressMonitor;
    private int m_nWork;
    private PropertyRequestItem.PropertyRequest m_resultPropertyRequest = null;
    private int m_nLastPercentCompleted = 0;
    private FB m_parent = null;
    private List<String> m_warningMsgsList = new ArrayList<String>();
    private boolean m_abortCanceled = false;

    private static int normalize(int percent) {
        if (percent > 100) {
            return 100;
        }
        if (percent < 0) {
            return 0;
        }
        return percent;
    }

    private SubMonitor convert(IProgressMonitor progressMonitor, int work) {
        Object pMon = progressMonitor instanceof SubMonitor ? ((SubMonitor)progressMonitor).newChild(work) : new SubProgressMonitor(progressMonitor, work);
        return SubMonitor.convert((IProgressMonitor)pMon, (int)100);
    }

    public FB(PropertyRequestItem.PropertyRequest resultPropertyRequest, int work, IProgressMonitor progressMonitor) {
        this.m_resultPropertyRequest = resultPropertyRequest;
        this.m_nWork = work;
        this.m_progressMonitor = this.convert(progressMonitor, work);
    }

    public FB(int work, IProgressMonitor progressMonitor) {
        this.m_nWork = work;
        this.m_progressMonitor = this.convert(progressMonitor, work);
    }

    public FB nest() {
        return this.nest(null, this.m_nLastPercentCompleted);
    }

    public FB nest(PropertyRequestItem.PropertyRequest propertyRequest) {
        return this.nest(propertyRequest, this.m_nLastPercentCompleted);
    }

    public FB nest(int percentToBeCompleted) {
        return this.nest(null, percentToBeCompleted);
    }

    public FB nest(PropertyRequestItem.PropertyRequest resultPropertyRequest, int percentToBeCompleted) {
        if (this.m_nWork == 0 && (resultPropertyRequest == null ? this.m_resultPropertyRequest == null : resultPropertyRequest.equals((Object)this.m_resultPropertyRequest))) {
            return this;
        }
        int normPercentToBeCompleted = FB.normalize(percentToBeCompleted);
        int work = FB.normalize(normPercentToBeCompleted - this.m_nLastPercentCompleted);
        if (work > 0) {
            this.m_nLastPercentCompleted = normPercentToBeCompleted;
        }
        FB result = new FB(resultPropertyRequest, work, (IProgressMonitor)this.m_progressMonitor);
        result.m_parent = this.m_parent != null ? this.m_parent : this;
        return result;
    }

    public PropertyRequestItem.PropertyRequest getPropertyRequestForModified() {
        if (this.m_parent != null) {
            return this.m_parent.getPropertyRequestForModified();
        }
        return null;
    }

    public PropertyRequestItem.PropertyRequest getPropertyRequestForResult() {
        return this.m_resultPropertyRequest;
    }

    public void abortRequested(boolean isAbortRequested) {
        if (this.m_parent != null) {
            this.m_parent.abortRequested(isAbortRequested);
            return;
        }
        this.m_progressMonitor.setCanceled(isAbortRequested);
        this.m_abortCanceled = !isAbortRequested;
    }

    public boolean isAbortRequested() {
        if (this.m_parent != null) {
            return this.m_parent.isAbortRequested();
        }
        return this.m_progressMonitor.isCanceled() && !this.m_abortCanceled;
    }

    public String format(String fmt, Object ... arguments) {
        return MessageFormat.format(fmt, arguments);
    }

    public void notifyActive(String message) {
        this.m_progressMonitor.subTask(message);
    }

    public void notifyWarning(String message) {
        if (this.m_parent != null) {
            this.m_parent.notifyWarning(message);
            return;
        }
        this.m_warningMsgsList.add(message);
    }

    public void notifyIsModified(Resource resource) {
    }

    public void notifyPercentComplete(int percentComplete) {
        int normPercentComplete = FB.normalize(percentComplete);
        int work = normPercentComplete - this.m_nLastPercentCompleted;
        if (work > 0) {
            this.m_progressMonitor.worked(work);
            this.m_nLastPercentCompleted = normPercentComplete;
        }
    }

    public List<String> warnings() {
        if (this.m_parent != null) {
            return this.m_parent.m_warningMsgsList;
        }
        return this.m_warningMsgsList;
    }

    public IProgressMonitor getMonitor(int percentComplete) {
        if (this.m_nWork == 0) {
            return this.m_progressMonitor;
        }
        int normPercentComplete = FB.normalize(percentComplete);
        int work = FB.normalize(normPercentComplete - this.m_nLastPercentCompleted);
        if (work > 0) {
            this.m_nLastPercentCompleted = normPercentComplete;
        }
        return this.m_progressMonitor.newChild(work);
    }
}

