/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ServiceTracker$Tracked
extends Hashtable
implements ServiceListener {
    static final long serialVersionUID = -7420065199791006079L;
    private final ArrayList adding;
    private volatile boolean closed;
    private final LinkedList initial;
    final ServiceTracker this$0;

    protected ServiceTracker$Tracked(ServiceTracker serviceTracker) {
        this.this$0 = serviceTracker;
        this.closed = false;
        this.adding = new ArrayList(6);
        this.initial = new LinkedList();
    }

    protected void setInitialServices(ServiceReference[] serviceReferenceArray) {
        if (serviceReferenceArray == null) {
            return;
        }
        int n = serviceReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.initial.add(serviceReferenceArray[n2]);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackInitialServices() {
        while (true) {
            ServiceReference serviceReference;
            ServiceTracker$Tracked serviceTracker$Tracked = this;
            synchronized (serviceTracker$Tracked) {
                if (this.initial.size() == 0) {
                    return;
                }
                serviceReference = (ServiceReference)this.initial.removeFirst();
                if (this.get(serviceReference) != null) {
                    continue;
                }
                if (this.adding.contains(serviceReference)) {
                    continue;
                }
                this.adding.add(serviceReference);
            }
            this.trackAdding(serviceReference);
        }
    }

    protected void close() {
        this.closed = true;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (this.closed) {
            return;
        }
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        switch (serviceEvent.getType()) {
            case 1: 
            case 2: {
                if (this.this$0.noUserFilter) {
                    this.track(serviceReference);
                    break;
                }
                if (this.this$0.filter.match(serviceReference)) {
                    this.track(serviceReference);
                    break;
                }
                this.untrack(serviceReference);
                break;
            }
            case 4: {
                this.untrack(serviceReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void track(ServiceReference serviceReference) {
        Object v;
        ServiceTracker$Tracked serviceTracker$Tracked = this;
        synchronized (serviceTracker$Tracked) {
            v = this.get(serviceReference);
        }
        if (v != null) {
            serviceTracker$Tracked = this;
            synchronized (serviceTracker$Tracked) {
                this.this$0.modified();
            }
            this.this$0.customizer.modifiedService(serviceReference, v);
            return;
        }
        serviceTracker$Tracked = this;
        synchronized (serviceTracker$Tracked) {
            if (this.adding.contains(serviceReference)) {
                return;
            }
            this.adding.add(serviceReference);
        }
        this.trackAdding(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackAdding(ServiceReference serviceReference) {
        Object object = null;
        boolean bl = false;
        try {
            object = this.this$0.customizer.addingService(serviceReference);
        }
        catch (Throwable throwable) {
            ServiceTracker$Tracked serviceTracker$Tracked = this;
            synchronized (serviceTracker$Tracked) {
                if (((AbstractCollection)this.adding).remove(serviceReference)) {
                    if (object != null) {
                        this.put(serviceReference, object);
                        this.this$0.modified();
                        this.notifyAll();
                    }
                } else {
                    bl = true;
                }
            }
            throw throwable;
        }
        ServiceTracker$Tracked serviceTracker$Tracked = this;
        synchronized (serviceTracker$Tracked) {
            if (((AbstractCollection)this.adding).remove(serviceReference)) {
                if (object != null) {
                    this.put(serviceReference, object);
                    this.this$0.modified();
                    this.notifyAll();
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.this$0.customizer.removedService(serviceReference, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrack(ServiceReference serviceReference) {
        Object v;
        ServiceTracker$Tracked serviceTracker$Tracked = this;
        synchronized (serviceTracker$Tracked) {
            if (this.initial.remove(serviceReference)) {
                return;
            }
            if (((AbstractCollection)this.adding).remove(serviceReference)) {
                return;
            }
            v = this.remove(serviceReference);
            if (v == null) {
                return;
            }
            this.this$0.modified();
        }
        this.this$0.customizer.removedService(serviceReference, v);
    }
}

