/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS$1;
import org.eclipse.osgi.util.NLS$MessagesProperties;

public abstract class NLS {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    private static FrameworkLog frameworkLog;
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;
    static final Object ASSIGNED;

    static {
        ASSIGNED = new Object();
    }

    protected NLS() {
    }

    public static String bind(String string, Object object) {
        return NLS.internalBind(string, null, String.valueOf(object), null);
    }

    public static String bind(String string, Object object, Object object2) {
        return NLS.internalBind(string, null, String.valueOf(object), String.valueOf(object2));
    }

    public static String bind(String string, Object[] objectArray) {
        return NLS.internalBind(string, objectArray, null, null);
    }

    public static void initializeMessages(String string, Class clazz) {
        if (System.getSecurityManager() == null) {
            NLS.load(string, clazz);
            return;
        }
        AccessController.doPrivileged(new NLS$1(string, clazz));
    }

    private static String internalBind(String string, Object[] objectArray, String string2, String string3) {
        if (string == null) {
            return "No message available.";
        }
        if (objectArray == null || objectArray.length == 0) {
            objectArray = EMPTY_ARGS;
        }
        int n = string.length();
        int n2 = n + objectArray.length * 5;
        if (string2 != null) {
            n2 += string2.length() - 3;
        }
        if (string3 != null) {
            n2 += string3.length() - 3;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 < 0 ? 0 : n2);
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            switch (c) {
                case '{': {
                    int n4 = string.indexOf(125, n3);
                    if (n4 == -1) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (++n3 >= n) {
                        stringBuffer.append(c);
                        break;
                    }
                    int n5 = -1;
                    try {
                        n5 = Integer.parseInt(string.substring(n3, n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw (Throwable)new IllegalArgumentException();
                    }
                    if (n5 == 0 && string2 != null) {
                        stringBuffer.append(string2);
                    } else if (n5 == 1 && string3 != null) {
                        stringBuffer.append(string3);
                    } else {
                        if (n5 >= objectArray.length || n5 < 0) {
                            stringBuffer.append("<missing argument>");
                            n3 = n4;
                            break;
                        }
                        stringBuffer.append(objectArray[n5]);
                    }
                    n3 = n4;
                    break;
                }
                case '\'': {
                    int n6 = n3 + 1;
                    if (n6 >= n) {
                        stringBuffer.append(c);
                        break;
                    }
                    char c2 = string.charAt(n6);
                    if (c2 == '\'') {
                        ++n3;
                        stringBuffer.append(c);
                        break;
                    }
                    int n4 = string.indexOf(39, n6);
                    if (n4 == -1) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(string.substring(n6, n4));
                    n3 = n4;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String[] buildVariants(String string) {
        Object object;
        if (nlSuffixes == null) {
            object = Locale.getDefault().toString();
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (true) {
                arrayList.add(String.valueOf('_') + (String)object + EXTENSION);
                int n = object.lastIndexOf(95);
                if (n == -1) break;
                object = object.substring(0, n);
            }
            arrayList.add(EXTENSION);
            nlSuffixes = arrayList.toArray(new String[arrayList.size()]);
        }
        string = string.replace('.', '/');
        object = new String[nlSuffixes.length];
        int n = 0;
        while (n < ((String[])object).length) {
            object[n] = String.valueOf(string) + nlSuffixes[n];
            ++n;
        }
        return object;
    }

    private static void computeMissingMessages(String string, Class clazz, Map map, Field[] fieldArray, boolean bl) {
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 0x19) == 9 && map.get(field.getName()) != ASSIGNED) {
                try {
                    String string2 = "NLS missing message: " + field.getName() + " in: " + string;
                    if (Debug.DEBUG_MESSAGE_BUNDLES) {
                        System.out.println(string2);
                    }
                    NLS.log(2, string2, null);
                    if (!bl) {
                        ((AccessibleObject)field).setAccessible(true);
                    }
                    field.set(null, string2);
                }
                catch (Exception exception) {
                    NLS.log(4, "Error setting the missing message value for: " + field.getName(), exception);
                }
            }
            ++n2;
        }
    }

    static void load(String string, Class clazz) {
        long l = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader classLoader = clazz.getClassLoader();
        boolean bl = (clazz.getModifiers() & 1) != 0;
        int n = fieldArray.length;
        HashMap<String, Field> hashMap = new HashMap<String, Field>(n * 2);
        int n2 = 0;
        while (n2 < n) {
            hashMap.put(fieldArray[n2].getName(), fieldArray[n2]);
            ++n2;
        }
        String[] stringArray = NLS.buildVariants(string);
        int n3 = 0;
        while (n3 < stringArray.length) {
            block18: {
                InputStream inputStream;
                InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(stringArray[n3]) : classLoader.getResourceAsStream(stringArray[n3]);
                if (inputStream != null) {
                    try {
                        try {
                            NLS$MessagesProperties nLS$MessagesProperties = new NLS$MessagesProperties(hashMap, string, bl);
                            ((Properties)nLS$MessagesProperties).load(inputStream);
                        }
                        catch (IOException iOException) {
                            NLS.log(4, "Error loading " + stringArray[n3], iOException);
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++n3;
        }
        NLS.computeMissingMessages(string, clazz, hashMap, fieldArray, bl);
        if (Debug.DEBUG_MESSAGE_BUNDLES) {
            System.out.println("Time to load message bundle: " + string + " was " + (System.currentTimeMillis() - l) + "ms.");
        }
    }

    static void log(int n, String string, Exception exception) {
        String string2;
        if (frameworkLog != null) {
            frameworkLog.log(new FrameworkLogEntry("org.eclipse.osgi", n, 1, string, 0, exception, null));
            return;
        }
        switch (n) {
            case 4: {
                string2 = "Error: ";
                break;
            }
            default: {
                string2 = "Warning: ";
            }
        }
        if (string != null) {
            string2 = String.valueOf(string2) + string;
        }
        if (exception != null) {
            string2 = String.valueOf(string2) + ": " + ((Throwable)exception).getMessage();
        }
        System.err.println(string2);
        if (exception != null) {
            ((Throwable)exception).printStackTrace();
        }
    }
}

