/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;

public class SignedContentImpl$SignedContentEntryImpl
implements SignedContentEntry {
    private final String entryName;
    private final SignerInfo[] entrySigners;
    final SignedContentImpl this$0;

    public SignedContentImpl$SignedContentEntryImpl(SignedContentImpl signedContentImpl, String string, SignerInfo[] signerInfoArray) {
        this.this$0 = signedContentImpl;
        this.entryName = string;
        this.entrySigners = signerInfoArray == null ? SignedContentImpl.EMPTY_SIGNERINFO : signerInfoArray;
    }

    public String getName() {
        return this.entryName;
    }

    public SignerInfo[] getSignerInfos() {
        return this.entrySigners;
    }

    public boolean isSigned() {
        return this.entrySigners.length > 0;
    }

    public void verify() throws IOException, InvalidContentException {
        SignedBundleFile signedBundleFile = this.this$0.content;
        if (signedBundleFile == null) {
            throw (Throwable)new InvalidContentException("The content was not set", null);
        }
        BundleEntry bundleEntry = null;
        SecurityException securityException = null;
        try {
            bundleEntry = ((BundleFile)signedBundleFile).getEntry(this.entryName);
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
        }
        if (bundleEntry == null) {
            throw (Throwable)new InvalidContentException(NLS.bind(SignedContentMessages.file_is_removed_from_jar, this.entryName, ((BundleFile)signedBundleFile).getBaseFile().toString()), securityException);
        }
        bundleEntry.getBytes();
    }
}

