/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.signedcontent.SignedContentFile$SignedContentFileEntry;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;

public class SignedContentFile
implements SignedContent {
    private final SignedContentImpl signedContent;
    private HashMap entryExceptions = null;

    public SignedContentFile(SignedContentImpl signedContentImpl) {
        try {
            signedContentImpl.content.close();
        }
        catch (IOException iOException) {}
        this.signedContent = signedContentImpl;
    }

    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        this.signedContent.checkValidity(signerInfo);
    }

    public synchronized SignedContentEntry[] getSignedEntries() {
        SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
        if (this.signedContent == null) {
            return null;
        }
        SignedContentEntry[] signedContentEntryArray2 = new SignedContentEntry[signedContentEntryArray.length];
        Map map = this.getEntryExceptions(true);
        int n = 0;
        while (n < signedContentEntryArray.length) {
            try {
                signedContentEntryArray[n].verify();
            }
            catch (Throwable throwable) {
                map.put(signedContentEntryArray[n].getName(), throwable);
            }
            signedContentEntryArray2[n] = new SignedContentFile$SignedContentFileEntry(this, signedContentEntryArray[n]);
            ++n;
        }
        try {
            this.signedContent.content.close();
        }
        catch (IOException iOException) {}
        return signedContentEntryArray2;
    }

    public synchronized SignedContentEntry getSignedEntry(String string) {
        SignedContentEntry signedContentEntry;
        if (this.getEntryExceptions(false) == null) {
            this.getSignedEntries();
        }
        return (signedContentEntry = this.signedContent.getSignedEntry(string)) == null ? null : new SignedContentFile$SignedContentFileEntry(this, signedContentEntry);
    }

    public SignerInfo[] getSignerInfos() {
        return this.signedContent.getSignerInfos();
    }

    public Date getSigningTime(SignerInfo signerInfo) {
        return this.signedContent.getSigningTime(signerInfo);
    }

    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        return this.signedContent.getTSASignerInfo(signerInfo);
    }

    public boolean isSigned() {
        return this.signedContent.isSigned();
    }

    synchronized Map getEntryExceptions(boolean bl) {
        if (bl && this.entryExceptions == null) {
            this.entryExceptions = new HashMap(5);
        }
        return this.entryExceptions;
    }
}

