/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.internal.signedcontent.DNChainMatching;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.osgi.framework.Bundle;

public class SignedBundleHook$$Cold {
    public static SignedContent getSignedContent(SignedBundleHook signedBundleHook, File file) {
        if (file == null) {
            throw (Throwable)new IllegalArgumentException("null content");
        }
        BundleFile bundleFile = file.isDirectory() ? new DirBundleFile(file) : new ZipBundleFile(file, null);
        SignedBundleFile signedBundleFile = new SignedBundleFile(null, 15);
        signedBundleFile.setBundleFile(bundleFile);
        return new SignedContentFile(signedBundleFile.getSignedContent());
    }

    public static SignedContent getSignedContent(SignedBundleHook signedBundleHook, Bundle bundle) {
        SignedContentImpl signedContentImpl;
        BundleData bundleData = ((AbstractBundle)bundle).getBundleData();
        if (!(bundleData instanceof BaseData)) {
            throw (Throwable)new IllegalArgumentException("Invalid bundle object.  No BaseData found.");
        }
        SignedStorageHook signedStorageHook = (SignedStorageHook)((BaseData)bundleData).getStorageHook(SignedStorageHook.KEY);
        SignedContentImpl signedContentImpl2 = signedContentImpl = signedStorageHook != null ? signedStorageHook.signedContent : null;
        if (signedContentImpl != null) {
            return signedContentImpl;
        }
        return signedBundleHook.getSignedContent(((BaseData)bundleData).getBundleFile().getBaseFile());
    }

    public static boolean matchDNChain(SignedBundleHook signedBundleHook, String string, String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (DNChainMatching.match(stringArray[n], string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }
}

