/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.util.ArrayList;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.signedcontent.LegacyVerifierFactory$LegacyChain;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;

class LegacyVerifierFactory$LegacyVerifier
implements CertificateVerifier {
    private final SignedContent signedContent;

    public LegacyVerifierFactory$LegacyVerifier(SignedContent signedContent) {
        this.signedContent = signedContent;
    }

    public void checkContent() throws CertificateException, CertificateExpiredException {
        SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
        int n = 0;
        while (n < signedContentEntryArray.length) {
            try {
                signedContentEntryArray[n].verify();
            }
            catch (InvalidContentException invalidContentException) {
                throw (Throwable)new SecurityException(((Throwable)invalidContentException).getMessage());
            }
            catch (IOException iOException) {
                throw (Throwable)new SecurityException(((Throwable)iOException).getMessage());
            }
            ++n;
        }
        SignerInfo[] signerInfoArray = this.signedContent.getSignerInfos();
        int n2 = 0;
        while (n2 < signerInfoArray.length) {
            this.signedContent.checkValidity(signerInfoArray[n2]);
            ++n2;
        }
    }

    public CertificateChain[] getChains() {
        SignerInfo[] signerInfoArray = this.signedContent.getSignerInfos();
        CertificateChain[] certificateChainArray = new CertificateChain[signerInfoArray.length];
        int n = 0;
        while (n < certificateChainArray.length) {
            certificateChainArray[n] = new LegacyVerifierFactory$LegacyChain(signerInfoArray[n], this.signedContent);
            ++n;
        }
        return certificateChainArray;
    }

    public boolean isSigned() {
        return this.signedContent.isSigned();
    }

    public String[] verifyContent() {
        ArrayList<String> arrayList = new ArrayList<String>(0);
        SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
        int n = 0;
        while (n < signedContentEntryArray.length) {
            try {
                signedContentEntryArray[n].verify();
            }
            catch (InvalidContentException invalidContentException) {
                arrayList.add(signedContentEntryArray[n].getName());
            }
            catch (IOException iOException) {
                arrayList.add(signedContentEntryArray[n].getName());
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

