/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;

class LegacyVerifierFactory$LegacyChain
implements CertificateChain {
    private final SignerInfo signerInfo;
    private final SignedContent content;

    public LegacyVerifierFactory$LegacyChain(SignerInfo signerInfo, SignedContent signedContent) {
        this.signerInfo = signerInfo;
        this.content = signedContent;
    }

    public Certificate[] getCertificates() {
        return this.signerInfo.getCertificateChain();
    }

    public String getChain() {
        StringBuffer stringBuffer = new StringBuffer();
        Certificate[] certificateArray = this.getCertificates();
        int n = 0;
        while (n < certificateArray.length) {
            X509Certificate x509Certificate = (X509Certificate)certificateArray[n];
            stringBuffer.append(x509Certificate.getSubjectDN().getName());
            stringBuffer.append("; ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Certificate getRoot() {
        Certificate[] certificateArray = this.getCertificates();
        return certificateArray.length > 0 ? certificateArray[certificateArray.length - 1] : null;
    }

    public Certificate getSigner() {
        Certificate[] certificateArray = this.getCertificates();
        return certificateArray.length > 0 ? certificateArray[0] : null;
    }

    public Date getSigningTime() {
        return this.content.getSigningTime(this.signerInfo);
    }

    public boolean isTrusted() {
        return this.signerInfo.isTrusted();
    }
}

