/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

class StateReader {
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    private static final int BUFFER_SIZE_LAZY = 4096;
    private static final int BUFFER_SIZE_FULLYREAD = 16384;
    private static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    protected Map objectTable = new HashMap();
    private File stateFile;
    private File lazyFile;
    private boolean lazyLoad = true;
    private int numBundles;
    private boolean accessedFlag = false;
    public static final byte STATE_CACHE_VERSION = 30;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;
    private WeakHashMap stringCache = new WeakHashMap();
    static Class class$0;

    public StateReader() {
        this.lazyLoad = false;
    }

    public StateReader(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        this.stateFile = new File(file, STATE_FILE);
        this.lazyFile = new File(file, LAZY_FILE);
        this.lazyLoad = false;
    }

    public StateReader(File file, File file2, boolean bl) {
        this.stateFile = file;
        this.lazyFile = file2;
        this.lazyLoad = bl;
    }

    private void addToObjectTable(Object object, int n) {
        this.objectTable.put(new Integer(n), object);
    }

    private Object getFromObjectTable(int n) {
        return this.objectTable.get(new Integer(n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readState(StateImpl stateImpl, long l) throws IOException {
        int n;
        FilterInputStream filterInputStream;
        DataInputStream dataInputStream;
        block22: {
            Object object;
            long l2;
            int n2;
            block24: {
                block23: {
                    byte by;
                    dataInputStream = new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.stateFile), 16384));
                    filterInputStream = null;
                    if (dataInputStream.readByte() != 30 || (by = this.readTag(dataInputStream)) != 1) break block23;
                    n2 = dataInputStream.readInt();
                    l2 = dataInputStream.readLong();
                    if (l < 0L || l2 == l) break block24;
                }
                ((FilterInputStream)dataInputStream).close();
                if (filterInputStream == null) return false;
                try {
                    filterInputStream.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            this.addToObjectTable(stateImpl, n2);
            String[] stringArray = (String[])this.readPlatformProp(dataInputStream);
            stateImpl.addPlatformPropertyKeys(stringArray);
            int n3 = dataInputStream.readInt();
            Dictionary[] dictionaryArray = new Dictionary[n3];
            int n4 = 0;
            while (n4 < n3) {
                object = new Hashtable(stringArray.length);
                int n5 = dataInputStream.readInt();
                int n6 = 0;
                while (n6 < n5) {
                    Object object2 = this.readPlatformProp(dataInputStream);
                    if (object2 != null && n6 < stringArray.length) {
                        ((Hashtable)object).put(stringArray[n6], object2);
                    }
                    ++n6;
                }
                dictionaryArray[n4] = object;
                ++n4;
            }
            stateImpl.setPlatformProperties(dictionaryArray, false);
            this.numBundles = dataInputStream.readInt();
            n4 = 0;
            while (n4 < this.numBundles) {
                object = this.readBundleDescription(dataInputStream);
                stateImpl.basicAddBundle((BundleDescription)object);
                if (((BundleDescriptionImpl)object).isResolved()) {
                    stateImpl.addResolvedBundle((BundleDescriptionImpl)object);
                }
                ++n4;
            }
            n4 = dataInputStream.readInt();
            n = 0;
            while (n < n4) {
                DisabledInfo disabledInfo = this.readDisabledInfo(dataInputStream);
                stateImpl.addDisabledInfo(disabledInfo);
                ++n;
            }
            stateImpl.setTimeStamp(l2);
            stateImpl.setResolved(dataInputStream.readBoolean());
            if (!this.lazyLoad) break block22;
            ((FilterInputStream)dataInputStream).close();
            if (filterInputStream == null) return true;
            try {
                filterInputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 16384));
            n = 0;
            while (n < this.numBundles) {
                this.readBundleDescriptionLazyData((DataInputStream)filterInputStream, 0);
                ++n;
            }
        }
        catch (Throwable throwable) {
            ((FilterInputStream)dataInputStream).close();
            if (filterInputStream == null) throw throwable;
            try {
                ((FilterInputStream)filterInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        ((FilterInputStream)dataInputStream).close();
        if (filterInputStream == null) return true;
        try {
            filterInputStream.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
    }

    private boolean readStateDeprecated(StateImpl stateImpl, DataInputStream dataInputStream, long l) throws IOException {
        Object object;
        if (dataInputStream.readByte() != 30) {
            return false;
        }
        byte by = this.readTag(dataInputStream);
        if (by != 1) {
            return false;
        }
        int n = dataInputStream.readInt();
        long l2 = dataInputStream.readLong();
        if (l >= 0L && l2 != l) {
            return false;
        }
        this.addToObjectTable(stateImpl, n);
        String[] stringArray = (String[])this.readPlatformProp(dataInputStream);
        stateImpl.addPlatformPropertyKeys(stringArray);
        int n2 = dataInputStream.readInt();
        Dictionary[] dictionaryArray = new Dictionary[n2];
        int n3 = 0;
        while (n3 < n2) {
            object = new Hashtable(stringArray.length);
            int n4 = dataInputStream.readInt();
            int n5 = 0;
            while (n5 < n4) {
                Object object2 = this.readPlatformProp(dataInputStream);
                if (object2 != null && n5 < stringArray.length) {
                    ((Hashtable)object).put(stringArray[n5], object2);
                }
                ++n5;
            }
            dictionaryArray[n3] = object;
            ++n3;
        }
        stateImpl.setPlatformProperties(dictionaryArray);
        this.numBundles = dataInputStream.readInt();
        if (this.numBundles == 0) {
            return true;
        }
        n3 = 0;
        while (n3 < this.numBundles) {
            object = this.readBundleDescription(dataInputStream);
            stateImpl.basicAddBundle((BundleDescription)object);
            if (((BundleDescriptionImpl)object).isResolved()) {
                stateImpl.addResolvedBundle((BundleDescriptionImpl)object);
            }
            ++n3;
        }
        stateImpl.setTimeStamp(l2);
        stateImpl.setResolved(dataInputStream.readBoolean());
        dataInputStream.readInt();
        if (this.lazyLoad) {
            return true;
        }
        n3 = 0;
        while (n3 < this.numBundles) {
            this.readBundleDescriptionLazyData(dataInputStream, 0);
            ++n3;
        }
        return true;
    }

    private Object readPlatformProp(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        int n = dataInputStream.readInt();
        if (n == 1) {
            return this.readString(dataInputStream, false);
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = this.readString(dataInputStream, false);
            ++n2;
        }
        return stringArray;
    }

    private BundleDescriptionImpl readBundleDescription(DataInputStream dataInputStream) throws IOException {
        BundleDescription[] bundleDescriptionArray;
        Object object;
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (BundleDescriptionImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        BundleDescriptionImpl bundleDescriptionImpl = new BundleDescriptionImpl();
        this.addToObjectTable(bundleDescriptionImpl, dataInputStream.readInt());
        bundleDescriptionImpl.setBundleId(dataInputStream.readLong());
        this.readBaseDescription(bundleDescriptionImpl, dataInputStream);
        bundleDescriptionImpl.setLazyDataOffset(dataInputStream.readInt());
        bundleDescriptionImpl.setLazyDataSize(dataInputStream.readInt());
        bundleDescriptionImpl.setStateBit(1, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(2, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(32, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(64, dataInputStream.readBoolean());
        bundleDescriptionImpl.setStateBit(128, dataInputStream.readBoolean());
        bundleDescriptionImpl.setHost(this.readHostSpec(dataInputStream));
        int n = dataInputStream.readInt();
        if (n > 0) {
            object = new BundleDescription[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = this.readBundleDescription(dataInputStream);
                ++n2;
            }
            bundleDescriptionImpl.addDependencies((BaseDescription[])object, false);
        }
        if ((object = (HostSpecificationImpl)bundleDescriptionImpl.getHost()) != null && (bundleDescriptionArray = ((HostSpecificationImpl)object).getHosts()) != null) {
            int n3 = 0;
            while (n3 < bundleDescriptionArray.length) {
                ((BundleDescriptionImpl)bundleDescriptionArray[n3]).addDependency(bundleDescriptionImpl, false);
                ++n3;
            }
        }
        bundleDescriptionImpl.setFullyLoaded(false);
        return bundleDescriptionImpl;
    }

    private BundleDescriptionImpl readBundleDescriptionLazyData(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        int n3;
        GenericSpecification[] genericSpecificationArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        BundleDescriptionImpl bundleDescriptionImpl;
        if (n > 0) {
            dataInputStream.skipBytes(n);
        }
        if ((bundleDescriptionImpl = (BundleDescriptionImpl)this.getFromObjectTable(n12 = dataInputStream.readInt())).isFullyLoaded()) {
            dataInputStream.skipBytes(bundleDescriptionImpl.getLazyDataSize() - 4);
            return bundleDescriptionImpl;
        }
        bundleDescriptionImpl.setLocation(this.readString(dataInputStream, false));
        bundleDescriptionImpl.setPlatformFilter(this.readString(dataInputStream, false));
        int n13 = dataInputStream.readInt();
        if (n13 > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n13];
            int n14 = 0;
            while (n14 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n14] = this.readExportPackageDesc(dataInputStream);
                ++n14;
            }
            bundleDescriptionImpl.setExportPackages(exportPackageDescriptionArray);
        }
        if ((n11 = dataInputStream.readInt()) > 0) {
            ImportPackageSpecification[] importPackageSpecificationArray = new ImportPackageSpecification[n11];
            int n15 = 0;
            while (n15 < importPackageSpecificationArray.length) {
                importPackageSpecificationArray[n15] = this.readImportPackageSpec(dataInputStream);
                ++n15;
            }
            bundleDescriptionImpl.setImportPackages(importPackageSpecificationArray);
        }
        if ((n10 = dataInputStream.readInt()) > 0) {
            BundleSpecification[] bundleSpecificationArray = new BundleSpecification[n10];
            int n16 = 0;
            while (n16 < bundleSpecificationArray.length) {
                bundleSpecificationArray[n16] = this.readBundleSpec(dataInputStream);
                ++n16;
            }
            bundleDescriptionImpl.setRequiredBundles(bundleSpecificationArray);
        }
        if ((n9 = dataInputStream.readInt()) > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n9];
            int n17 = 0;
            while (n17 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n17] = this.readExportPackageDesc(dataInputStream);
                ++n17;
            }
            bundleDescriptionImpl.setSelectedExports(exportPackageDescriptionArray);
        }
        if ((n8 = dataInputStream.readInt()) > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n8];
            int n18 = 0;
            while (n18 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n18] = this.readExportPackageDesc(dataInputStream);
                ++n18;
            }
            bundleDescriptionImpl.setSubstitutedExports(exportPackageDescriptionArray);
        }
        if ((n7 = dataInputStream.readInt()) > 0) {
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[n7];
            int n19 = 0;
            while (n19 < exportPackageDescriptionArray.length) {
                exportPackageDescriptionArray[n19] = this.readExportPackageDesc(dataInputStream);
                ++n19;
            }
            bundleDescriptionImpl.setResolvedImports(exportPackageDescriptionArray);
        }
        if ((n6 = dataInputStream.readInt()) > 0) {
            BundleDescription[] bundleDescriptionArray = new BundleDescription[n6];
            int n20 = 0;
            while (n20 < bundleDescriptionArray.length) {
                bundleDescriptionArray[n20] = this.readBundleDescription(dataInputStream);
                ++n20;
            }
            bundleDescriptionImpl.setResolvedRequires(bundleDescriptionArray);
        }
        if ((n5 = dataInputStream.readInt()) > 0) {
            String[] stringArray = new String[n5];
            int n21 = 0;
            while (n21 < stringArray.length) {
                stringArray[n21] = this.readString(dataInputStream, false);
                ++n21;
            }
            bundleDescriptionImpl.setExecutionEnvironments(stringArray);
        }
        if ((n4 = dataInputStream.readInt()) > 0) {
            HashMap<GenericSpecification[], Long> hashMap = new HashMap<GenericSpecification[], Long>(n4);
            int n22 = 0;
            while (n22 < n4) {
                genericSpecificationArray = this.readString(dataInputStream, false);
                Long l = new Long(dataInputStream.readLong());
                hashMap.put(genericSpecificationArray, l);
                ++n22;
            }
            bundleDescriptionImpl.setDynamicStamps(hashMap);
        }
        if ((n3 = dataInputStream.readInt()) > 0) {
            GenericDescription[] genericDescriptionArray = new GenericDescription[n3];
            int n23 = 0;
            while (n23 < genericDescriptionArray.length) {
                genericDescriptionArray[n23] = this.readGenericDescription(dataInputStream);
                ++n23;
            }
            bundleDescriptionImpl.setGenericCapabilities(genericDescriptionArray);
        }
        if ((n2 = dataInputStream.readInt()) > 0) {
            genericSpecificationArray = new GenericSpecification[n2];
            int n24 = 0;
            while (n24 < genericSpecificationArray.length) {
                genericSpecificationArray[n24] = this.readGenericSpecification(dataInputStream);
                ++n24;
            }
            bundleDescriptionImpl.setGenericRequires(genericSpecificationArray);
        }
        bundleDescriptionImpl.setNativeCodeSpecification(this.readNativeCode(dataInputStream));
        bundleDescriptionImpl.setFullyLoaded(true);
        return bundleDescriptionImpl;
    }

    private BundleSpecificationImpl readBundleSpec(DataInputStream dataInputStream) throws IOException {
        BundleSpecificationImpl bundleSpecificationImpl = new BundleSpecificationImpl();
        this.readVersionConstraint(bundleSpecificationImpl, dataInputStream);
        ((VersionConstraintImpl)bundleSpecificationImpl).setSupplier(this.readBundleDescription(dataInputStream));
        bundleSpecificationImpl.setExported(dataInputStream.readBoolean());
        bundleSpecificationImpl.setOptional(dataInputStream.readBoolean());
        return bundleSpecificationImpl;
    }

    private ExportPackageDescriptionImpl readExportPackageDesc(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (ExportPackageDescriptionImpl)this.getFromObjectTable(dataInputStream.readInt());
        }
        ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
        int n = dataInputStream.readInt();
        this.addToObjectTable(exportPackageDescriptionImpl, n);
        exportPackageDescriptionImpl.setTableIndex(n);
        this.readBaseDescription(exportPackageDescriptionImpl, dataInputStream);
        exportPackageDescriptionImpl.setExporter(this.readBundleDescription(dataInputStream));
        exportPackageDescriptionImpl.setAttributes(this.readMap(dataInputStream));
        exportPackageDescriptionImpl.setDirectives(this.readMap(dataInputStream));
        return exportPackageDescriptionImpl;
    }

    private DisabledInfo readDisabledInfo(DataInputStream dataInputStream) throws IOException {
        return new DisabledInfo(this.readString(dataInputStream, false), this.readString(dataInputStream, false), this.readBundleDescription(dataInputStream));
    }

    private Map readMap(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = this.readString(dataInputStream, false);
            Object object = null;
            byte by = dataInputStream.readByte();
            if (by == 0) {
                object = this.readString(dataInputStream, false);
            } else if (by == 1) {
                object = this.readList(dataInputStream);
            } else if (by == 2) {
                object = dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            } else if (by == 3) {
                object = new Integer(dataInputStream.readInt());
            } else if (by == 4) {
                object = new Long(dataInputStream.readLong());
            } else if (by == 5) {
                object = new Double(dataInputStream.readDouble());
            } else if (by == 6) {
                object = this.readVersion(dataInputStream);
            } else if (by == 7) {
                object = this.readString(dataInputStream, false);
                try {
                    Class<?> clazz = Class.forName("java.net.URI");
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    object = constructor.newInstance(object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (Throwable)exception;
                    }
                    throw (Throwable)new RuntimeException(((Throwable)exception).getMessage());
                }
            }
            hashMap.put(string, (String[])object);
            ++n2;
        }
        return hashMap;
    }

    private String[] readList(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString(dataInputStream, false);
            ++n2;
        }
        return stringArray;
    }

    private void readBaseDescription(BaseDescriptionImpl baseDescriptionImpl, DataInputStream dataInputStream) throws IOException {
        baseDescriptionImpl.setName(this.readString(dataInputStream, false));
        baseDescriptionImpl.setVersion(this.readVersion(dataInputStream));
    }

    private ImportPackageSpecificationImpl readImportPackageSpec(DataInputStream dataInputStream) throws IOException {
        ImportPackageSpecificationImpl importPackageSpecificationImpl = new ImportPackageSpecificationImpl();
        this.readVersionConstraint(importPackageSpecificationImpl, dataInputStream);
        ((VersionConstraintImpl)importPackageSpecificationImpl).setSupplier(this.readExportPackageDesc(dataInputStream));
        importPackageSpecificationImpl.setBundleSymbolicName(this.readString(dataInputStream, false));
        importPackageSpecificationImpl.setBundleVersionRange(this.readVersionRange(dataInputStream));
        importPackageSpecificationImpl.setAttributes(this.readMap(dataInputStream));
        importPackageSpecificationImpl.setDirectives(this.readMap(dataInputStream));
        return importPackageSpecificationImpl;
    }

    private HostSpecificationImpl readHostSpec(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        HostSpecificationImpl hostSpecificationImpl = new HostSpecificationImpl();
        this.readVersionConstraint(hostSpecificationImpl, dataInputStream);
        int n = dataInputStream.readInt();
        if (n > 0) {
            BundleDescription[] bundleDescriptionArray = new BundleDescription[n];
            int n2 = 0;
            while (n2 < bundleDescriptionArray.length) {
                bundleDescriptionArray[n2] = this.readBundleDescription(dataInputStream);
                ++n2;
            }
            hostSpecificationImpl.setHosts(bundleDescriptionArray);
        }
        return hostSpecificationImpl;
    }

    private GenericDescription readGenericDescription(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        if (by == 2) {
            return (GenericDescription)this.getFromObjectTable(dataInputStream.readInt());
        }
        int n = dataInputStream.readInt();
        GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
        this.addToObjectTable(genericDescriptionImpl, n);
        this.readBaseDescription(genericDescriptionImpl, dataInputStream);
        genericDescriptionImpl.setSupplier(this.readBundleDescription(dataInputStream));
        genericDescriptionImpl.setType(this.readString(dataInputStream, false));
        Map map = this.readMap(dataInputStream);
        Hashtable hashtable = new Hashtable();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ((Dictionary)hashtable).put(k, map.get(k));
            }
        }
        genericDescriptionImpl.setAttributes(hashtable);
        return genericDescriptionImpl;
    }

    private GenericSpecification readGenericSpecification(DataInputStream dataInputStream) throws IOException {
        GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
        this.readVersionConstraint(genericSpecificationImpl, dataInputStream);
        genericSpecificationImpl.setType(this.readString(dataInputStream, false));
        int n = dataInputStream.readInt();
        GenericDescription[] genericDescriptionArray = n == 0 ? null : new GenericDescription[n];
        int n2 = 0;
        while (n2 < n) {
            genericDescriptionArray[n2] = this.readGenericDescription(dataInputStream);
            ++n2;
        }
        genericSpecificationImpl.setSupplers(genericDescriptionArray);
        genericSpecificationImpl.setResolution(dataInputStream.readInt());
        try {
            genericSpecificationImpl.setMatchingFilter(this.readString(dataInputStream, false));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return genericSpecificationImpl;
    }

    private NativeCodeSpecification readNativeCode(DataInputStream dataInputStream) throws IOException {
        if (!dataInputStream.readBoolean()) {
            return null;
        }
        NativeCodeSpecificationImpl nativeCodeSpecificationImpl = new NativeCodeSpecificationImpl();
        nativeCodeSpecificationImpl.setOptional(dataInputStream.readBoolean());
        int n = dataInputStream.readInt();
        NativeCodeDescriptionImpl[] nativeCodeDescriptionImplArray = new NativeCodeDescriptionImpl[n];
        int n2 = 0;
        while (n2 < n) {
            nativeCodeDescriptionImplArray[n2] = this.readNativeCodeDescription(dataInputStream);
            ++n2;
        }
        nativeCodeSpecificationImpl.setPossibleSuppliers(nativeCodeDescriptionImplArray);
        n2 = dataInputStream.readInt();
        if (n2 >= 0) {
            ((VersionConstraintImpl)nativeCodeSpecificationImpl).setSupplier(nativeCodeDescriptionImplArray[n2]);
        }
        return nativeCodeSpecificationImpl;
    }

    private NativeCodeDescriptionImpl readNativeCodeDescription(DataInputStream dataInputStream) throws IOException {
        NativeCodeDescriptionImpl nativeCodeDescriptionImpl = new NativeCodeDescriptionImpl();
        this.readBaseDescription(nativeCodeDescriptionImpl, dataInputStream);
        nativeCodeDescriptionImpl.setSupplier(this.readBundleDescription(dataInputStream));
        try {
            nativeCodeDescriptionImpl.setFilter(this.readString(dataInputStream, false));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        nativeCodeDescriptionImpl.setLanguages(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setNativePaths(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setOSNames(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setOSVersions(this.readVersionRanges(dataInputStream));
        nativeCodeDescriptionImpl.setProcessors(this.readStringArray(dataInputStream));
        nativeCodeDescriptionImpl.setInvalidNativePaths(dataInputStream.readBoolean());
        return nativeCodeDescriptionImpl;
    }

    private VersionRange[] readVersionRanges(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        VersionRange[] versionRangeArray = new VersionRange[n];
        int n2 = 0;
        while (n2 < n) {
            versionRangeArray[n2] = this.readVersionRange(dataInputStream);
            ++n2;
        }
        return versionRangeArray;
    }

    private String[] readStringArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString(dataInputStream, false);
            ++n2;
        }
        return stringArray;
    }

    private void readVersionConstraint(VersionConstraintImpl versionConstraintImpl, DataInputStream dataInputStream) throws IOException {
        versionConstraintImpl.setName(this.readString(dataInputStream, false));
        versionConstraintImpl.setVersionRange(this.readVersionRange(dataInputStream));
    }

    private Version readVersion(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return Version.emptyVersion;
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        String string = this.readString(dataInputStream, false);
        Version version = new Version(n, n2, n3, string);
        return version;
    }

    private VersionRange readVersionRange(DataInputStream dataInputStream) throws IOException {
        byte by = this.readTag(dataInputStream);
        if (by == 0) {
            return null;
        }
        return new VersionRange(this.readVersion(dataInputStream), dataInputStream.readBoolean(), this.readVersion(dataInputStream), dataInputStream.readBoolean());
    }

    public final boolean loadStateDeprecated(StateImpl stateImpl, DataInputStream dataInputStream, long l) throws IOException {
        try {
            boolean bl = this.readStateDeprecated(stateImpl, dataInputStream, l);
            return bl;
        }
        finally {
            ((FilterInputStream)dataInputStream).close();
        }
    }

    public final boolean loadState(StateImpl stateImpl, long l) throws IOException {
        return this.readState(stateImpl, l);
    }

    private String readString(DataInputStream dataInputStream, boolean bl) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        String string = bl ? dataInputStream.readUTF().intern() : dataInputStream.readUTF();
        WeakReference weakReference = (WeakReference)this.stringCache.get(string);
        if (weakReference != null) {
            String string2 = (String)((Reference)weakReference).get();
            if (string2 != null) {
                string = string2;
            }
        } else {
            this.stringCache.put(string, new WeakReference<String>(string));
        }
        return string;
    }

    private byte readTag(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte();
    }

    private DataInputStream openLazyFile() throws IOException {
        if (this.lazyFile == null) {
            throw (Throwable)new IOException();
        }
        return new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 4096));
    }

    boolean isLazyLoaded() {
        return this.lazyLoad;
    }

    boolean getAccessedFlag() {
        return this.accessedFlag;
    }

    void setAccessedFlag(boolean bl) {
        this.accessedFlag = bl;
    }

    synchronized void fullyLoad() {
        this.setAccessedFlag(true);
        DataInputStream dataInputStream = null;
        try {
            try {
                dataInputStream = this.openLazyFile();
                int n = 0;
                while (n < this.numBundles) {
                    this.readBundleDescriptionLazyData(dataInputStream, 0);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw (Throwable)new RuntimeException();
            }
        }
        catch (Throwable throwable) {
            if (dataInputStream != null) {
                try {
                    ((FilterInputStream)dataInputStream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (dataInputStream != null) {
            try {
                ((FilterInputStream)dataInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    synchronized void fullyLoad(BundleDescriptionImpl bundleDescriptionImpl) throws IOException {
        this.setAccessedFlag(true);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = this.openLazyFile();
            ArrayList arrayList = new ArrayList();
            this.addDependencies(bundleDescriptionImpl, arrayList);
            int[] nArray = this.getSkipBytes(arrayList);
            int n = 0;
            while (n < nArray.length) {
                this.readBundleDescriptionLazyData(dataInputStream, nArray[n]);
                ++n;
            }
        }
        finally {
            if (dataInputStream != null) {
                ((FilterInputStream)dataInputStream).close();
            }
        }
    }

    private void addDependencies(BundleDescriptionImpl bundleDescriptionImpl, List list) {
        Object object;
        if (list.contains(bundleDescriptionImpl) || bundleDescriptionImpl.isFullyLoaded()) {
            return;
        }
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (BundleDescriptionImpl)iterator.next();
            if (bundleDescriptionImpl.getLazyDataOffset() < ((BundleDescriptionImpl)object).getLazyDataOffset()) break;
            ++n;
        }
        if (n >= list.size()) {
            list.add(bundleDescriptionImpl);
        } else {
            list.add(n, bundleDescriptionImpl);
        }
        object = bundleDescriptionImpl.getBundleDependencies();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            this.addDependencies((BundleDescriptionImpl)iterator2.next(), list);
        }
    }

    private int[] getSkipBytes(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)arrayList.get(n);
            if (n == 0) {
                nArray[n] = bundleDescriptionImpl.getLazyDataOffset();
            } else {
                BundleDescriptionImpl bundleDescriptionImpl2 = (BundleDescriptionImpl)arrayList.get(n - 1);
                nArray[n] = bundleDescriptionImpl.getLazyDataOffset() - bundleDescriptionImpl2.getLazyDataOffset() - bundleDescriptionImpl2.getLazyDataSize();
            }
            ++n;
        }
        return nArray;
    }
}

