/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Dictionary;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class NativeCodeDescriptionImpl
extends BaseDescriptionImpl
implements NativeCodeDescription {
    private static final VersionRange[] EMPTY_VERSIONRANGES = new VersionRange[0];
    private Filter filter;
    private String[] languages;
    private String[] nativePaths;
    private String[] osNames;
    private VersionRange[] osVersions;
    private String[] processors;
    private BundleDescription supplier;
    private boolean invalidNativePaths = false;

    public Filter getFilter() {
        return this.filter;
    }

    public String[] getLanguages() {
        if (this.languages == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.languages;
    }

    public String[] getNativePaths() {
        if (this.nativePaths == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.nativePaths;
    }

    public String[] getOSNames() {
        if (this.osNames == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.osNames;
    }

    public VersionRange[] getOSVersions() {
        if (this.osVersions == null) {
            return EMPTY_VERSIONRANGES;
        }
        return this.osVersions;
    }

    public String[] getProcessors() {
        if (this.processors == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.processors;
    }

    public BundleDescription getSupplier() {
        return this.supplier;
    }

    public int compareTo(Object object) {
        Version version;
        if (!(object instanceof NativeCodeDescription)) {
            return 1;
        }
        State state = this.getSupplier().getContainingState();
        if (state == null) {
            return 0;
        }
        Dictionary[] dictionaryArray = state.getPlatformProperties();
        try {
            version = Version.parseVersion((String)dictionaryArray[0].get("org.osgi.framework.os.version"));
        }
        catch (Exception exception) {
            version = Version.emptyVersion;
        }
        NativeCodeDescription nativeCodeDescription = (NativeCodeDescription)object;
        VersionRange[] versionRangeArray = this.getOSVersions();
        VersionRange[] versionRangeArray2 = nativeCodeDescription.getOSVersions();
        Version version2 = this.getHighestVersionMatch(version, versionRangeArray);
        Version version3 = this.getHighestVersionMatch(version, versionRangeArray2);
        if (version2.compareTo(version3) < 0) {
            return -1;
        }
        return (this.getLanguages().length == 0 ? 0 : 1) - (nativeCodeDescription.getLanguages().length == 0 ? 0 : 1);
    }

    public boolean hasInvalidNativePaths() {
        return this.invalidNativePaths;
    }

    private Version getHighestVersionMatch(Version version, VersionRange[] versionRangeArray) {
        Version version2 = Version.emptyVersion;
        int n = 0;
        while (n < versionRangeArray.length) {
            if (versionRangeArray[n].isIncluded(version) && version2.compareTo(versionRangeArray[n].getMinimum()) < 0) {
                version2 = versionRangeArray[n].getMinimum();
            }
            ++n;
        }
        return version2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getNativePaths();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = this.getProcessors();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringBuffer.append("; ");
            stringBuffer.append("processor");
            stringBuffer.append('=');
            stringBuffer.append(stringArray2[n2]);
            ++n2;
        }
        String[] stringArray3 = this.getOSNames();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            stringBuffer.append("; ");
            stringBuffer.append("osname");
            stringBuffer.append('=');
            stringBuffer.append(stringArray3[n3]);
            ++n3;
        }
        VersionRange[] versionRangeArray = this.getOSVersions();
        int n4 = 0;
        while (n4 < versionRangeArray.length) {
            stringBuffer.append("; ");
            stringBuffer.append("osversion");
            stringBuffer.append("=\"");
            stringBuffer.append(versionRangeArray[n4].toString());
            stringBuffer.append('\"');
            ++n4;
        }
        String[] stringArray4 = this.getLanguages();
        int n5 = 0;
        while (n5 < stringArray4.length) {
            stringBuffer.append("; ");
            stringBuffer.append("language");
            stringBuffer.append('=');
            stringBuffer.append(stringArray4[n5]);
            ++n5;
        }
        Filter filter = this.getFilter();
        if (filter != null) {
            stringBuffer.append("; ");
            stringBuffer.append("selection-filter");
            stringBuffer.append("=\"");
            stringBuffer.append(filter.toString());
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    void setInvalidNativePaths(boolean bl) {
        this.invalidNativePaths = bl;
    }

    void setOSNames(String[] stringArray) {
        this.osNames = stringArray;
    }

    void setOSVersions(VersionRange[] versionRangeArray) {
        this.osVersions = versionRangeArray;
    }

    void setFilter(String string) throws InvalidSyntaxException {
        this.filter = string == null ? null : FrameworkUtil.createFilter(string);
    }

    void setLanguages(String[] stringArray) {
        this.languages = stringArray;
    }

    void setNativePaths(String[] stringArray) {
        this.nativePaths = stringArray;
    }

    void setProcessors(String[] stringArray) {
        this.processors = stringArray;
    }

    void setSupplier(BundleDescription bundleDescription) {
        this.supplier = bundleDescription;
    }
}

