/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.ResolverBundle$$Cold;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverBundle
extends VersionSupplier
implements Comparable {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private GenericCapability[] capabilities;
    private GenericConstraint[] genericReqiures;
    private ArrayList fragments;
    private HashMap fragmentExports;
    private HashMap fragmentImports;
    private HashMap fragmentRequires;
    private HashMap fragmentGenericRequires;
    private boolean resolvable = true;
    private int state = 0;
    private boolean uninstalled = false;
    private ResolverImpl resolver;
    private boolean newFragmentExports;
    private ArrayList refs;

    ResolverBundle(BundleDescription bundleDescription, ResolverImpl resolverImpl) {
        super(bundleDescription);
        this.bundleID = new Long(bundleDescription.getBundleId());
        this.resolver = resolverImpl;
        this.initialize(bundleDescription.isResolved());
    }

    void initialize(boolean bl) {
        if (this.getBundle().isSingleton()) {
            this.refs = new ArrayList();
        }
        GenericDescription[] genericDescriptionArray = this.getBundle().getGenericCapabilities();
        this.capabilities = new GenericCapability[genericDescriptionArray.length];
        int n = 0;
        while (n < this.capabilities.length) {
            this.capabilities[n] = new GenericCapability(this, genericDescriptionArray[n]);
            ++n;
        }
        if (this.getBundle().getHost() != null) {
            this.host = new BundleConstraint(this, this.getBundle().getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            this.genericReqiures = new GenericConstraint[0];
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = this.getBundle().getImportPackages();
        ArrayList<ResolverImport> arrayList = new ArrayList<ResolverImport>(importPackageSpecificationArray.length);
        int n2 = importPackageSpecificationArray.length - 1;
        while (n2 >= 0) {
            if ("optional".equals(importPackageSpecificationArray[n2].getDirective("resolution"))) {
                arrayList.add(new ResolverImport(this, importPackageSpecificationArray[n2]));
            } else {
                arrayList.add(0, new ResolverImport(this, importPackageSpecificationArray[n2]));
            }
            --n2;
        }
        this.imports = arrayList.toArray(new ResolverImport[arrayList.size()]);
        ExportPackageDescription[] exportPackageDescriptionArray = bl ? this.getBundle().getSelectedExports() : this.getBundle().getExportPackages();
        this.exports = new ResolverExport[exportPackageDescriptionArray.length];
        int n3 = 0;
        while (n3 < exportPackageDescriptionArray.length) {
            this.exports[n3] = new ResolverExport(this, exportPackageDescriptionArray[n3]);
            ++n3;
        }
        BundleSpecification[] bundleSpecificationArray = this.getBundle().getRequiredBundles();
        this.requires = new BundleConstraint[bundleSpecificationArray.length];
        int n4 = 0;
        while (n4 < this.requires.length) {
            this.requires[n4] = new BundleConstraint(this, bundleSpecificationArray[n4]);
            ++n4;
        }
        GenericSpecification[] genericSpecificationArray = this.getBundle().getGenericRequires();
        this.genericReqiures = new GenericConstraint[genericSpecificationArray.length];
        int n5 = 0;
        while (n5 < this.genericReqiures.length) {
            this.genericReqiures[n5] = new GenericConstraint(this, genericSpecificationArray[n5]);
            ++n5;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
        this.fragmentGenericRequires = null;
    }

    ResolverExport getExport(String string) {
        ResolverExport[] resolverExportArray = this.getExports(string);
        return resolverExportArray.length == 0 ? null : resolverExportArray[0];
    }

    ResolverExport[] getExports(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        Object[] objectArray = ((MappedList)this.resolver.getResolverExports()).get(string);
        int n = 0;
        while (n < objectArray.length) {
            if (((ResolverExport)objectArray[n]).getExporter() == this) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    void clearWires() {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            ((ResolverConstraint)resolverImportArray[n]).clearPossibleSuppliers();
            ++n;
        }
        if (this.host != null) {
            ((ResolverConstraint)this.host).clearPossibleSuppliers();
        }
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            ((ResolverConstraint)bundleConstraintArray[n2]).clearPossibleSuppliers();
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = this.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            genericConstraintArray[n3].setMatchingCapability(null);
            ++n3;
        }
        ResolverExport[] resolverExportArray = this.getExportPackages();
        int n4 = 0;
        while (n4 < resolverExportArray.length) {
            ((VersionSupplier)resolverExportArray[n4]).setSubstitute(null);
            ++n4;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int n) {
        this.state = n;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment()) {
            return new ResolverImport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        ArrayList<ResolverImport> arrayList = new ArrayList<ResolverImport>(this.imports.length);
        int n = 0;
        while (n < this.imports.length) {
            arrayList.add(this.imports[n]);
            ++n;
        }
        Iterator iterator = ((AbstractList)this.fragments).iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentImports.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new ResolverImport[arrayList.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        ArrayList<ResolverExport> arrayList = new ArrayList<ResolverExport>(this.exports.length);
        int n = 0;
        while (n < this.exports.length) {
            arrayList.add(this.exports[n]);
            ++n;
        }
        Iterator iterator = ((AbstractList)this.fragments).iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentExports.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    ResolverExport[] getSelectedExports() {
        return this.getExports(true);
    }

    ResolverExport[] getSubstitutedExports() {
        return this.getExports(false);
    }

    private ResolverExport[] getExports(boolean bl) {
        ResolverExport[] resolverExportArray = this.getExportPackages();
        int n = 0;
        int n2 = 0;
        while (n2 < resolverExportArray.length) {
            if (bl ? ((VersionSupplier)resolverExportArray[n2]).getSubstitute() != null : ((VersionSupplier)resolverExportArray[n2]).getSubstitute() == null) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return resolverExportArray;
        }
        ResolverExport[] resolverExportArray2 = new ResolverExport[resolverExportArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < resolverExportArray.length) {
            if (!(bl ? ((VersionSupplier)resolverExportArray[n4]).getSubstitute() != null : ((VersionSupplier)resolverExportArray[n4]).getSubstitute() == null)) {
                resolverExportArray2[n3] = resolverExportArray[n4];
                ++n3;
            }
            ++n4;
        }
        return resolverExportArray2;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    GenericCapability[] getGenericCapabilities() {
        return this.capabilities;
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment()) {
            return new BundleConstraint[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        ArrayList<BundleConstraint> arrayList = new ArrayList<BundleConstraint>(this.requires.length);
        int n = 0;
        while (n < this.requires.length) {
            arrayList.add(this.requires[n]);
            ++n;
        }
        Iterator iterator = ((AbstractList)this.fragments).iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentRequires.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new BundleConstraint[arrayList.size()]);
    }

    GenericConstraint[] getGenericRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericReqiures;
        }
        ArrayList<GenericConstraint> arrayList = new ArrayList<GenericConstraint>(this.genericReqiures.length);
        int n = 0;
        while (n < this.genericReqiures.length) {
            arrayList.add(this.genericReqiures[n]);
            ++n;
        }
        Iterator iterator = ((AbstractList)this.fragments).iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentGenericRequires.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new GenericConstraint[arrayList.size()]);
    }

    public BundleDescription getBundle() {
        return (BundleDescription)this.getBaseDescription();
    }

    public ResolverBundle getResolverBundle() {
        return this;
    }

    ResolverImport getImport(String string) {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].getName().equals(string)) {
                return resolverImportArray[n];
            }
            ++n;
        }
        return null;
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
        if (this.fragmentGenericRequires == null) {
            this.fragmentGenericRequires = new HashMap(1);
        }
    }

    private boolean isRequired(String string) {
        return this.getRequire(string) != null;
    }

    ResolverExport[] attachFragment(ResolverBundle resolverBundle, boolean bl) {
        Object object;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (!this.getBundle().attachFragments() || this.isResolved() && !this.getBundle().dynamicFragments()) {
            return new ResolverExport[0];
        }
        if (((ResolverConstraint)resolverBundle.getHost()).getNumPossibleSuppliers() > 0 && !((HostSpecification)((ResolverConstraint)resolverBundle.getHost()).getVersionConstraint()).isMultiHost()) {
            return new ResolverExport[0];
        }
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundle().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundle().getRequiredBundles();
        ExportPackageDescription[] exportPackageDescriptionArray = resolverBundle.getBundle().getExportPackages();
        GenericSpecification[] genericSpecificationArray = resolverBundle.getBundle().getGenericRequires();
        if (bl && this.constraintsConflict(resolverBundle.getBundle(), importPackageSpecificationArray, bundleSpecificationArray, genericSpecificationArray)) {
            return new ResolverExport[0];
        }
        if (this.isResolved() && exportPackageDescriptionArray.length > 0) {
            resolverBundle.setNewFragmentExports(true);
        }
        this.initFragments();
        ArrayList<Object> arrayList = ((AbstractList)this.fragments).iterator();
        while (arrayList.hasNext()) {
            object = (ResolverBundle)arrayList.next();
            String string = ((VersionSupplier)object).getName();
            if (string == null || !string.equals(resolverBundle.getName())) continue;
            return new ResolverExport[0];
        }
        if (this.fragments.contains(resolverBundle)) {
            return new ResolverExport[0];
        }
        this.fragments.add(resolverBundle);
        ((ResolverConstraint)resolverBundle.getHost()).addPossibleSupplier(this);
        if (importPackageSpecificationArray.length > 0) {
            arrayList = new ArrayList(importPackageSpecificationArray.length);
            int n = 0;
            while (n < importPackageSpecificationArray.length) {
                if (!this.isImported(importPackageSpecificationArray[n].getName())) {
                    arrayList.add(new ResolverImport(this, importPackageSpecificationArray[n]));
                }
                ++n;
            }
            this.fragmentImports.put(resolverBundle.bundleID, arrayList);
        }
        if (bundleSpecificationArray.length > 0) {
            arrayList = new ArrayList<Object>(bundleSpecificationArray.length);
            int n = 0;
            while (n < bundleSpecificationArray.length) {
                if (!this.isRequired(bundleSpecificationArray[n].getName())) {
                    arrayList.add(new BundleConstraint(this, bundleSpecificationArray[n]));
                }
                ++n;
            }
            this.fragmentRequires.put(resolverBundle.bundleID, arrayList);
        }
        if (genericSpecificationArray.length > 0) {
            arrayList = new ArrayList(genericSpecificationArray.length);
            int n = 0;
            while (n < genericSpecificationArray.length) {
                arrayList.add(new GenericConstraint(this, genericSpecificationArray[n]));
                ++n;
            }
            this.fragmentGenericRequires.put(resolverBundle.bundleID, arrayList);
        }
        arrayList = new ArrayList(exportPackageDescriptionArray.length);
        if (exportPackageDescriptionArray.length > 0 && bl) {
            object = this.resolver.getState().getFactory();
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                ResolverExport[] resolverExportArray = this.getExports(exportPackageDescriptionArray[n].getName());
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < resolverExportArray.length && !bl2) {
                    if (this.equivalentExports(resolverExportArray[n2], exportPackageDescriptionArray[n])) {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (!bl2) {
                    ExportPackageDescription exportPackageDescription = object.createExportPackageDescription(exportPackageDescriptionArray[n].getName(), exportPackageDescriptionArray[n].getVersion(), exportPackageDescriptionArray[n].getDirectives(), exportPackageDescriptionArray[n].getAttributes(), exportPackageDescriptionArray[n].isRoot(), this.getBundle());
                    arrayList.add(new ResolverExport(this, exportPackageDescription));
                }
                ++n;
            }
            this.fragmentExports.put(resolverBundle.bundleID, arrayList);
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    private boolean equivalentExports(ResolverExport resolverExport, ExportPackageDescription exportPackageDescription) {
        ExportPackageDescription exportPackageDescription2 = resolverExport.getExportPackageDescription();
        if (!exportPackageDescription2.getName().equals(exportPackageDescription.getName())) {
            return false;
        }
        if (!exportPackageDescription2.getVersion().equals(exportPackageDescription.getVersion())) {
            return false;
        }
        if (!this.equivalentMaps(exportPackageDescription2.getAttributes(), exportPackageDescription.getAttributes())) {
            return false;
        }
        return this.equivalentMaps(exportPackageDescription2.getDirectives(), exportPackageDescription.getDirectives());
    }

    private boolean equivalentMaps(Map map, Map map2) {
        if (map == null && map2 == null) {
            return true;
        }
        if (map == null ? map2 != null : map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = map2.get(entry.getKey());
            if (v == null || entry.getValue().getClass() != v.getClass()) {
                return false;
            }
            if (!(v instanceof String[] ? !Arrays.equals((Object[])entry.getValue(), (Object[])v) : !entry.getValue().equals(v))) continue;
            return false;
        }
        return true;
    }

    boolean constraintsConflict(BundleDescription bundleDescription, ImportPackageSpecification[] importPackageSpecificationArray, BundleSpecification[] bundleSpecificationArray, GenericSpecification[] genericSpecificationArray) {
        VersionSupplier versionSupplier;
        ResolverConstraint resolverConstraint;
        boolean bl = false;
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            resolverConstraint = this.getImport(importPackageSpecificationArray[n].getName());
            versionSupplier = (ResolverExport)(resolverConstraint == null ? null : ((ResolverConstraint)resolverConstraint).getSelectedSupplier());
            if (versionSupplier == null && this.isResolved() || versionSupplier != null && !importPackageSpecificationArray[n].isSatisfiedBy(((ResolverExport)versionSupplier).getExportPackageDescription())) {
                bl = true;
                this.resolver.getState().addResolverError(bundleDescription, 16, importPackageSpecificationArray[n].toString(), importPackageSpecificationArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < bundleSpecificationArray.length) {
            resolverConstraint = this.getRequire(bundleSpecificationArray[n].getName());
            versionSupplier = (ResolverBundle)(resolverConstraint == null ? null : ((ResolverConstraint)resolverConstraint).getSelectedSupplier());
            if (versionSupplier == null && this.isResolved() || versionSupplier != null && !bundleSpecificationArray[n].isSatisfiedBy(((ResolverBundle)versionSupplier).getBundle())) {
                bl = true;
                this.resolver.getState().addResolverError(bundleDescription, 16, bundleSpecificationArray[n].toString(), bundleSpecificationArray[n]);
            }
            ++n;
        }
        if (this.isResolved() && genericSpecificationArray != null && genericSpecificationArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    private void setNewFragmentExports(boolean bl) {
        this.newFragmentExports = bl;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] resolverBundleArray = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.detachFragment(resolverBundleArray[n], null);
            ++n;
        }
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean bl) {
        this.resolvable = bl;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }

    void clearRefs() {
        if (this.refs != null) {
            this.refs.clear();
        }
    }

    void addRef(ResolverBundle resolverBundle) {
        if (((BundleDescription)this.getBaseDescription()).isResolved()) {
            return;
        }
        if (this.refs != null && !this.refs.contains(resolverBundle)) {
            this.refs.add(resolverBundle);
        }
    }

    ResolverBundle[] getFragments() {
        return this.fragments == null ? new ResolverBundle[]{} : this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
    }

    void setUninstalled() {
        this.uninstalled = true;
    }

    boolean isUninstalled() {
        return this.uninstalled;
    }

    BundleConstraint getRequire(String string) throws  {
        return ResolverBundle$$Cold.getRequire(this, string);
    }

    public String toString() throws  {
        return ResolverBundle$$Cold.toString(this);
    }

    private boolean isImported(String string) throws  {
        return ResolverBundle$$Cold.isImported(this, string);
    }

    ResolverExport[] detachFragment(ResolverBundle resolverBundle, ResolverConstraint resolverConstraint) {
        int n;
        VersionSupplier[] versionSupplierArray;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        this.initFragments();
        ResolverImport[] resolverImportArray = this.getImportPackages();
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        if (!((AbstractCollection)this.fragments).remove(resolverBundle)) {
            return new ResolverExport[0];
        }
        resolverBundle.setNewFragmentExports(false);
        ((ResolverConstraint)resolverBundle.getHost()).removePossibleSupplier(this);
        this.fragmentImports.remove(resolverBundle.bundleID);
        this.fragmentRequires.remove(resolverBundle.bundleID);
        ArrayList arrayList = (ArrayList)this.fragmentExports.remove(resolverBundle.bundleID);
        this.fragmentGenericRequires.remove(resolverBundle.bundleID);
        if (resolverConstraint != null) {
            versionSupplierArray = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
            n = 0;
            while (n < versionSupplierArray.length) {
                ArrayList arrayList2 = new ArrayList(0);
                ArrayList arrayList3 = new ArrayList(0);
                if (!this.hasUnresolvedConstraint(resolverConstraint, resolverBundle, (ResolverBundle)versionSupplierArray[n], resolverImportArray, bundleConstraintArray, arrayList2, arrayList3)) {
                    ArrayList arrayList4;
                    if (arrayList2.size() > 0) {
                        arrayList4 = (ArrayList)this.fragmentImports.get(((ResolverBundle)versionSupplierArray[n]).bundleID);
                        if (arrayList4 == null) {
                            this.fragmentImports.put(((ResolverBundle)versionSupplierArray[n]).bundleID, arrayList2);
                        } else {
                            arrayList4.addAll(arrayList2);
                        }
                    }
                    if (arrayList3.size() > 0) {
                        arrayList4 = (ArrayList)this.fragmentRequires.get(((ResolverBundle)versionSupplierArray[n]).bundleID);
                        if (arrayList4 == null) {
                            this.fragmentRequires.put(((ResolverBundle)versionSupplierArray[n]).bundleID, arrayList3);
                        } else {
                            arrayList4.addAll(arrayList3);
                        }
                    }
                }
                ++n;
            }
        }
        versionSupplierArray = arrayList == null ? new ResolverExport[]{} : arrayList.toArray(new ResolverExport[arrayList.size()]);
        n = 0;
        while (n < versionSupplierArray.length) {
            versionSupplierArray[n].setSubstitute(versionSupplierArray[n]);
            ++n;
        }
        return versionSupplierArray;
    }

    private boolean hasUnresolvedConstraint(ResolverConstraint resolverConstraint, ResolverBundle resolverBundle, ResolverBundle resolverBundle2, ResolverImport[] resolverImportArray, BundleConstraint[] bundleConstraintArray, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle2.getBundle().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle2.getBundle().getRequiredBundles();
        VersionConstraint[] versionConstraintArray = resolverConstraint instanceof ResolverImport ? importPackageSpecificationArray : bundleSpecificationArray;
        int n2 = 0;
        while (n2 < versionConstraintArray.length) {
            if (resolverConstraint.getName().equals(versionConstraintArray[n2].getName())) {
                this.resolver.getResolverExports().remove(this.detachFragment(resolverBundle2, null));
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (((ResolverConstraint)resolverImportArray[n2]).getVersionConstraint().getBundle() == resolverBundle.getBundle()) {
                n = 0;
                while (n < importPackageSpecificationArray.length) {
                    if (resolverImportArray[n2].getName().equals(importPackageSpecificationArray[n].getName())) {
                        arrayList.add(resolverImportArray[n2]);
                        ((ResolverConstraint)resolverImportArray[n2]).setVersionConstraint(importPackageSpecificationArray[n]);
                        break;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            if (((ResolverConstraint)bundleConstraintArray[n2]).getVersionConstraint().getBundle() == resolverBundle.getBundle()) {
                n = 0;
                while (n < bundleSpecificationArray.length) {
                    if (((ResolverConstraint)bundleConstraintArray[n2]).getName().equals(bundleSpecificationArray[n].getName())) {
                        arrayList2.add(bundleConstraintArray[n2]);
                        ((ResolverConstraint)bundleConstraintArray[n2]).setVersionConstraint(bundleSpecificationArray[n]);
                        break;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        return false;
    }

    void addExport(ResolverExport resolverExport) {
        ResolverExport[] resolverExportArray = new ResolverExport[this.exports.length + 1];
        int n = 0;
        while (n < this.exports.length) {
            resolverExportArray[n] = this.exports[n];
            ++n;
        }
        resolverExportArray[this.exports.length] = resolverExport;
        this.exports = resolverExportArray;
    }

    int getRefs() {
        return this.refs == null ? 0 : this.refs.size();
    }

    public int compareTo(Object object) throws  {
        return ResolverBundle$$Cold.compareTo(this, object);
    }
}

