/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class GenericConstraint
extends ResolverConstraint {
    private ArrayList matchingCapability;

    GenericConstraint(ResolverBundle resolverBundle, VersionConstraint versionConstraint) {
        super(resolverBundle, versionConstraint);
    }

    boolean isOptional() {
        return false;
    }

    boolean isSatisfiedBy(VersionSupplier versionSupplier) {
        return !versionSupplier.getResolverBundle().isUninstalled() && this.getVersionConstraint().isSatisfiedBy(versionSupplier.getBaseDescription());
    }

    public void setMatchingCapability(GenericCapability genericCapability) {
        if (genericCapability == null) {
            this.matchingCapability = null;
            return;
        }
        if (this.matchingCapability == null) {
            this.matchingCapability = new ArrayList(1);
        }
        this.matchingCapability.add(genericCapability);
    }

    public GenericCapability[] getMatchingCapabilities() {
        return this.matchingCapability == null || this.matchingCapability.size() == 0 ? null : this.matchingCapability.toArray(new GenericCapability[this.matchingCapability.size()]);
    }

    void removeMatchingCapability(GenericCapability genericCapability) {
        if (this.matchingCapability != null) {
            ((AbstractCollection)this.matchingCapability).remove(genericCapability);
        }
    }
}

