/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.ManifestElement;

public final class DevClassPathHelper {
    private static boolean inDevelopmentMode = false;
    private static String[] devDefaultClasspath;
    private static Dictionary devProperties;

    static {
        devProperties = null;
        String string = FrameworkProperties.getProperty("osgi.dev");
        if (string != null) {
            try {
                inDevelopmentMode = true;
                URL uRL = new URL(string);
                devProperties = DevClassPathHelper.load(uRL);
                if (devProperties != null) {
                    devDefaultClasspath = DevClassPathHelper.getArrayFromList((String)devProperties.get("*"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                devDefaultClasspath = DevClassPathHelper.getArrayFromList(string);
            }
        }
    }

    private static String[] getDevClassPath(String string, Dictionary dictionary, String[] stringArray) {
        String string2;
        String[] stringArray2 = null;
        if (string != null && dictionary != null && (string2 = (String)dictionary.get(string)) != null) {
            stringArray2 = DevClassPathHelper.getArrayFromList(string2);
        }
        if (stringArray2 == null) {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    public static String[] getDevClassPath(String string, Dictionary dictionary) {
        if (dictionary == null) {
            return DevClassPathHelper.getDevClassPath(string, devProperties, devDefaultClasspath);
        }
        return DevClassPathHelper.getDevClassPath(string, dictionary, DevClassPathHelper.getArrayFromList((String)dictionary.get("*")));
    }

    public static String[] getDevClassPath(String string) {
        return DevClassPathHelper.getDevClassPath(string, null);
    }

    public static String[] getArrayFromList(String string) {
        return ManifestElement.getArrayFromList(string, ",");
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static Properties load(URL uRL) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {}
        return properties;
    }
}

