/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.NestedDirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BasePermissionStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage$$Cold;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage$StateSaver;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.internal.baseadaptor.BundleInstall;
import org.eclipse.osgi.internal.baseadaptor.BundleUninstall;
import org.eclipse.osgi.internal.baseadaptor.BundleUpdate;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.storagemanager.ManagedOutputStream;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.SynchronousBundleListener;

public class BaseStorage
implements SynchronousBundleListener {
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin";
    private static final String OPTION_PLATFORM_ADMIN_RESOLVER = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver";
    private static final String OPTION_MONITOR_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.osgi/eclipseadaptor/resolver/reader/timing";
    private static final String PROP_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_BUNDLE_STORE = "osgi.bundlestore";
    static final String DATA_DIR_NAME = "data";
    static final String LIB_TEMP = "libtemp";
    private static final String PROP_ENABLE_STATE_SAVER = "eclipse.enableStateSaver";
    static final String BUNDLEFILE_NAME = "bundlefile";
    private static final String PROP_CLEAN = "osgi.clean";
    public static final byte BUNDLEDATA_VERSION = 18;
    public static final byte EXTENSION_INITIALIZE = 1;
    public static final byte EXTENSION_INSTALLED = 2;
    public static final byte EXTENSION_UNINSTALLED = 4;
    public static final byte EXTENSION_UPDATED = 8;
    public static final String DELETE_FLAG = ".delete";
    private static final String PERM_DATA_FILE = ".permdata";
    private static final byte PERMDATA_VERSION = 1;
    private BaseAdaptor adaptor;
    private String installPath;
    private StorageManager storageManager;
    private StateManager stateManager;
    private KeyedHashSet storageHooks = new KeyedHashSet(5, false);
    private BundleContext context;
    private SynchronousBundleListener extensionListener;
    private final Method addFwkURLMethod = BaseStorage.findAddURLMethod(this.getFwkClassLoader(), "addURL");
    private final Method addExtURLMethod = BaseStorage.findAddURLMethod(this.getExtClassLoader(), "addURL");
    private String[] configuredExtensions;
    private long timeStamp = 0L;
    private int initialBundleStartLevel = 1;
    private long nextId = 1L;
    private File bundleStoreRoot;
    private BasePermissionStorage permissionStorage;
    private BaseStorage$StateSaver stateSaver;
    private boolean invalidState;
    private boolean storageManagerClosed;
    static Class class$0;

    BaseStorage() {
    }

    public void initialize(BaseAdaptor baseAdaptor) throws IOException {
        Location location;
        this.adaptor = baseAdaptor;
        BaseStorage.setDebugOptions();
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_CLEAN)).booleanValue()) {
            this.cleanOSGiCache();
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            URL uRL = location.getURL();
            this.installPath = uRL.getPath();
        }
        boolean bl = LocationManager.getConfigurationLocation().isReadOnly();
        this.storageManager = this.initFileManager(LocationManager.getOSGiConfigurationDir(), bl ? "none" : null, bl);
        this.storageManagerClosed = false;
        StorageHook[] storageHookArray = baseAdaptor.getHookRegistry().getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length) {
            this.storageHooks.add(storageHookArray[n]);
            ++n;
        }
    }

    private static Method findAddURLMethod(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return null;
        }
        Class<?> clazz = classLoader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        classArray[0] = clazz2;
        return BaseStorage.findMethod(clazz, string, classArray);
    }

    private static Method findMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            ((AccessibleObject)method).setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        return BaseStorage.findMethod(clazz.getSuperclass(), string, classArray);
    }

    private ClassLoader getFwkClassLoader() {
        return this.getClass().getClassLoader();
    }

    private ClassLoader getExtClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = classLoader.getParent();
        while (classLoader2 != null && classLoader2.getParent() != null) {
            classLoader2 = classLoader2.getParent();
        }
        return classLoader2;
    }

    private static void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        StateManager.DEBUG = frameworkDebugOptions != null;
        StateManager.DEBUG_READER = frameworkDebugOptions.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateManager.MONITOR_PLATFORM_ADMIN = frameworkDebugOptions.getBooleanOption(OPTION_MONITOR_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN = frameworkDebugOptions.getBooleanOption(OPTION_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER = frameworkDebugOptions.getBooleanOption(OPTION_PLATFORM_ADMIN_RESOLVER, false);
    }

    protected StorageManager initFileManager(File file, String string, boolean bl) {
        StorageManager storageManager = new StorageManager(file, string, bl);
        try {
            storageManager.open(!bl);
        }
        catch (IOException iOException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error reading framework metadata: " + ((Throwable)iOException).getMessage());
                Debug.printStackTrace(iOException);
            }
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, ((Throwable)iOException).getMessage());
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, iOException, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
        }
        return storageManager;
    }

    public boolean isReadOnly() {
        return this.storageManager.isReadOnly();
    }

    public void compact() throws IOException {
        if (!this.isReadOnly()) {
            this.compact(this.getBundleStoreRoot());
        }
    }

    private void compact(File file) {
        String[] stringArray;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("compact(" + file.getPath() + ")");
        }
        if ((stringArray = file.list()) == null) {
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2;
            if (!DATA_DIR_NAME.equals(stringArray[n2]) && (file2 = new File(file, stringArray[n2])).isDirectory()) {
                File file3 = new File(file2, DELETE_FLAG);
                if (file3.exists()) {
                    if (!AdaptorUtil.rm(file2) && !file3.exists()) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("Unable to write " + file3.getPath() + ": " + ((Throwable)iOException).getMessage());
                            }
                        }
                    }
                } else {
                    this.compact(file2);
                }
            }
            ++n2;
        }
    }

    public long getFreeSpace() throws IOException {
        return -1L;
    }

    BaseAdaptor getAdaptor() {
        return this.adaptor;
    }

    public Dictionary loadManifest(BaseData baseData) throws BundleException {
        return this.loadManifest(baseData, false);
    }

    public Dictionary loadManifest(BaseData baseData, boolean bl) throws BundleException {
        Dictionary dictionary = null;
        StorageHook[] storageHookArray = baseData.getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length && dictionary == null) {
            dictionary = storageHookArray[n].getManifest(bl);
            ++n;
        }
        if (dictionary == null) {
            dictionary = AdaptorUtil.loadManifestFrom(baseData);
        }
        if (dictionary == null) {
            throw (Throwable)new BundleException(NLS.bind(AdaptorMsg.MANIFEST_NOT_FOUND_EXCEPTION, "META-INF/MANIFEST.MF", baseData.getLocation()));
        }
        return dictionary;
    }

    public BaseData[] getInstalledBundles() {
        return this.readBundleDatas();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseData[] readBundleDatas() {
        InputStream inputStream = this.findStorageStream(".bundledata");
        if (inputStream == null) {
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                ArrayList<BaseData> arrayList;
                StorageHook[] storageHookArray;
                byte by = dataInputStream.readByte();
                if (by != 18) {
                    return null;
                }
                this.timeStamp = dataInputStream.readLong();
                this.initialBundleStartLevel = dataInputStream.readInt();
                this.nextId = dataInputStream.readLong();
                int n = dataInputStream.readInt();
                if (n != (storageHookArray = this.adaptor.getHookRegistry().getStorageHooks()).length) {
                    return null;
                }
                int n2 = 0;
                while (n2 < n) {
                    arrayList = storageHookArray[n2].getKey();
                    int n3 = storageHookArray[n2].getStorageVersion();
                    if (!((Object)arrayList).equals(dataInputStream.readUTF())) return null;
                    if (n3 != dataInputStream.readInt()) {
                        return null;
                    }
                    ++n2;
                }
                n2 = dataInputStream.readInt();
                arrayList = new ArrayList<BaseData>(n2);
                long l = -1L;
                boolean bl = false;
                int n4 = 0;
                while (n4 < n2) {
                    StorageHook[] storageHookArray2;
                    BaseData baseData;
                    boolean bl2;
                    block21: {
                        bl2 = false;
                        baseData = null;
                        try {
                            l = dataInputStream.readLong();
                            if (l != 0L) {
                                baseData = this.loadBaseData(l, dataInputStream);
                                baseData.getBundleFile();
                                storageHookArray2 = baseData.getStorageHooks();
                                int n5 = 0;
                                while (n5 < storageHookArray2.length) {
                                    storageHookArray2[n5].validate();
                                    ++n5;
                                }
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println("BundleData created: " + baseData);
                                }
                                this.processExtension(baseData, (byte)1);
                                arrayList.add(baseData);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            bl = true;
                            bl2 = true;
                        }
                        catch (BundleException bundleException) {
                            bl = true;
                            bl2 = true;
                        }
                        catch (IOException iOException) {
                            bl = true;
                            bl2 = true;
                            if (!Debug.DEBUG_GENERAL) break block21;
                            Debug.println("Error reading framework metadata: " + ((Throwable)iOException).getMessage());
                            Debug.printStackTrace(iOException);
                        }
                    }
                    if (bl2 && baseData != null) {
                        storageHookArray2 = (StorageHook[])baseData.getStorageHook(BaseStorageHook.KEY);
                        storageHookArray2.delete(true, 1);
                    }
                    ++n4;
                }
                if (bl) {
                    FrameworkProperties.setProperty("eclipse.refreshBundles", "true");
                }
                BaseData[] baseDataArray = arrayList.toArray(new BaseData[arrayList.size()]);
                return baseDataArray;
            }
            finally {
                ((FilterInputStream)dataInputStream).close();
            }
        }
        catch (IOException iOException) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.println("Error reading framework metadata: " + ((Throwable)iOException).getMessage());
            Debug.printStackTrace(iOException);
            return null;
        }
    }

    private void saveAllData(boolean bl) {
        if (this.storageManagerClosed) {
            try {
                this.storageManager.open(!LocationManager.getConfigurationLocation().isReadOnly());
                this.storageManagerClosed = false;
            }
            catch (IOException iOException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, ((Throwable)iOException).getMessage());
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, iOException, null);
                this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            }
        }
        this.saveBundleDatas();
        this.saveStateData(bl);
        this.savePermissionStorage();
        if (bl) {
            this.stateManager.stopDataManager();
        }
    }

    private void savePermissionStorage() {
        if (this.permissionStorage == null || this.isReadOnly() || !this.permissionStorage.isDirty()) {
            return;
        }
        try {
            ManagedOutputStream managedOutputStream = this.storageManager.getOutputStream(PERM_DATA_FILE);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(managedOutputStream));
            boolean bl = true;
            try {
                String[] stringArray;
                String[] stringArray2;
                dataOutputStream.writeByte(1);
                String[] stringArray3 = this.permissionStorage.getPermissionData(null);
                dataOutputStream.writeInt(stringArray3 == null ? 0 : stringArray3.length);
                if (stringArray3 != null) {
                    int n = 0;
                    while (n < stringArray3.length) {
                        dataOutputStream.writeUTF(stringArray3[n]);
                        ++n;
                    }
                }
                dataOutputStream.writeInt((stringArray2 = this.permissionStorage.getLocations()) == null ? 0 : stringArray2.length);
                if (stringArray2 != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        dataOutputStream.writeUTF(stringArray2[n]);
                        String[] stringArray4 = this.permissionStorage.getPermissionData(stringArray2[n]);
                        dataOutputStream.writeInt(stringArray4 == null ? 0 : stringArray4.length);
                        if (stringArray4 != null) {
                            int n2 = 0;
                            while (n2 < stringArray4.length) {
                                dataOutputStream.writeUTF(stringArray4[n2]);
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
                dataOutputStream.writeInt((stringArray = this.permissionStorage.getConditionalPermissionInfos()) == null ? 0 : stringArray.length);
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        dataOutputStream.writeUTF(stringArray[n]);
                        ++n;
                    }
                }
                ((FilterOutputStream)dataOutputStream).close();
                this.permissionStorage.setDirty(false);
                bl = false;
            }
            catch (Throwable throwable) {
                if (bl) {
                    managedOutputStream.abort();
                    try {
                        ((FilterOutputStream)dataOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bl) {
                managedOutputStream.abort();
                try {
                    ((FilterOutputStream)dataOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
            return;
        }
    }

    private void saveBundleDatas() {
        if (this.stateManager == null || this.isReadOnly() || this.timeStamp == this.stateManager.getSystemState().getTimeStamp() && !this.stateManager.saveNeeded()) {
            return;
        }
        try {
            ManagedOutputStream managedOutputStream = this.storageManager.getOutputStream(".bundledata");
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(managedOutputStream));
            boolean bl = true;
            try {
                dataOutputStream.writeByte(18);
                dataOutputStream.writeLong(this.stateManager.getSystemState().getTimeStamp());
                dataOutputStream.writeInt(this.initialBundleStartLevel);
                dataOutputStream.writeLong(this.nextId);
                StorageHook[] storageHookArray = this.adaptor.getHookRegistry().getStorageHooks();
                dataOutputStream.writeInt(storageHookArray.length);
                int n = 0;
                while (n < storageHookArray.length) {
                    dataOutputStream.writeUTF((String)storageHookArray[n].getKey());
                    dataOutputStream.writeInt(storageHookArray[n].getStorageVersion());
                    ++n;
                }
                Bundle[] bundleArray = this.context.getBundles();
                dataOutputStream.writeInt(bundleArray.length);
                int n2 = 0;
                while (n2 < bundleArray.length) {
                    long l = bundleArray[n2].getBundleId();
                    dataOutputStream.writeLong(l);
                    if (l != 0L) {
                        BundleData bundleData = ((AbstractBundle)bundleArray[n2]).getBundleData();
                        this.saveBaseData((BaseData)bundleData, dataOutputStream);
                    }
                    ++n2;
                }
                ((FilterOutputStream)dataOutputStream).close();
                this.timeStamp = this.stateManager.getSystemState().getTimeStamp();
                bl = false;
            }
            catch (Throwable throwable) {
                if (bl) {
                    managedOutputStream.abort();
                    try {
                        ((FilterOutputStream)dataOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bl) {
                managedOutputStream.abort();
                try {
                    ((FilterOutputStream)dataOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateData(boolean bl) {
        if (bl && "true".equals(FrameworkProperties.getProperty("osgi.forcedRestart"))) {
            this.stateManager.getSystemState().setTimeStamp(this.stateManager.getSystemState().getTimeStamp() + 1L);
        }
        if (this.stateManager == null || this.isReadOnly() || !this.stateManager.saveNeeded()) {
            return;
        }
        File file = null;
        File file2 = null;
        try {
            try {
                file = File.createTempFile(".state", ".new", LocationManager.getOSGiConfigurationDir());
                file2 = File.createTempFile(".lazy", ".new", LocationManager.getOSGiConfigurationDir());
                if (bl) {
                    this.stateManager.shutdown(file, file2);
                } else {
                    StateManager stateManager = this.stateManager;
                    synchronized (stateManager) {
                        this.stateManager.update(file, file2);
                    }
                }
                this.storageManager.lookup(".state", true);
                this.storageManager.lookup(".lazy", true);
                this.storageManager.update(new String[]{".state", ".lazy"}, new String[]{file.getName(), file2.getName()});
            }
            catch (IOException iOException) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
                if (file != null && file.exists()) {
                    file.delete();
                }
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
        }
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int n) {
        this.initialBundleStartLevel = n;
        this.requestSave();
    }

    public void save(BaseData baseData) throws IOException {
        if (baseData.isDirty()) {
            --this.timeStamp;
            this.requestSave();
            baseData.setDirty(false);
        }
    }

    public BundleOperation installBundle(String string, URLConnection uRLConnection) {
        BaseData baseData = this.createBaseData(this.getNextBundleId(), string);
        return new BundleInstall(baseData, uRLConnection, this);
    }

    public BundleOperation updateBundle(BaseData baseData, URLConnection uRLConnection) {
        return new BundleUpdate(baseData, uRLConnection, this);
    }

    public BundleOperation uninstallBundle(BaseData baseData) {
        return new BundleUninstall(baseData, this);
    }

    protected Object getBundleContent(BaseData baseData) throws IOException {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            throw (Throwable)new IllegalStateException();
        }
        return baseStorageHook.isReference() ? new File(baseStorageHook.getFileName()) : new File(baseStorageHook.getGenerationDir(), baseStorageHook.getFileName());
    }

    public BundleFile createBundleFile(Object object, BaseData baseData) throws IOException {
        boolean bl = false;
        if (object == null) {
            bl = true;
            object = this.getBundleContent(baseData);
        }
        BundleFile bundleFile = null;
        BundleFileFactoryHook[] bundleFileFactoryHookArray = this.adaptor.getHookRegistry().getBundleFileFactoryHooks();
        int n = 0;
        while (n < bundleFileFactoryHookArray.length && bundleFile == null) {
            bundleFile = bundleFileFactoryHookArray[n].createBundleFile(object, baseData, bl);
            ++n;
        }
        if (bundleFile == null && object instanceof File) {
            File file = (File)object;
            bundleFile = file.isDirectory() ? new DirBundleFile(file) : new ZipBundleFile(file, baseData);
        }
        if (bundleFile == null && object instanceof String) {
            bundleFile = new NestedDirBundleFile(baseData.getBundleFile(), (String)object);
        }
        if (bundleFile == null) {
            throw (Throwable)new IOException("Cannot create bundle file for content of type: " + object.getClass().getName());
        }
        BundleFileWrapperFactoryHook[] bundleFileWrapperFactoryHookArray = this.adaptor.getHookRegistry().getBundleFileWrapperFactoryHooks();
        int n2 = 0;
        while (n2 < bundleFileWrapperFactoryHookArray.length) {
            BundleFile bundleFile2 = bundleFileWrapperFactoryHookArray[n2].wrapBundleFile(bundleFile, object, baseData, bl);
            if (bundleFile2 != null) {
                bundleFile = bundleFile2;
            }
            ++n2;
        }
        return bundleFile;
    }

    public synchronized StateManager getStateManager() {
        if (this.stateManager != null) {
            return this.stateManager;
        }
        this.stateManager = this.readStateData();
        this.checkSystemState(this.stateManager.getSystemState());
        return this.stateManager;
    }

    private void checkSystemState(State state) {
        BundleDescription bundleDescription;
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        if (bundleDescriptionArray == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (this.context.getBundle(bundleDescriptionArray[n].getBundleId()) == null) {
                state.removeBundle(bundleDescriptionArray[n]);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            state.resolve(false);
        }
        if ((bundleDescription = state.getBundle(0L)) == null || !bundleDescription.isResolved()) {
            ResolverError[] resolverErrorArray = bundleDescription == null ? new ResolverError[]{} : state.getResolverErrors(bundleDescription);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < resolverErrorArray.length) {
                stringBuffer.append(resolverErrorArray[n2].toString());
                if (n2 < resolverErrorArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            throw (Throwable)new IllegalStateException(NLS.bind(AdaptorMsg.SYSTEMBUNDLE_NOTRESOLVED, stringBuffer.toString()));
        }
    }

    private StateManager readStateData() {
        File[] fileArray = this.findStorageFiles(new String[]{".state", ".lazy"});
        File file = fileArray[0];
        File file2 = fileArray[1];
        this.stateManager = new StateManager(file, file2, this.context, this.timeStamp);
        State state = null;
        if (!this.invalidState && (state = this.stateManager.readSystemState()) != null) {
            return this.stateManager;
        }
        state = this.stateManager.createSystemState();
        Bundle[] bundleArray = this.context.getBundles();
        if (bundleArray == null) {
            return this.stateManager;
        }
        StateObjectFactory stateObjectFactory = this.stateManager.getFactory();
        int n = 0;
        while (n < bundleArray.length) {
            AbstractBundle abstractBundle = (AbstractBundle)bundleArray[n];
            try {
                Dictionary dictionary = this.loadManifest((BaseData)abstractBundle.getBundleData(), true);
                BundleDescription bundleDescription = stateObjectFactory.createBundleDescription(state, dictionary, abstractBundle.getLocation(), abstractBundle.getBundleId());
                state.addBundle(bundleDescription);
            }
            catch (BundleException bundleException) {}
            ++n;
        }
        state.resolve();
        this.invalidState = false;
        return this.stateManager;
    }

    private File[] findStorageFiles(String[] stringArray) {
        File[] fileArray;
        block16: {
            block15: {
                fileArray = new File[stringArray.length];
                try {
                    int n = 0;
                    while (n < fileArray.length) {
                        fileArray[n] = this.storageManager.lookup(stringArray[n], false);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.DEBUG_GENERAL) break block15;
                    Debug.println("Error reading state file " + ((Throwable)iOException).getMessage());
                    Debug.printStackTrace(iOException);
                }
            }
            boolean bl = true;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] == null || !fileArray[n].isFile()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                return fileArray;
            }
            Location location = null;
            Location location2 = LocationManager.getConfigurationLocation();
            if (location2 != null && (location = location2.getParentLocation()) != null) {
                try {
                    File file = new File(location.getURL().getFile(), "org.eclipse.osgi");
                    StorageManager storageManager = this.initFileManager(file, "none", true);
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        fileArray[n2] = storageManager.lookup(stringArray[n2], false);
                        ++n2;
                    }
                    storageManager.close();
                }
                catch (IOException iOException) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("Error reading state file " + ((Throwable)iOException).getMessage());
                        Debug.printStackTrace(iOException);
                    }
                    break block16;
                }
            }
            try {
                if (!this.isReadOnly()) {
                    int n3 = 0;
                    while (n3 < fileArray.length) {
                        fileArray[n3] = this.storageManager.lookup(stringArray[n3], true);
                        ++n3;
                    }
                }
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block16;
                Debug.println("Error reading state file " + ((Throwable)iOException).getMessage());
                Debug.printStackTrace(iOException);
            }
        }
        return fileArray;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        this.context = bundleContext;
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_ENABLE_STATE_SAVER, "true")).booleanValue()) {
            this.stateSaver = new BaseStorage$StateSaver(this);
        }
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (this.stateSaver != null) {
            this.stateSaver.shutdown();
        }
        this.saveAllData(true);
        this.storageManager.close();
        this.storageManagerClosed = true;
        if (this.extensionListener != null) {
            this.context.removeBundleListener(this.extensionListener);
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
        if (this.addFwkURLMethod != null) {
            ((Hashtable)properties).put("org.osgi.supports.framework.extension", "true");
        }
        ((Hashtable)properties).put(PROP_BUNDLE_STORE, this.getBundleStoreRoot().getAbsolutePath());
    }

    private InputStream findStorageStream(String string) {
        InputStream inputStream;
        block7: {
            inputStream = null;
            try {
                inputStream = this.storageManager.getInputStream(string);
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block7;
                Debug.println("Error reading framework metadata: " + ((Throwable)iOException).getMessage());
                Debug.printStackTrace(iOException);
            }
        }
        if (inputStream == null) {
            Location location = LocationManager.getConfigurationLocation();
            Location location2 = null;
            if (location != null && (location2 = location.getParentLocation()) != null) {
                try {
                    File file = new File(location2.getURL().getFile(), "org.eclipse.osgi");
                    StorageManager storageManager = this.initFileManager(file, "none", true);
                    inputStream = storageManager.getInputStream(string);
                    storageManager.close();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
        return inputStream;
    }

    protected void saveBaseData(BaseData baseData, DataOutputStream dataOutputStream) throws IOException {
        StorageHook[] storageHookArray = baseData.getStorageHooks();
        dataOutputStream.writeInt(storageHookArray.length);
        int n = 0;
        while (n < storageHookArray.length) {
            dataOutputStream.writeUTF((String)storageHookArray[n].getKey());
            storageHookArray[n].save(dataOutputStream);
            ++n;
        }
    }

    protected BaseData createBaseData(long l, String string) {
        BaseData baseData = new BaseData(l, this.adaptor);
        baseData.setLocation(string);
        return baseData;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    private void cleanOSGiCache() {
        File file = LocationManager.getOSGiConfigurationDir();
        AdaptorUtil.rm(file);
    }

    protected void processExtension(BaseData baseData, byte by) throws BundleException {
        if ((baseData.getType() & 2) != 0) {
            this.validateExtension(baseData);
            this.processFrameworkExtension(baseData, by);
        } else if ((baseData.getType() & 4) != 0) {
            this.validateExtension(baseData);
            this.processBootExtension(baseData, by);
        } else if ((baseData.getType() & 0x10) != 0) {
            this.validateExtension(baseData);
            this.processExtExtension(baseData, by);
        }
    }

    private void initBundleStoreRoot() {
        File file = LocationManager.getOSGiConfigurationDir();
        this.bundleStoreRoot = file != null ? new File(file, "bundles") : new File("bundles");
    }

    public File getBundleStoreRoot() {
        if (this.bundleStoreRoot == null) {
            this.initBundleStoreRoot();
        }
        return this.bundleStoreRoot;
    }

    void requestSave() {
        if (this.stateSaver == null) {
            return;
        }
        this.stateSaver.requestSave();
    }

    public void updateState(BundleData bundleData, int n) throws BundleException {
        if (this.stateManager == null) {
            this.invalidState = true;
            return;
        }
        State state = this.stateManager.getSystemState();
        BundleDescription bundleDescription = null;
        BundleDescription bundleDescription2 = null;
        switch (n) {
            case 1: 
            case 8: {
                if (n == 8) {
                    bundleDescription = state.getBundle(bundleData.getBundleID());
                }
                bundleDescription2 = this.stateManager.getFactory().createBundleDescription(state, bundleData.getManifest(), bundleData.getLocation(), bundleData.getBundleID());
                if (bundleDescription == null) {
                    state.addBundle(bundleDescription2);
                    break;
                }
                state.updateBundle(bundleDescription2);
                break;
            }
            case 16: {
                state.removeBundle(bundleData.getBundleID());
            }
        }
        if (bundleDescription2 != null) {
            boolean bl = false;
            try {
                this.verifyEEandNativeCode(bundleDescription2, bundleData, state);
                this.validateNativeCodePaths(bundleDescription2, (BaseData)bundleData);
                bl = true;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    if (bundleDescription != null) {
                        state.updateBundle(bundleDescription);
                    } else {
                        state.removeBundle(bundleDescription2);
                    }
                }
                throw throwable;
            }
            if (!bl) {
                if (bundleDescription != null) {
                    state.updateBundle(bundleDescription);
                } else {
                    state.removeBundle(bundleDescription2);
                }
            }
        }
    }

    private void validateNativeCodePaths(BundleDescription bundleDescription, BaseData baseData) {
        NativeCodeSpecification nativeCodeSpecification = bundleDescription.getNativeCodeSpecification();
        if (nativeCodeSpecification == null) {
            return;
        }
        NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
        int n = 0;
        while (n < nativeCodeDescriptionArray.length) {
            BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
            if (baseStorageHook != null) {
                try {
                    baseStorageHook.validateNativePaths(nativeCodeDescriptionArray[n].getNativePaths());
                }
                catch (BundleException bundleException) {
                    this.stateManager.getSystemState().setNativePathsInvalid(nativeCodeDescriptionArray[n], true);
                }
            }
            ++n;
        }
    }

    private void verifyEEandNativeCode(BundleDescription bundleDescription, BundleData bundleData, State state) throws BundleException {
        int n;
        Object[] objectArray;
        Object object;
        if (!Boolean.valueOf(FrameworkProperties.getProperty(Constants.ECLIPSE_EE_INSTALL_VERIFY, Boolean.TRUE.toString())).booleanValue() || bundleDescription == null) {
            return;
        }
        String[] stringArray = bundleDescription.getExecutionEnvironments();
        if (stringArray.length > 0 && (object = FrameworkProperties.getProperty("org.osgi.framework.executionenvironment")) != null && !((String)object).equals("")) {
            int n2;
            objectArray = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", (String)object);
            boolean bl = false;
            n = 0;
            while (n < objectArray.length && !bl) {
                n2 = 0;
                while (n2 < stringArray.length & !bl) {
                    if (((ManifestElement)objectArray[n]).getValue().equals(stringArray[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer(25);
                n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
                throw (Throwable)new BundleException("Cannot match Execution Environment: " + stringBuffer.toString());
            }
        }
        if ((object = bundleDescription.getNativeCodeSpecification()) != null) {
            state.setPlatformProperties(new Dictionary[]{FrameworkProperties.getProperties()});
            objectArray = object.getPossibleSuppliers();
            Object object2 = null;
            n = 0;
            while (n < objectArray.length) {
                if (object.isSatisfiedBy((BaseDescription)objectArray[n]) && (object2 == null || object2.compareTo(objectArray[n]) < 0)) {
                    object2 = objectArray[n];
                }
                ++n;
            }
            if (object2 == null) {
                if (!object.isOptional()) {
                    throw (Throwable)new BundleException("Unsatisfied Bundle-NativeCode: " + object.toString());
                }
            } else {
                bundleData.installNativeCode(object2.getNativePaths());
            }
        }
    }

    public long getNextBundleId() {
        return this.nextId++;
    }

    static BaseAdaptor access$0(BaseStorage baseStorage) {
        return baseStorage.adaptor;
    }

    static void access$1(BaseStorage baseStorage, boolean bl) {
        baseStorage.saveAllData(bl);
    }

    private static void callAddURLMethod(ClassLoader classLoader, Method method, URL uRL) throws InvocationTargetException {
        BaseStorage$$Cold.callAddURLMethod(classLoader, method, uRL);
    }

    public File getDataFile(BaseData baseData, String string) throws  {
        return BaseStorage$$Cold.getDataFile(this, baseData, string);
    }

    public void installNativeCode(BaseData baseData, String[] stringArray) throws BundleException {
        BaseStorage$$Cold.installNativeCode(this, baseData, stringArray);
    }

    public File getExtractFile(BaseData baseData, String string) throws  {
        return BaseStorage$$Cold.getExtractFile(this, baseData, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BasePermissionStorage readPermissionData() {
        BasePermissionStorage basePermissionStorage = new BasePermissionStorage(this);
        InputStream inputStream = this.findStorageStream(PERM_DATA_FILE);
        if (inputStream == null) {
            return basePermissionStorage;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                String[] stringArray;
                int n;
                int n2;
                if (1 != dataInputStream.readByte()) {
                    BasePermissionStorage basePermissionStorage2 = basePermissionStorage;
                    return basePermissionStorage2;
                }
                int n3 = dataInputStream.readInt();
                if (n3 > 0) {
                    String[] stringArray2 = new String[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        stringArray2[n2] = dataInputStream.readUTF();
                        ++n2;
                    }
                    basePermissionStorage.setPermissionData(null, stringArray2);
                }
                if ((n = dataInputStream.readInt()) > 0) {
                    n2 = 0;
                    while (n2 < n) {
                        stringArray = dataInputStream.readUTF();
                        n3 = dataInputStream.readInt();
                        String[] stringArray3 = new String[n3];
                        int n4 = 0;
                        while (n4 < n3) {
                            stringArray3[n4] = dataInputStream.readUTF();
                            ++n4;
                        }
                        basePermissionStorage.setPermissionData((String)stringArray, stringArray3);
                        ++n2;
                    }
                }
                if ((n2 = dataInputStream.readInt()) > 0) {
                    stringArray = new String[n2];
                    int n5 = 0;
                    while (n5 < n2) {
                        stringArray[n5] = dataInputStream.readUTF();
                        ++n5;
                    }
                    basePermissionStorage.saveConditionalPermissionInfos(stringArray);
                }
                basePermissionStorage.setDirty(false);
                return basePermissionStorage;
            }
            finally {
                ((FilterInputStream)dataInputStream).close();
            }
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
        }
        return basePermissionStorage;
    }

    public PermissionStorage getPermissionStorage() throws IOException {
        if (this.permissionStorage == null) {
            this.permissionStorage = this.readPermissionData();
        }
        return this.permissionStorage;
    }

    protected BaseData loadBaseData(long l, DataInputStream dataInputStream) throws IOException {
        BaseData baseData = new BaseData(l, this.adaptor);
        int n = dataInputStream.readInt();
        StorageHook[] storageHookArray = new StorageHook[n];
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            StorageHook storageHook = (StorageHook)this.storageHooks.getByKey(string);
            if (storageHook == null) {
                throw (Throwable)new IOException();
            }
            storageHookArray[n2] = storageHook.load(baseData, dataInputStream);
            ++n2;
        }
        baseData.setStorageHooks(storageHookArray);
        return baseData;
    }

    private void validateExtension(BundleData bundleData) throws BundleException {
        BaseStorage$$Cold.validateExtension(this, bundleData);
    }

    protected void processFrameworkExtension(BaseData baseData, byte by) throws BundleException {
        if (this.addFwkURLMethod == null) {
            throw (Throwable)new BundleException("Framework extensions are not supported.", new UnsupportedOperationException());
        }
        this.addExtensionContent(baseData, by, this.getFwkClassLoader(), this.addFwkURLMethod);
    }

    protected void processExtExtension(BaseData baseData, byte by) throws BundleException {
        if (this.addExtURLMethod == null) {
            throw (Throwable)new BundleException("Extension classpath extensions are not supported.", new UnsupportedOperationException());
        }
        this.addExtensionContent(baseData, by, this.getExtClassLoader(), this.addExtURLMethod);
    }

    private void addExtensionContent(BaseData baseData, byte by, ClassLoader classLoader, Method method) throws BundleException {
        if ((by & 0xC) != 0) {
            return;
        }
        String[] stringArray = this.getConfiguredExtensions();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(baseData.getSymbolicName())) {
                return;
            }
            ++n;
        }
        if ((by & 2) != 0) {
            if (this.extensionListener == null) {
                this.extensionListener = this;
                this.context.addBundleListener(this.extensionListener);
            }
            return;
        }
        File[] fileArray = this.getExtensionFiles(baseData);
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2] != null) {
                try {
                    BaseStorage.callAddURLMethod(classLoader, method, AdaptorUtil.encodeFileURL(fileArray[n2]));
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), invocationTargetException);
                }
                catch (MalformedURLException malformedURLException) {
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), malformedURLException);
                }
            }
            ++n2;
        }
        try {
            classLoader.loadClass("thisIsNotAClass");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    protected String[] getConfiguredExtensions() {
        if (this.configuredExtensions != null) {
            return this.configuredExtensions;
        }
        String string = FrameworkProperties.getProperty(PROP_FRAMEWORK_EXTENSIONS);
        this.configuredExtensions = string == null || string.trim().length() == 0 ? new String[0] : ManifestElement.getArrayFromList(string);
        return this.configuredExtensions;
    }

    protected void processBootExtension(BundleData bundleData, byte by) throws BundleException {
        BaseStorage$$Cold.processBootExtension(this, bundleData, by);
    }

    protected File[] getExtensionFiles(BaseData baseData) {
        File[] fileArray = null;
        try {
            Object object;
            String[] stringArray = baseData.getClassPath();
            if (DevClassPathHelper.inDevelopmentMode()) {
                object = DevClassPathHelper.getDevClassPath(baseData.getSymbolicName());
                String[] stringArray2 = stringArray;
                stringArray = new String[stringArray2.length + ((String[])object).length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                System.arraycopy(object, 0, stringArray, stringArray2.length, ((Object)object).length);
            }
            object = new ArrayList(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (".".equals(stringArray[n])) {
                    ((ArrayList)object).add(baseData.getBundleFile().getBaseFile());
                } else {
                    File file = baseData.getBundleFile().getFile(stringArray[n], false);
                    if (file != null) {
                        ((ArrayList)object).add(file);
                    }
                }
                ++n;
            }
            return ((ArrayList)object).toArray(new File[((ArrayList)object).size()]);
        }
        catch (BundleException bundleException) {
            this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), bundleException);
            return fileArray;
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) throws  {
        BaseStorage$$Cold.bundleChanged(this, bundleEvent);
    }

    public String copyToTempLibrary(BaseData baseData, String string) throws IOException {
        return BaseStorage$$Cold.copyToTempLibrary(this, baseData, string);
    }
}

