/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil$$Cold;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class AdaptorUtil {
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    static Class class$0;

    public static void writeStringOrNull(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string);
        }
    }

    public static ServiceRegistration register(String string, Object object, BundleContext bundleContext) {
        Hashtable hashtable = new Hashtable(7);
        Dictionary dictionary = bundleContext.getBundle().getHeaders();
        hashtable.put("service.vendor", dictionary.get("Bundle-Vendor"));
        hashtable.put("service.ranking", new Integer(Integer.MAX_VALUE));
        hashtable.put("service.pid", String.valueOf(bundleContext.getBundle().getBundleId()) + "." + object.getClass().getName());
        return bundleContext.registerService(string, object, (Dictionary)hashtable);
    }

    public static Dictionary loadManifestFrom(BaseData baseData) throws BundleException {
        URL uRL = baseData.getEntry("META-INF/MANIFEST.MF");
        if (uRL == null) {
            return null;
        }
        try {
            return Headers.parseManifest(uRL.openStream());
        }
        catch (IOException iOException) {
            throw (Throwable)new BundleException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_DATA_ERROR_READING_MANIFEST, baseData.getLocation()), iOException);
        }
    }

    public static boolean canWrite(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = null;
        try {
            try {
                file2 = File.createTempFile("writtableArea", ".dll", file);
            }
            catch (IOException iOException) {
                if (file2 != null) {
                    file2.delete();
                }
                return false;
            }
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
        return true;
    }

    public static void copyDir(File file, File file2) throws IOException {
        AdaptorUtil$$Cold.copyDir(file, file2);
    }

    public static void readFile(InputStream inputStream, File file) throws IOException {
        AdaptorUtil$$Cold.readFile(inputStream, file);
    }

    public static boolean rm(File file) throws  {
        return AdaptorUtil$$Cold.rm(file);
    }

    public static String readString(DataInputStream dataInputStream, boolean bl) throws IOException {
        return AdaptorUtil$$Cold.readString(dataInputStream, bl);
    }

    public static Version loadVersion(DataInputStream dataInputStream) throws IOException {
        return AdaptorUtil$$Cold.loadVersion(dataInputStream);
    }

    public static URL encodeFileURL(File file) throws MalformedURLException {
        return AdaptorUtil$$Cold.encodeFileURL(file);
    }
}

