/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;

public class ReliableFileInputStream
extends FilterInputStream {
    private ReliableFile reliable;
    private int sigSize;
    private int readPos;
    private int length;

    public ReliableFileInputStream(String string) throws IOException {
        this(ReliableFile.getReliableFile(string), 0, 0);
    }

    public ReliableFileInputStream(File file) throws IOException {
        this(ReliableFile.getReliableFile(file), 0, 0);
    }

    public ReliableFileInputStream(File file, int n, int n2) throws IOException {
        this(ReliableFile.getReliableFile(file), n, n2);
    }

    private ReliableFileInputStream(ReliableFile reliableFile, int n, int n2) throws IOException {
        super(reliableFile.getInputStream(n, n2));
        this.reliable = reliableFile;
        this.sigSize = reliableFile.getSignatureSize();
        this.readPos = 0;
        this.length = super.available();
        this.length = this.sigSize > this.length ? 0 : (this.length -= this.sigSize);
    }

    public synchronized void close() throws IOException {
        if (this.reliable != null) {
            try {
                super.close();
            }
            finally {
                this.reliable.closeInputFile();
                this.reliable = null;
            }
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readPos >= this.length) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            if (n3 + this.readPos > this.length) {
                n3 = this.length - this.readPos;
            }
            this.readPos += n3;
        }
        return n3;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read() throws IOException {
        if (this.readPos >= this.length) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            ++this.readPos;
        }
        return n;
    }

    public synchronized int available() throws IOException {
        if (this.readPos < this.length) {
            return this.length - this.readPos;
        }
        return 0;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if ((long)this.readPos + l2 > (long)this.length) {
            l2 = this.length - this.readPos;
        }
        this.readPos = (int)((long)this.readPos + l2);
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw (Throwable)new IOException("reset not supported.");
    }
}

