/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol.bundleresource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleResourceHandler;

public class Handler
extends BundleResourceHandler {
    public Handler() {
    }

    public Handler(BundleEntry bundleEntry, BaseAdaptor baseAdaptor) {
        super(bundleEntry, baseAdaptor);
    }

    protected BundleEntry findBundleEntry(URL uRL, AbstractBundle abstractBundle) throws IOException {
        BaseClassLoader baseClassLoader = BundleResourceHandler.getBundleClassLoader(abstractBundle);
        if (baseClassLoader == null) {
            throw (Throwable)new FileNotFoundException(uRL.getPath());
        }
        ClasspathManager classpathManager = baseClassLoader.getClasspathManager();
        int n = uRL.getPort();
        BundleEntry bundleEntry = null;
        if (n == 0) {
            bundleEntry = classpathManager.findLocalEntry(uRL.getPath());
        } else {
            Enumeration enumeration = classpathManager.findLocalEntries(uRL.getPath());
            if (enumeration != null) {
                int n2 = 0;
                while (enumeration.hasMoreElements() && n2 <= n) {
                    bundleEntry = (BundleEntry)enumeration.nextElement();
                    ++n2;
                }
            }
        }
        if (bundleEntry == null) {
            throw (Throwable)new FileNotFoundException(uRL.getPath());
        }
        return bundleEntry;
    }
}

