/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.SystemBundle$$Cold;
import org.eclipse.osgi.framework.internal.core.SystemBundle$SystemBundleHeaders;
import org.osgi.framework.BundleException;

public class SystemBundle
extends BundleHost {
    ProtectionDomain systemDomain;

    protected SystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        Constants.setInternalSymbolicName(this.bundledata.getSymbolicName());
        this.state = 4;
        this.context = this.createContext();
    }

    protected void load() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.systemDomain = this.getClass().getProtectionDomain();
        }
    }

    protected boolean reload(AbstractBundle abstractBundle) {
        return false;
    }

    protected void refresh() {
    }

    protected boolean unload() {
        return false;
    }

    protected void close() {
        this.context.close();
        this.context = null;
        this.state = 1;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (bl) {
            this.framework.checkAdminPermission(this, "class");
            this.checkValid();
        }
        return Class.forName(string);
    }

    public URL getResource(String string) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    public void start() {
        this.framework.checkAdminPermission(this, "execute");
    }

    protected void resume() {
        this.framework.startLevelManager.initialize();
        this.framework.startLevelManager.launch(this.framework.startLevelManager.getFrameworkStartLevel());
    }

    protected void suspend() {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
        this.framework.publishBundleEvent(4, this);
    }

    protected void suspend(boolean bl) {
    }

    public void update(InputStream inputStream) {
        this.update();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    protected void unresolvePermissions(AbstractBundle[] abstractBundleArray) {
    }

    public Dictionary getHeaders(String string) {
        return new SystemBundle$SystemBundleHeaders(this, super.getHeaders(string));
    }

    public void stop() throws  {
        SystemBundle$$Cold.stop(this);
    }

    public void update() throws  {
        SystemBundle$$Cold.update(this);
    }

    public void uninstall() throws BundleException {
        SystemBundle$$Cold.uninstall(this);
    }

    public boolean hasPermission(Object object) throws  {
        return SystemBundle$$Cold.hasPermission(this, object);
    }
}

