/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistryImpl$$Cold;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistryImpl
implements ServiceRegistry {
    protected HashMap publishedServicesByClass;
    protected ArrayList allPublishedServices;
    protected HashMap publishedServicesByContext;

    public void initialize() {
        this.publishedServicesByClass = new HashMap(50);
        this.publishedServicesByContext = new HashMap(50);
        this.allPublishedServices = new ArrayList(50);
    }

    public void publishService(BundleContext bundleContext, ServiceRegistration serviceRegistration) {
        ArrayList<ServiceRegistration> arrayList = (ArrayList<ServiceRegistration>)this.publishedServicesByContext.get(bundleContext);
        if (arrayList == null) {
            arrayList = new ArrayList<ServiceRegistration>(10);
            this.publishedServicesByContext.put(bundleContext, arrayList);
        }
        arrayList.add(serviceRegistration);
        String[] stringArray = ((ServiceRegistrationImpl)serviceRegistration).clazzes;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ArrayList<ServiceRegistration> arrayList2 = (ArrayList<ServiceRegistration>)this.publishedServicesByClass.get(string);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<ServiceRegistration>(10);
                this.publishedServicesByClass.put(string, arrayList2);
            }
            arrayList2.add(serviceRegistration);
            ++n2;
        }
        this.allPublishedServices.add(serviceRegistration);
    }

    public void unpublishService(BundleContext bundleContext, ServiceRegistration serviceRegistration) {
        ArrayList arrayList = (ArrayList)this.publishedServicesByContext.get(bundleContext);
        if (arrayList != null) {
            ((AbstractCollection)arrayList).remove(serviceRegistration);
        }
        String[] stringArray = ((ServiceRegistrationImpl)serviceRegistration).clazzes;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ArrayList arrayList2 = (ArrayList)this.publishedServicesByClass.get(string);
            ((AbstractCollection)arrayList2).remove(serviceRegistration);
            ++n2;
        }
        ((AbstractCollection)this.allPublishedServices).remove(serviceRegistration);
    }

    public ServiceReference[] lookupServiceReferences(String string, Filter filter) {
        ArrayList arrayList = string == null ? this.allPublishedServices : (ArrayList)this.publishedServicesByClass.get(string);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        ArrayList<ServiceReference> arrayList2 = new ArrayList<ServiceReference>(n);
        int n2 = 0;
        while (n2 < n) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)arrayList.get(n2);
            ServiceReference serviceReference = serviceRegistration.getReference();
            if (filter == null || filter.match(serviceReference)) {
                arrayList2.add(serviceReference);
            }
            ++n2;
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        return arrayList2.toArray(new ServiceReference[arrayList2.size()]);
    }

    public ServiceReference[] lookupServiceReferences(BundleContext bundleContext) {
        ArrayList arrayList = (ArrayList)this.publishedServicesByContext.get(bundleContext);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        ArrayList<ServiceReference> arrayList2 = new ArrayList<ServiceReference>(n);
        int n2 = 0;
        while (n2 < n) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)arrayList.get(n2);
            ServiceReference serviceReference = serviceRegistration.getReference();
            arrayList2.add(serviceReference);
            ++n2;
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        return arrayList2.toArray(new ServiceReference[arrayList2.size()]);
    }

    public void unpublishServices(BundleContext bundleContext) throws  {
        ServiceRegistryImpl$$Cold.unpublishServices(this, bundleContext);
    }
}

