/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.DependentPolicy;
import org.eclipse.osgi.framework.internal.core.GlobalPolicy;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import org.eclipse.osgi.framework.internal.core.RegisteredPolicy;
import org.eclipse.osgi.framework.internal.core.SystemPolicy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class PolicyHandler
implements SynchronousBundleListener {
    private static final String DEPENDENT_POLICY = "dependent";
    private static final String GLOBAL_POLICY = "global";
    private static final String REGISTERED_POLICY = "registered";
    private static final String APP_POLICY = "app";
    private static final String EXT_POLICY = "ext";
    private static final String BOOT_POLICY = "boot";
    private static final String PARENT_POLICY = "parent";
    private final BundleLoader policedLoader;
    private volatile Object[] policies = null;
    private final ThreadLocal beingLoaded;
    private final PackageAdmin packageAdmin;

    public PolicyHandler(BundleLoader bundleLoader, String string, PackageAdmin packageAdmin) {
        this.policedLoader = bundleLoader;
        this.policies = PolicyHandler.getArrayFromList(string);
        this.beingLoaded = new ThreadLocal();
        this.packageAdmin = packageAdmin;
    }

    static Object[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new Object[]{} : vector.toArray(new Object[vector.size()]);
    }

    public void open(BundleContext bundleContext) {
        bundleContext.addBundleListener(this);
    }

    public void close(BundleContext bundleContext) {
        bundleContext.removeBundleListener(this);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if ((bundleEvent.getType() & 0x60) == 0) {
            return;
        }
        try {
            String string = (String)this.policedLoader.getBundle().getBundleData().getManifest().get("Eclipse-BuddyPolicy");
            this.policies = PolicyHandler.getArrayFromList(string);
        }
        catch (BundleException bundleException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBuddyPolicy getPolicyImplementation(Object[] objectArray, int n) {
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            block12: {
                if (n < objectArray.length) break block12;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            if (objectArray[n] instanceof String) {
                String string = (String)objectArray[n];
                if (REGISTERED_POLICY.equals(string)) {
                    objectArray[n] = new RegisteredPolicy(this.policedLoader);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (BOOT_POLICY.equals(string)) {
                    objectArray[n] = SystemPolicy.getInstance((byte)0);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (APP_POLICY.equals(string)) {
                    objectArray[n] = SystemPolicy.getInstance((byte)2);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (EXT_POLICY.equals(string)) {
                    objectArray[n] = SystemPolicy.getInstance((byte)1);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (DEPENDENT_POLICY.equals(string)) {
                    objectArray[n] = new DependentPolicy(this.policedLoader);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (GLOBAL_POLICY.equals(string)) {
                    objectArray[n] = new GlobalPolicy(this.packageAdmin);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
                if (PARENT_POLICY.equals(string)) {
                    objectArray[n] = new SystemPolicy(this.policedLoader.getParentClassLoader());
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (IBuddyPolicy)objectArray[n];
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (IBuddyPolicy)objectArray[n];
        }
    }

    public Class doBuddyClassLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        Class clazz = null;
        Object[] objectArray = this.policies;
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n && clazz == null) {
            IBuddyPolicy iBuddyPolicy = this.getPolicyImplementation(objectArray, n2);
            if (iBuddyPolicy != null) {
                clazz = iBuddyPolicy.loadClass(string);
            }
            ++n2;
        }
        this.stopLoading(string);
        return clazz;
    }

    public URL doBuddyResourceLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        URL uRL = null;
        Object[] objectArray = this.policies;
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n && uRL == null) {
            IBuddyPolicy iBuddyPolicy = this.getPolicyImplementation(objectArray, n2);
            if (iBuddyPolicy != null) {
                uRL = iBuddyPolicy.loadResource(string);
            }
            ++n2;
        }
        this.stopLoading(string);
        return uRL;
    }

    public Enumeration doBuddyResourcesLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        Vector vector = null;
        Object[] objectArray = this.policies;
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enumeration enumeration;
            IBuddyPolicy iBuddyPolicy = this.getPolicyImplementation(objectArray, n2);
            if (iBuddyPolicy != null && (enumeration = iBuddyPolicy.loadResources(string)) != null) {
                if (vector == null) {
                    vector = new Vector(n);
                }
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (vector.contains(e)) continue;
                    vector.add(e);
                }
            }
            ++n2;
        }
        this.stopLoading(string);
        return vector == null || vector.isEmpty() ? null : vector.elements();
    }

    private boolean startLoading(String string) {
        HashSet<String> hashSet = (HashSet<String>)this.beingLoaded.get();
        if (hashSet != null && hashSet.contains(string)) {
            return false;
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>(3);
            this.beingLoaded.set(hashSet);
        }
        hashSet.add(string);
        return true;
    }

    private void stopLoading(String string) {
        ((Set)this.beingLoaded.get()).remove(string);
    }
}

