/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundleProtectionDomainImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissions;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.SecurePermissionStorage;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdminImpl
implements PermissionAdmin {
    private static final String ADMIN_IMPLIED_ACTIONS = "resource,metadata,class";
    protected Framework framework;
    protected PermissionStorage storage;
    protected PermissionInfo[] defaultDefaultPermissionInfos;
    protected PermissionInfo[] baseImpliedPermissionInfos;
    protected BundleCombinedPermissions defaultAssignedPermissions;
    static Class class$0;

    protected PermissionAdminImpl(Framework framework, PermissionStorage permissionStorage) {
        this.framework = framework;
        this.storage = permissionStorage;
        this.defaultDefaultPermissionInfos = this.getPermissionInfos(this.getClass().getResource("default.permissions"));
        this.baseImpliedPermissionInfos = this.getPermissionInfos(this.getClass().getResource("implied.permissions"));
        if (Debug.DEBUG_SECURITY) {
            int n;
            Debug.println("Default default assigned bundle permissions");
            if (this.defaultDefaultPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                n = 0;
                while (n < this.defaultDefaultPermissionInfos.length) {
                    Debug.println("  " + this.defaultDefaultPermissionInfos[n]);
                    ++n;
                }
            }
            Debug.println("Base implied bundle permissions");
            if (this.baseImpliedPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                n = 0;
                while (n < this.baseImpliedPermissionInfos.length) {
                    Debug.println("  " + this.baseImpliedPermissionInfos[n]);
                    ++n;
                }
            }
        }
        this.defaultAssignedPermissions = new BundleCombinedPermissions(null);
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(this.getDefaultPermissions()), true);
    }

    public PermissionInfo[] getPermissions(String string) {
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        SecurePermissionStorage securePermissionStorage = new SecurePermissionStorage(this.storage);
        try {
            String[] stringArray = securePermissionStorage.getPermissionData(string);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting permissions for location: " + string);
                if (stringArray == null) {
                    Debug.println("  <none>");
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        Debug.println("  " + stringArray[n]);
                        ++n;
                    }
                }
            }
            return this.makePermissionInfo(stringArray);
        }
        catch (IOException iOException) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iOException);
            return null;
        }
    }

    public void setPermissions(String string, PermissionInfo[] permissionInfoArray) {
        BundleProtectionDomain bundleProtectionDomain;
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        SecurePermissionStorage securePermissionStorage = new SecurePermissionStorage(this.storage);
        try {
            object = this.makePermissionData(permissionInfoArray);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting permissions for location: " + string);
                if (object == null) {
                    Debug.println("  <none>");
                } else {
                    int n = 0;
                    while (n < ((Object)object).length) {
                        Debug.println("  " + (String)object[n]);
                        ++n;
                    }
                }
            }
            securePermissionStorage.setPermissionData(string, (String[])object);
        }
        catch (IOException iOException) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iOException);
            return;
        }
        object = this.framework.getBundleByLocation(string);
        if (object != null && ((AbstractBundle)object).getBundleId() != 0L && (bundleProtectionDomain = ((AbstractBundle)object).getProtectionDomain()) != null) {
            BundleCombinedPermissions bundleCombinedPermissions = (BundleCombinedPermissions)((ProtectionDomain)bundleProtectionDomain).getPermissions();
            if (permissionInfoArray == null) {
                bundleCombinedPermissions.setAssignedPermissions(this.defaultAssignedPermissions, true);
            } else {
                bundleCombinedPermissions.setAssignedPermissions(this.createPermissions(permissionInfoArray, (AbstractBundle)object, false), false);
            }
        }
    }

    public String[] getLocations() {
        SecurePermissionStorage securePermissionStorage = new SecurePermissionStorage(this.storage);
        try {
            String[] stringArray = securePermissionStorage.getLocations();
            return stringArray;
        }
        catch (IOException iOException) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iOException);
            return null;
        }
    }

    public PermissionInfo[] getDefaultPermissions() {
        SecurePermissionStorage securePermissionStorage = new SecurePermissionStorage(this.storage);
        try {
            String[] stringArray = securePermissionStorage.getPermissionData(null);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting default permissions");
                if (stringArray == null) {
                    Debug.println("  <none>");
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        Debug.println("  " + stringArray[n]);
                        ++n;
                    }
                }
            }
            return this.makePermissionInfo(stringArray);
        }
        catch (IOException iOException) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iOException);
            return null;
        }
    }

    public void setDefaultPermissions(PermissionInfo[] permissionInfoArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        SecurePermissionStorage securePermissionStorage = new SecurePermissionStorage(this.storage);
        try {
            String[] stringArray = this.makePermissionData(permissionInfoArray);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting default permissions");
                if (stringArray == null) {
                    Debug.println("  <none>");
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        Debug.println("  " + stringArray[n]);
                        ++n;
                    }
                }
            }
            securePermissionStorage.setPermissionData(null, stringArray);
        }
        catch (IOException iOException) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iOException);
            return;
        }
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(permissionInfoArray), true);
    }

    protected PermissionInfo[] makePermissionInfo(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        PermissionInfo[] permissionInfoArray = new PermissionInfo[n];
        int n2 = 0;
        while (n2 < n) {
            permissionInfoArray[n2] = new PermissionInfo(stringArray[n2]);
            ++n2;
        }
        return permissionInfoArray;
    }

    protected String[] makePermissionData(PermissionInfo[] permissionInfoArray) {
        if (permissionInfoArray == null) {
            return null;
        }
        int n = permissionInfoArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = permissionInfoArray[n2].getEncoded();
            ++n2;
        }
        return stringArray;
    }

    protected BundleProtectionDomain createProtectionDomain(AbstractBundle abstractBundle) {
        BundlePermissionCollection bundlePermissionCollection;
        BundlePermissionCollection bundlePermissionCollection2 = this.getImpliedPermissions(abstractBundle);
        BundleCombinedPermissions bundleCombinedPermissions = new BundleCombinedPermissions(bundlePermissionCollection2);
        bundleCombinedPermissions.setAssignedPermissions(bundlePermissionCollection, (bundlePermissionCollection = this.getAssignedPermissions(abstractBundle)) == this.defaultAssignedPermissions);
        bundleCombinedPermissions.setConditionalPermissions(new ConditionalPermissions(abstractBundle, this.framework.condPermAdmin));
        PermissionInfo[] permissionInfoArray = this.getPermissionInfos(abstractBundle.getEntry("OSGI-INF/permissions.perm"));
        if (permissionInfoArray != null) {
            ConditionalPermissionInfoImpl[] conditionalPermissionInfoImplArray = new ConditionalPermissionInfoImpl[]{new ConditionalPermissionInfoImpl(null, ConditionalPermissionAdminImpl.EMPTY_COND_INFO, permissionInfoArray)};
            ConditionalPermissionSet conditionalPermissionSet = new ConditionalPermissionSet(abstractBundle, conditionalPermissionInfoImplArray, ConditionalPermissionAdminImpl.EMPTY_COND);
            bundleCombinedPermissions.setRestrictedPermissions(conditionalPermissionSet);
        }
        return new BundleProtectionDomainImpl(abstractBundle, (PermissionCollection)bundleCombinedPermissions);
    }

    protected BundlePermissionCollection createDefaultAssignedPermissions(PermissionInfo[] permissionInfoArray) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating default assigned permissions");
        }
        if (permissionInfoArray == null) {
            permissionInfoArray = this.defaultDefaultPermissionInfos;
        }
        return this.createPermissions(permissionInfoArray, null, false);
    }

    protected BundlePermissionCollection getAssignedPermissions(AbstractBundle abstractBundle) {
        String string = abstractBundle.getLocation();
        PermissionInfo[] permissionInfoArray = this.getPermissions(string);
        if (permissionInfoArray == null) {
            return this.defaultAssignedPermissions;
        }
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating assigned permissions for " + abstractBundle);
        }
        return this.createPermissions(permissionInfoArray, abstractBundle, false);
    }

    protected BundlePermissionCollection getImpliedPermissions(AbstractBundle abstractBundle) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating implied permissions for " + abstractBundle);
        }
        return this.createPermissions(this.baseImpliedPermissionInfos, abstractBundle, true);
    }

    protected PermissionInfo[] getPermissionInfos(URL uRL) {
        PermissionInfo[] permissionInfoArray;
        block21: {
            if (uRL == null) {
                return null;
            }
            permissionInfoArray = ConditionalPermissionAdminImpl.EMPTY_PERM_INFO;
            DataInputStream dataInputStream = null;
            try {
                try {
                    String string;
                    BufferedReader bufferedReader;
                    dataInputStream = new DataInputStream(uRL.openStream());
                    ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
                    }
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() == 0 || string.startsWith("#") || string.startsWith("//")) continue;
                        try {
                            arrayList.add(new PermissionInfo(string));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, illegalArgumentException);
                        }
                    }
                    int n = arrayList.size();
                    if (n > 0) {
                        permissionInfoArray = arrayList.toArray(new PermissionInfo[n]);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (dataInputStream != null) {
                            ((FilterInputStream)dataInputStream).close();
                        }
                        break block21;
                    }
                    catch (IOException iOException2) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (dataInputStream != null) {
                        ((FilterInputStream)dataInputStream).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (dataInputStream != null) {
                    ((FilterInputStream)dataInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return permissionInfoArray;
    }

    protected BundlePermissionCollection createPermissions(PermissionInfo[] permissionInfoArray, AbstractBundle abstractBundle, boolean bl) {
        Object object;
        if (permissionInfoArray == null) {
            permissionInfoArray = new PermissionInfo[]{};
        }
        if (bl) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.framework.AdminPermission");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            object = new PermissionInfo(clazz.getName(), "(id=" + abstractBundle.getBundleId() + ")", ADMIN_IMPLIED_ACTIONS);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Created permission: " + object);
            }
            PermissionInfo[] permissionInfoArray2 = new PermissionInfo[permissionInfoArray.length + 1];
            System.arraycopy(permissionInfoArray, 0, permissionInfoArray2, 0, permissionInfoArray.length);
            permissionInfoArray2[permissionInfoArray.length] = object;
            permissionInfoArray = permissionInfoArray2;
        }
        object = new ConditionalPermissionInfoImpl[]{new ConditionalPermissionInfoImpl(null, ConditionalPermissionAdminImpl.EMPTY_COND_INFO, permissionInfoArray)};
        return new ConditionalPermissionSet(abstractBundle, (ConditionalPermissionInfoImpl[])object, ConditionalPermissionAdminImpl.EMPTY_COND);
    }
}

