/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl$$Cold;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl$1;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl$2;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;
    static Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.PackageAdminImpl$GetBundleAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        clazz2.getName();
    }

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] bundleArray) {
        Bundle[] bundleArray2;
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        AbstractBundle[] abstractBundleArray = null;
        if (bundleArray != null) {
            bundleArray2 = bundleArray;
            // MONITORENTER : bundleArray
            abstractBundleArray = new AbstractBundle[bundleArray.length];
            System.arraycopy(bundleArray, 0, abstractBundleArray, 0, bundleArray.length);
            // MONITOREXIT : bundleArray2
        }
        bundleArray2 = abstractBundleArray;
        Thread thread = this.framework.secureAction.createThread(new PackageAdminImpl$1(this, (AbstractBundle[])bundleArray2), "Refresh Packages");
        thread.start();
    }

    public boolean resolveBundles(Bundle[] bundleArray) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundleArray == null) {
            bundleArray = this.framework.getAllBundles();
        }
        int n = 0;
        while (n < bundleArray.length) {
            if (!((AbstractBundle)bundleArray[n]).isResolved()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doResolveBundles(AbstractBundle[] abstractBundleArray, boolean bl) {
        try {
            try {
                if (Profile.STARTUP) {
                    Profile.logEnter("resolve bundles");
                }
                this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                State state = this.framework.adaptor.getState();
                BundleDescription[] bundleDescriptionArray = null;
                BundleDelta[] bundleDeltaArray = this.framework.bundles;
                synchronized (this.framework.bundles) {
                    int n;
                    int n2 = n = abstractBundleArray == null ? 0 : abstractBundleArray.length;
                    if (!bl) {
                        bundleDescriptionArray = new BundleDescription[]{};
                    } else if (n > 0) {
                        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(n);
                        BundleDelta[] bundleDeltaArray2 = null;
                        int n3 = 0;
                        while (n3 < n) {
                            AbstractBundle[] abstractBundleArray2;
                            BundleDescription bundleDescription = abstractBundleArray[n3].getBundleDescription();
                            if (bundleDescription != null && bundleDescription.getBundleId() != 0L && !arrayList.contains(bundleDescription)) {
                                arrayList.add(bundleDescription);
                            }
                            if ((abstractBundleArray2 = this.framework.bundles.getBundles(abstractBundleArray[n3].getSymbolicName())) != null && abstractBundleArray2.length > 1) {
                                if (bundleDeltaArray2 == null) {
                                    bundleDeltaArray2 = state.getChanges().getChanges(1, false);
                                }
                                int n4 = 0;
                                while (n4 < abstractBundleArray2.length) {
                                    BundleDescription bundleDescription2;
                                    if (abstractBundleArray2[n4] != abstractBundleArray[n3] && (bundleDescription2 = abstractBundleArray2[n4].getBundleDescription()) != null && bundleDescription2.getBundleId() != 0L && !arrayList.contains(bundleDescription2) && this.checkExtensionBundle(bundleDescription2, bundleDeltaArray2)) {
                                        arrayList.add(bundleDescription2);
                                    }
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                        bundleDescriptionArray = arrayList.size() == 0 ? null : arrayList.toArray(new BundleDescription[arrayList.size()]);
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    bundleDeltaArray = state.resolve(bundleDescriptionArray).getChanges();
                    this.processDelta(bundleDeltaArray, bl, state);
                }
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                    Debug.printStackTrace(throwable);
                }
                if (throwable instanceof RuntimeException) {
                    throw throwable;
                }
                if (throwable instanceof Error) {
                    throw throwable;
                }
                if (Profile.STARTUP) {
                    Profile.logExit("resolve bundles");
                }
                if (this.framework.isActive()) {
                    this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
                    if (bl) {
                        this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                    }
                }
            }
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("resolve bundles");
            }
            if (this.framework.isActive()) {
                this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
                if (bl) {
                    this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                }
            }
        }
        {
            return;
        }
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl, int[] nArray) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (abstractBundleArray == null) {
            return;
        }
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (abstractBundleArray[n].isResolved() && (bl || (abstractBundleArray[n].getBundleData().getStatus() & 2) != 0 && !abstractBundleArray[n].testStateChanging(Thread.currentThread()))) {
                if (nArray[n] == 32) {
                    try {
                        abstractBundleArray[n].start(1);
                    }
                    catch (BundleException bundleException) {
                        this.framework.publishFrameworkEvent(2, abstractBundleArray[n], bundleException);
                    }
                } else {
                    this.framework.resumeBundle(abstractBundleArray[n]);
                }
            }
            ++n;
        }
    }

    private void suspendBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive() && !abstractBundle.isFragment()) {
            this.framework.suspendBundle(abstractBundle, true);
        } else if (abstractBundle.getStateChanging() != Thread.currentThread()) {
            try {
                abstractBundle.beginStateChange();
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
            }
        }
        if (Debug.DEBUG_PACKAGEADMIN && abstractBundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + abstractBundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle abstractBundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (abstractBundle == null) {
            BundleException bundleException = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
            return null;
        }
        boolean bl = true;
        if (abstractBundle.isFragment()) {
            BundleDescription[] bundleDescriptionArray = bundleDescription.getHost().getHosts();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescriptionArray[n].getBundleId());
                bl = ((BundleFragment)abstractBundle).addHost(bundleHost.getLoaderProxy());
                ++n;
            }
        }
        if (bl) {
            abstractBundle.resolve();
        }
        return abstractBundle;
    }

    private void applyDeltas(BundleDelta[] bundleDeltaArray) throws BundleException {
        Arrays.sort(bundleDeltaArray, new PackageAdminImpl$2(this));
        int n = 0;
        while (n < bundleDeltaArray.length) {
            NativeCodeSpecification nativeCodeSpecification;
            AbstractBundle abstractBundle;
            int n2 = bundleDeltaArray[n].getType();
            if ((n2 & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltaArray[n]);
            }
            if ((n2 & 8) != 0 && (abstractBundle = this.setResolved(bundleDeltaArray[n].getBundle())) != null && abstractBundle.isResolved() && (nativeCodeSpecification = bundleDeltaArray[n].getBundle().getNativeCodeSpecification()) != null && nativeCodeSpecification.getSupplier() != null) {
                try {
                    BundleData bundleData = abstractBundle.getBundleData();
                    bundleData.installNativeCode(((NativeCodeDescription)nativeCodeSpecification.getSupplier()).getNativePaths());
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private AbstractBundle[] processDelta(BundleDelta[] var1_1, boolean var2_2, State var3_3) {
        block48: {
            block49: {
                var4_4 = new ArrayList<boolean[]>(var1_1.length);
                var5_5 = 0;
                while (var5_5 < var1_1.length) {
                    if (!((var1_1[var5_5].getType() & 256) != 0 && (var1_1[var5_5].getType() & 2) == 0 || (var6_7 /* !! */  = (boolean[])this.framework.getBundle(var1_1[var5_5].getBundle().getBundleId())) == null || var4_4.contains(var6_7 /* !! */ ))) {
                        var4_4.add(var6_7 /* !! */ );
                    }
                    ++var5_5;
                }
                var5_6 = var4_4.toArray(new AbstractBundle[var4_4.size()]);
                Util.sort(var5_6);
                StartLevelManager.sortByDependency((AbstractBundle[])var5_6);
                var6_7 /* !! */  = new boolean[var5_6.length];
                var7_8 = new int[var5_6.length];
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                }
                var8_9 = false;
                var9_14 = var5_6.length - 1;
                while (var9_14 >= 0) {
                    var6_7 /* !! */ [var9_14] = var5_6[var9_14].isResolved();
                    if (var5_6[var9_14] == this.framework.systemBundle) {
                        var8_9 = true;
                    } else if ((var5_6[var9_14].bundledata.getType() & 2) != 0 && var6_7 /* !! */ [var9_14]) {
                        var8_9 = true;
                    } else if ((var5_6[var9_14].bundledata.getType() & 4) != 0) {
                        var8_9 = true;
                    } else if ((var5_6[var9_14].bundledata.getType() & 16) != 0 && var6_7 /* !! */ [var9_14]) {
                        var8_9 = true;
                    }
                    --var9_14;
                }
                if (!var8_9) break block48;
                FrameworkProperties.setProperty("osgi.forcedRestart", "true");
                this.framework.setForcedRestart(true);
                if (!Debug.DEBUG_PACKAGEADMIN) break block49;
                Debug.println("refreshPackages: release the state change locks");
            }
            if (var2_2) {
                var12_19 = 0;
                while (var12_19 < var5_6.length) {
                    var13_22 = var5_6[var12_19];
                    var13_22.completeStateChange();
                    ++var12_19;
                }
            }
            return null;
        }
        try {
            block50: {
                if (var2_2) {
                    var9_14 = var5_6.length - 1;
                    while (var9_14 >= 0) {
                        var7_8[var9_14] = var5_6[var9_14].getState();
                        this.suspendBundle((AbstractBundle)var5_6[var9_14]);
                        --var9_14;
                    }
                }
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: refresh the bundles");
                }
                var9_15 = this.framework.bundles;
                synchronized (var9_15) {
                    var10_25 = var5_6.length - 1;
                    while (var10_25 >= 0) {
                        var5_6[var10_25].refresh();
                        --var10_25;
                    }
                }
                var9_16 = var5_6.length - 1;
                while (var9_16 >= 0) {
                    if (var6_7 /* !! */ [var9_16]) {
                        this.framework.publishBundleEvent(64, (Bundle)var5_6[var9_16]);
                    }
                    --var9_16;
                }
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: applying deltas to bundles");
                }
                var9_17 = this.framework.bundles;
                synchronized (var9_17) {
                    this.applyDeltas(var1_1);
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5, 8] lbl85 : MonitorExitStatement: MONITOREXIT : var9_17
                }
                {
                    catch (Throwable var11_26) {}
                }
                finally {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    if (!var2_2) break block50;
                    var12_21 = 0;
                    ** while (var12_21 < var5_6.length)
                }
lbl-1000:
                // 1 sources

                {
                    var13_24 = var5_6[var12_21];
                    var13_24.completeStateChange();
                    ++var12_21;
                    continue;
                }
            }
            if (var2_2) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException var8_10) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + ((Throwable)var8_10).getMessage());
                        Debug.printStackTrace(var8_10);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var8_10));
                }
            }
        }
        catch (BundleException var8_11) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + ((Throwable)var8_11).getMessage());
                Debug.printStackTrace(var8_11.getNestedException() == null ? var8_11 : var8_11.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var8_11));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        var8_12 = 0;
        while (var8_12 < var5_6.length) {
            if (var5_6[var8_12].isResolved()) {
                this.framework.publishBundleEvent(32, (Bundle)var5_6[var8_12]);
            }
            ++var8_12;
        }
        if (!this.framework.isActive()) {
            return var5_6;
        }
        if (var2_2) {
            var8_13 = this.framework.getAllBundles();
            var9_18 = 0;
            while (var9_18 < var8_13.length) {
                var8_13[var9_18].unresolvePermissions();
                ++var9_18;
            }
            if (var1_1.length > 0) {
                var3_3.setTimeStamp(var3_3.getTimeStamp() == 0x7FFFFFFFFFFFFFFFL ? 0L : var3_3.getTimeStamp() + 1L);
            }
        }
        this.resumeBundles((AbstractBundle[])var5_6, var2_2, var7_8);
        return var5_6;
    }

    public Bundle[] getBundles(String string, String string2) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        AbstractBundle[] abstractBundleArray = this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null) {
            return null;
        }
        if (string2 == null) {
            AbstractBundle[] abstractBundleArray2 = new AbstractBundle[abstractBundleArray.length];
            System.arraycopy(abstractBundleArray, 0, abstractBundleArray2, 0, abstractBundleArray2.length);
            return abstractBundleArray2;
        }
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(abstractBundleArray.length);
        VersionRange versionRange = new VersionRange(string2);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (versionRange.isIncluded(abstractBundleArray[n].getVersion())) {
                arrayList.add(abstractBundleArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new AbstractBundle[arrayList.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleLoaderProxy[] bundleLoaderProxyArray = ((AbstractBundle)bundle).getHosts();
        if (bundleLoaderProxyArray == null) {
            return null;
        }
        Bundle[] bundleArray = new Bundle[bundleLoaderProxyArray.length];
        int n = 0;
        while (n < bundleLoaderProxyArray.length) {
            bundleArray[n] = bundleLoaderProxyArray[n].getBundleHost();
            ++n;
        }
        return bundleArray;
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(SystemBundle systemBundle) {
        this.checkSystemBundle(systemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].getBundleId() == 0L) {
                this.setFrameworkVersion(bundleDescriptionArray[n]);
            } else {
                this.setResolved(bundleDescriptionArray[n]);
            }
            ++n;
        }
    }

    private void checkSystemBundle(SystemBundle systemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription bundleDescription = state.getBundle(0L);
            boolean bl = false;
            if (bundleDescription == null || !((AbstractBundle)systemBundle).getBundleData().getVersion().equals(bundleDescription.getVersion())) {
                bl = true;
            }
            if (!bl && FrameworkProperties.getProperty("osgi.dev") == null) {
                return;
            }
            BundleDescription bundleDescription2 = state.getFactory().createBundleDescription(state, systemBundle.getHeaders(""), ((AbstractBundle)systemBundle).getLocation(), 0L);
            if (bundleDescription2 == null) {
                throw (Throwable)new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            if (!bl) {
                ExportPackageDescription[] exportPackageDescriptionArray;
                ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getExportPackages();
                if (exportPackageDescriptionArray2.length >= (exportPackageDescriptionArray = bundleDescription2.getExportPackages()).length) {
                    int n = 0;
                    while (n < exportPackageDescriptionArray.length && !bl) {
                        if (exportPackageDescriptionArray2[n].getName().equals(exportPackageDescriptionArray[n].getName())) {
                            Version version = exportPackageDescriptionArray2[n].getVersion();
                            Version version2 = exportPackageDescriptionArray[n].getVersion();
                            bl = version == null ? version2 != null : !((Object)version).equals(version2);
                        } else {
                            bl = true;
                        }
                        ++n;
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                state.removeBundle(0L);
                state.addBundle(bundleDescription2);
                state.resolve(false);
            }
        }
        catch (BundleException bundleException) {
            ((Throwable)bundleException).printStackTrace();
            throw (Throwable)new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, ((Throwable)bundleException).getMessage()));
        }
    }

    private void setFrameworkVersion(BundleDescription bundleDescription) {
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (exportPackageDescriptionArray[n].getName().equals("org.osgi.framework")) {
                FrameworkProperties.setProperty("org.osgi.framework.version", exportPackageDescriptionArray[n].getVersion().toString());
                break;
            }
            ++n;
        }
        FrameworkProperties.setProperty("osgi.framework.version", bundleDescription.getVersion().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> arrayList = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            ExportPackageDescription[] exportPackageDescriptionArray = this.framework.adaptor.getState().getExportedPackages();
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                ExportedPackageImpl exportedPackageImpl = this.createExportedPackage(exportPackageDescriptionArray[n]);
                if (exportedPackageImpl != null && (bundle == null || exportedPackageImpl.getBundle() == bundle)) {
                    arrayList.add(exportedPackageImpl);
                }
                ++n;
            }
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription exportPackageDescription) throws  {
        return PackageAdminImpl$$Cold.createExportedPackage(this, exportPackageDescription);
    }

    public ExportedPackage getExportedPackage(String string) throws  {
        return PackageAdminImpl$$Cold.getExportedPackage(this, string);
    }

    public ExportedPackage[] getExportedPackages(String string) throws  {
        return PackageAdminImpl$$Cold.getExportedPackages(this, string);
    }

    private boolean checkExtensionBundle(BundleDescription bundleDescription, BundleDelta[] bundleDeltaArray) throws  {
        return PackageAdminImpl$$Cold.checkExtensionBundle(this, bundleDescription, bundleDeltaArray);
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        PackageAdminImpl$$Cold.applyRemovalPending(this, bundleDelta);
    }

    public RequiredBundle[] getRequiredBundles(String string) throws  {
        return PackageAdminImpl$$Cold.getRequiredBundles(this, string);
    }

    Bundle getBundlePriv(Class clazz) throws  {
        return PackageAdminImpl$$Cold.getBundlePriv(this, clazz);
    }

    public Bundle getBundle(Class clazz) throws  {
        return PackageAdminImpl$$Cold.getBundle(this, clazz);
    }
}

