/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl$GetBundleAction;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl$$Cold {
    public static void applyRemovalPending(PackageAdminImpl packageAdminImpl, BundleDelta bundleDelta) {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundleDescription = bundleDelta.getBundle();
            if (bundleDescription.getDependents() != null && bundleDescription.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundleDescription);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw (Throwable)new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
            if (bundleLoaderProxy != null) {
                BundleHost.closeBundleLoader(bundleLoaderProxy);
                try {
                    bundleLoaderProxy.getBundleHost().getBundleData().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean checkExtensionBundle(PackageAdminImpl packageAdminImpl, BundleDescription bundleDescription, BundleDelta[] bundleDeltaArray) {
        if (bundleDescription.getHost() == null || !bundleDescription.isResolved()) {
            return true;
        }
        return ((BundleDescription)bundleDescription.getHost().getSupplier()).getBundleId() != 0L || bundleDeltaArray.length > 0;
    }

    public static ExportedPackageImpl createExportedPackage(PackageAdminImpl packageAdminImpl, ExportPackageDescription exportPackageDescription) {
        BundleDescription bundleDescription = exportPackageDescription.getExporter();
        if (bundleDescription == null || bundleDescription.getHost() != null) {
            return null;
        }
        BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
        if (bundleLoaderProxy == null) {
            BundleHost bundleHost = (BundleHost)packageAdminImpl.framework.getBundle(bundleDescription.getBundleId());
            if (bundleHost == null) {
                return null;
            }
            bundleLoaderProxy = bundleHost.getLoaderProxy();
        }
        return new ExportedPackageImpl(exportPackageDescription, bundleLoaderProxy);
    }

    public static Bundle getBundle(PackageAdminImpl packageAdminImpl, Class clazz) {
        if (System.getSecurityManager() == null) {
            return packageAdminImpl.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new PackageAdminImpl$GetBundleAction(packageAdminImpl, clazz));
    }

    public static Bundle getBundlePriv(PackageAdminImpl packageAdminImpl, Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof BundleClassLoader) {
            return ((BundleLoader)((BundleClassLoader)((Object)classLoader)).getDelegate()).bundle;
        }
        if (classLoader == packageAdminImpl.getClass().getClassLoader()) {
            return packageAdminImpl.framework.systemBundle;
        }
        return null;
    }

    public static ExportedPackage getExportedPackage(PackageAdminImpl packageAdminImpl, String string) {
        ExportedPackage[] exportedPackageArray = packageAdminImpl.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ExportedPackage exportedPackage = null;
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                if (exportedPackage == null) {
                    exportedPackage = exportedPackageArray[n];
                } else {
                    Version version = Version.parseVersion(exportedPackage.getSpecificationVersion());
                    Version version2 = Version.parseVersion(exportedPackageArray[n].getSpecificationVersion());
                    if (version2.compareTo(version) >= 0) {
                        exportedPackage = exportedPackageArray[n];
                    }
                }
            }
            ++n;
        }
        return exportedPackage;
    }

    public static ExportedPackage[] getExportedPackages(PackageAdminImpl packageAdminImpl, String string) {
        ExportedPackage[] exportedPackageArray = packageAdminImpl.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ArrayList<ExportedPackage> arrayList = new ArrayList<ExportedPackage>(1);
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                arrayList.add(exportedPackageArray[n]);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    public static RequiredBundle[] getRequiredBundles(PackageAdminImpl packageAdminImpl, String string) {
        AbstractBundle[] abstractBundleArray = string == null ? packageAdminImpl.framework.getAllBundles() : packageAdminImpl.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null || abstractBundleArray.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> arrayList = new ArrayList<BundleLoaderProxy>(abstractBundleArray.length);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (!abstractBundleArray[n].isFragment() && abstractBundleArray[n].isResolved() && abstractBundleArray[n].getSymbolicName() != null) {
                arrayList.add(((BundleHost)abstractBundleArray[n]).getLoaderProxy());
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new RequiredBundle[arrayList.size()]);
    }
}

