/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization$BundleResourceBundle;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization$EmptyResouceBundle;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization$LocalizationResourceBundle;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.Bundle;

public class ManifestLocalization {
    private AbstractBundle bundle = null;
    private Dictionary rawHeaders = null;
    private Dictionary defaultLocaleHeaders = null;
    private Hashtable cache = new Hashtable(5);

    public ManifestLocalization(AbstractBundle abstractBundle, Dictionary dictionary) {
        this.bundle = abstractBundle;
        this.rawHeaders = dictionary;
    }

    protected Dictionary getHeaders(String string) {
        if (string.length() == 0) {
            return this.rawHeaders;
        }
        boolean bl = false;
        String string2 = Locale.getDefault().toString();
        if (string.equals(string2)) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            bl = true;
        }
        try {
            this.bundle.checkValid();
        }
        catch (IllegalStateException illegalStateException) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            return this.rawHeaders;
        }
        ResourceBundle resourceBundle = this.getResourceBundle(string);
        if (resourceBundle == null && !bl) {
            resourceBundle = this.getResourceBundle(string2);
        }
        Enumeration enumeration = this.rawHeaders.keys();
        Headers headers = new Headers(this.rawHeaders.size());
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)this.rawHeaders.get(string3);
            if (string4.startsWith("%") && string4.length() > 1) {
                String string5 = string4.substring(1);
                try {
                    string4 = resourceBundle == null ? string5 : (String)resourceBundle.getObject(string5);
                }
                catch (MissingResourceException missingResourceException) {
                    string4 = string5;
                }
            }
            headers.set(string3, string4);
        }
        headers.setReadOnly();
        if (bl) {
            this.defaultLocaleHeaders = headers;
        }
        return headers;
    }

    private String[] buildNLVariants(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > 0) {
            arrayList.add(string);
            int n = string.lastIndexOf(95);
            String string2 = string = n < 0 ? "" : string.substring(0, n);
        }
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected ResourceBundle getResourceBundle(String string) {
        ManifestLocalization$BundleResourceBundle manifestLocalization$BundleResourceBundle;
        String string2 = (String)this.rawHeaders.get("Bundle-Localization");
        if (string2 == null) {
            string2 = "OSGI-INF/l10n/bundle";
        }
        if ((manifestLocalization$BundleResourceBundle = (ManifestLocalization$BundleResourceBundle)this.cache.get(string)) != null) {
            return (ResourceBundle)((Object)(manifestLocalization$BundleResourceBundle.isEmpty() ? null : manifestLocalization$BundleResourceBundle));
        }
        String[] stringArray = this.buildNLVariants(string);
        ManifestLocalization$BundleResourceBundle manifestLocalization$BundleResourceBundle2 = null;
        int n = stringArray.length - 1;
        while (n >= 0) {
            ManifestLocalization$BundleResourceBundle manifestLocalization$BundleResourceBundle3;
            block21: {
                manifestLocalization$BundleResourceBundle3 = null;
                URL uRL = this.findResource(String.valueOf(string2) + (stringArray[n].equals("") ? stringArray[n] : String.valueOf('_') + stringArray[n]) + ".properties");
                if (uRL == null) {
                    manifestLocalization$BundleResourceBundle3 = (ManifestLocalization$BundleResourceBundle)this.cache.get(stringArray[n]);
                } else {
                    InputStream inputStream = null;
                    try {
                        try {
                            inputStream = uRL.openStream();
                            manifestLocalization$BundleResourceBundle3 = new ManifestLocalization$LocalizationResourceBundle(this, inputStream);
                        }
                        catch (IOException iOException) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (manifestLocalization$BundleResourceBundle3 == null) {
                manifestLocalization$BundleResourceBundle3 = new ManifestLocalization$EmptyResouceBundle(this, null);
            }
            if (manifestLocalization$BundleResourceBundle2 != null) {
                manifestLocalization$BundleResourceBundle3.setParent((ResourceBundle)((Object)manifestLocalization$BundleResourceBundle2));
            }
            this.cache.put(stringArray[n], manifestLocalization$BundleResourceBundle3);
            manifestLocalization$BundleResourceBundle2 = manifestLocalization$BundleResourceBundle3;
            --n;
        }
        manifestLocalization$BundleResourceBundle = (ManifestLocalization$BundleResourceBundle)this.cache.get(string);
        return (ResourceBundle)((Object)(manifestLocalization$BundleResourceBundle.isEmpty() ? null : manifestLocalization$BundleResourceBundle));
    }

    private URL findResource(String string) {
        AbstractBundle abstractBundle = this.bundle;
        if (this.bundle.isResolved()) {
            if (this.bundle.isFragment() && this.bundle.getHosts() != null && (abstractBundle = this.bundle.getHosts()[0].getBundleHost()).getState() == 1) {
                abstractBundle = this.bundle;
            }
            return this.findInResolved(string, abstractBundle);
        }
        return this.findInBundle(string, abstractBundle);
    }

    private URL findInResolved(String string, AbstractBundle abstractBundle) {
        URL uRL = this.findInBundle(string, abstractBundle);
        if (uRL != null) {
            return uRL;
        }
        return this.findInFragments(string, abstractBundle);
    }

    private URL findInBundle(String string, AbstractBundle abstractBundle) {
        return abstractBundle.getEntry(string);
    }

    private URL findInFragments(String string, AbstractBundle abstractBundle) {
        Bundle[] bundleArray = abstractBundle.getFragments();
        URL uRL = null;
        int n = 0;
        while (bundleArray != null && n < bundleArray.length && uRL == null) {
            if (bundleArray[n].getState() != 1) {
                uRL = bundleArray[n].getEntry(string);
            }
            ++n;
        }
        return uRL;
    }
}

