/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.Hashtable;
import java.util.Properties;
import java.util.PropertyPermission;

public class FrameworkProperties {
    private static Properties properties;
    private static final String USING_SYSTEM_PROPERTIES_KEY = "osgi.framework.useSystemProperties";

    static {
        Properties properties = System.getProperties();
        String string = properties.getProperty(USING_SYSTEM_PROPERTIES_KEY);
        if (string == null || string.equalsIgnoreCase(Boolean.TRUE.toString())) {
            FrameworkProperties.properties = properties;
        } else {
            FrameworkProperties.properties = new Properties();
            ((Hashtable)FrameworkProperties.properties).putAll(properties);
        }
    }

    public static Properties getProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return properties;
    }

    public static String getProperty(String string) {
        return FrameworkProperties.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return properties.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return ((Hashtable)properties).put(string, string2);
    }

    public static String clearProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)((Hashtable)properties).remove(string);
    }
}

