/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl$Parser$$Cold;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;

class FilterImpl$Parser {
    protected String filterstring;
    protected char[] filter;
    protected int pos;

    protected FilterImpl$Parser(String string) {
        this.filterstring = string;
        this.filter = string.toCharArray();
        this.pos = 0;
    }

    protected void parse(FilterImpl filterImpl) throws InvalidSyntaxException {
        try {
            this.parse_filter(filterImpl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw (Throwable)new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring);
        }
        if (this.pos != this.filter.length) {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, String.valueOf(this.pos)), this.filterstring);
        }
    }

    protected void parse_filter(FilterImpl filterImpl) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filter[this.pos] != '(') {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
        }
        ++this.pos;
        this.parse_filtercomp(filterImpl);
        this.skipWhiteSpace();
        if (this.filter[this.pos] != ')') {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, String.valueOf(this.pos)), this.filterstring);
        }
        ++this.pos;
        this.skipWhiteSpace();
    }

    protected void parse_filtercomp(FilterImpl filterImpl) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.filter[this.pos];
        switch (c) {
            case '&': {
                ++this.pos;
                this.parse_and(filterImpl);
                break;
            }
            case '|': {
                ++this.pos;
                this.parse_or(filterImpl);
                break;
            }
            case '!': {
                ++this.pos;
                this.parse_not(filterImpl);
                break;
            }
            default: {
                this.parse_item(filterImpl);
            }
        }
    }

    protected void parse_and(FilterImpl filterImpl) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filter[this.pos] != '(') {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
        }
        ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
        while (this.filter[this.pos] == '(') {
            FilterImpl filterImpl2 = new FilterImpl();
            this.parse_filter(filterImpl2);
            arrayList.add(filterImpl2);
        }
        int n = arrayList.size();
        FilterImpl[] filterImplArray = new FilterImpl[n];
        arrayList.toArray(filterImplArray);
        filterImpl.setFilter(7, null, filterImplArray);
    }

    protected void parse_or(FilterImpl filterImpl) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filter[this.pos] != '(') {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
        }
        ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
        while (this.filter[this.pos] == '(') {
            FilterImpl filterImpl2 = new FilterImpl();
            this.parse_filter(filterImpl2);
            arrayList.add(filterImpl2);
        }
        int n = arrayList.size();
        FilterImpl[] filterImplArray = new FilterImpl[n];
        arrayList.toArray(filterImplArray);
        filterImpl.setFilter(8, null, filterImplArray);
    }

    protected void parse_not(FilterImpl filterImpl) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filter[this.pos] != '(') {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
        }
        FilterImpl filterImpl2 = new FilterImpl();
        this.parse_filter(filterImpl2);
        filterImpl.setFilter(9, null, filterImpl2);
    }

    protected void parse_item(FilterImpl filterImpl) throws InvalidSyntaxException {
        String string = this.parse_attr();
        this.skipWhiteSpace();
        switch (this.filter[this.pos]) {
            case '~': {
                if (this.filter[this.pos + 1] != '=') break;
                this.pos += 2;
                filterImpl.setFilter(2, string, this.parse_value());
                return;
            }
            case '>': {
                if (this.filter[this.pos + 1] != '=') break;
                this.pos += 2;
                filterImpl.setFilter(3, string, this.parse_value());
                return;
            }
            case '<': {
                if (this.filter[this.pos + 1] != '=') break;
                this.pos += 2;
                filterImpl.setFilter(4, string, this.parse_value());
                return;
            }
            case '=': {
                if (this.filter[this.pos + 1] == '*') {
                    int n = this.pos;
                    this.pos += 2;
                    this.skipWhiteSpace();
                    if (this.filter[this.pos] == ')') {
                        filterImpl.setFilter(5, string, null);
                        return;
                    }
                    this.pos = n;
                }
                ++this.pos;
                Object object = this.parse_substring();
                if (object instanceof String) {
                    filterImpl.setFilter(1, string, object);
                } else {
                    filterImpl.setFilter(6, string, object);
                }
                return;
            }
        }
        throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, String.valueOf(this.pos)), this.filterstring);
    }

    protected String parse_attr() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        int n = this.pos;
        int n2 = this.pos;
        char c = this.filter[this.pos];
        while ("~<>=()".indexOf(c) == -1) {
            ++this.pos;
            if (!Character.isWhitespace(c)) {
                n2 = this.pos;
            }
            c = this.filter[this.pos];
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, String.valueOf(this.pos)), this.filterstring);
        }
        return new String(this.filter, n, n3);
    }

    protected Object parse_substring() throws InvalidSyntaxException {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.filter.length - this.pos);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        block6: while (true) {
            n = this.filter[this.pos];
            switch (n) {
                case 41: {
                    if (stringBuffer.length() <= 0) break block6;
                    arrayList.add(stringBuffer.toString());
                    break block6;
                }
                case 40: {
                    throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, String.valueOf(this.pos)), this.filterstring);
                }
                case 42: {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    arrayList.add(null);
                    ++this.pos;
                    continue block6;
                }
                case 92: {
                    ++this.pos;
                    n = this.filter[this.pos];
                }
                default: {
                    stringBuffer.append((char)n);
                    ++this.pos;
                    continue block6;
                }
            }
            break;
        }
        if ((n = arrayList.size()) == 0) {
            throw (Throwable)new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, String.valueOf(this.pos)), this.filterstring);
        }
        if (n == 1 && (object = arrayList.get(0)) != null) {
            return object;
        }
        object = new String[n];
        arrayList.toArray((T[])object);
        return object;
    }

    protected void skipWhiteSpace() {
        int n = this.filter.length;
        while (this.pos < n && Character.isWhitespace(this.filter[this.pos])) {
            ++this.pos;
        }
    }

    protected String parse_value() throws InvalidSyntaxException {
        return FilterImpl$Parser$$Cold.parse_value(this);
    }
}

