/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl$SetAccessibleAction;
import org.eclipse.osgi.framework.util.Headers;

public class FilterImpl$$Cold {
    public static String approxString(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (Character.isWhitespace(c)) {
                bl = true;
            } else {
                cArray[n2] = c;
                ++n2;
            }
            ++n3;
        }
        return bl ? new String(cArray, 0, n2) : string;
    }

    public static boolean compare_Boolean(FilterImpl filterImpl, int n, boolean bl, Object object) {
        boolean bl2 = new Boolean(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + bl + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
        }
        return false;
    }

    public static boolean compare_Byte(FilterImpl filterImpl, int n, byte by, Object object) {
        byte by2 = Byte.parseByte(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + by + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + by + "," + object + ")");
                }
                return by == by2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + by + "," + object + ")");
                }
                return by == by2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + by + "," + object + ")");
                }
                return by >= by2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + by + "," + object + ")");
                }
                return by <= by2;
            }
        }
        return false;
    }

    public static boolean compare_Character(FilterImpl filterImpl, int n, char c, Object object) {
        char c2 = ((String)object).trim().charAt(0);
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + c + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + c + "," + object + ")");
                }
                return c == c2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + c + "," + object + ")");
                }
                return Character.toLowerCase(c) == Character.toLowerCase(c2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + c + "," + object + ")");
                }
                return c >= c2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + c + "," + object + ")");
                }
                return c <= c2;
            }
        }
        return false;
    }

    public static boolean compare_Collection(FilterImpl filterImpl, int n, Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!filterImpl.compare(n, iterator.next(), object)) continue;
            return true;
        }
        return false;
    }

    public static boolean compare_Comparable(FilterImpl filterImpl, int n, Comparable comparable, Object object) {
        Constructor<?> constructor;
        try {
            constructor = comparable.getClass().getConstructor(FilterImpl.constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        try {
            if (!((AccessibleObject)constructor).isAccessible()) {
                AccessController.doPrivileged(new FilterImpl$SetAccessibleAction(constructor));
            }
            object = constructor.newInstance(((String)object).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + comparable + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) <= 0;
            }
        }
        return false;
    }

    public static boolean compare_Double(FilterImpl filterImpl, int n, double d, Object object) {
        double d2 = Double.parseDouble(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + d + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + d + "," + object + ")");
                }
                return d == d2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + d + "," + object + ")");
                }
                return d == d2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + d + "," + object + ")");
                }
                return d >= d2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + d + "," + object + ")");
                }
                return d <= d2;
            }
        }
        return false;
    }

    public static boolean compare_Float(FilterImpl filterImpl, int n, float f, Object object) {
        float f2 = Float.parseFloat(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + f + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + f + "," + object + ")");
                }
                return f == f2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + f + "," + object + ")");
                }
                return f == f2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + f + "," + object + ")");
                }
                return f >= f2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + f + "," + object + ")");
                }
                return f <= f2;
            }
        }
        return false;
    }

    public static boolean compare_Integer(FilterImpl filterImpl, int n, int n2, Object object) {
        int n3 = Integer.parseInt(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + n2 + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + n2 + "," + object + ")");
                }
                return n2 == n3;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + n2 + "," + object + ")");
                }
                return n2 == n3;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + n2 + "," + object + ")");
                }
                return n2 >= n3;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + n2 + "," + object + ")");
                }
                return n2 <= n3;
            }
        }
        return false;
    }

    public static boolean compare_Long(FilterImpl filterImpl, int n, long l, Object object) {
        long l2 = Long.parseLong(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + l + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + l + "," + object + ")");
                }
                return l == l2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + l + "," + object + ")");
                }
                return l == l2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + l + "," + object + ")");
                }
                return l >= l2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + l + "," + object + ")");
                }
                return l <= l2;
            }
        }
        return false;
    }

    public static boolean compare_PrimitiveArray(FilterImpl filterImpl, int n, Class clazz, Object object, Object object2) {
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            int[] nArray = (int[])object;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (filterImpl.compare_Integer(n, nArray[n3], object2)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            long[] lArray = (long[])object;
            int n4 = lArray.length;
            int n5 = 0;
            while (n5 < n4) {
                if (filterImpl.compare_Long(n, lArray[n5], object2)) {
                    return true;
                }
                ++n5;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            byte[] byArray = (byte[])object;
            int n6 = byArray.length;
            int n7 = 0;
            while (n7 < n6) {
                if (filterImpl.compare_Byte(n, byArray[n7], object2)) {
                    return true;
                }
                ++n7;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            short[] sArray = (short[])object;
            int n8 = sArray.length;
            int n9 = 0;
            while (n9 < n8) {
                if (filterImpl.compare_Short(n, sArray[n9], object2)) {
                    return true;
                }
                ++n9;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            char[] cArray = (char[])object;
            int n10 = cArray.length;
            int n11 = 0;
            while (n11 < n10) {
                if (filterImpl.compare_Character(n, cArray[n11], object2)) {
                    return true;
                }
                ++n11;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            float[] fArray = (float[])object;
            int n12 = fArray.length;
            int n13 = 0;
            while (n13 < n12) {
                if (filterImpl.compare_Float(n, fArray[n13], object2)) {
                    return true;
                }
                ++n13;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            double[] dArray = (double[])object;
            int n14 = dArray.length;
            int n15 = 0;
            while (n15 < n14) {
                if (filterImpl.compare_Double(n, dArray[n15], object2)) {
                    return true;
                }
                ++n15;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            boolean[] blArray = (boolean[])object;
            int n16 = blArray.length;
            int n17 = 0;
            while (n17 < n16) {
                if (filterImpl.compare_Boolean(n, blArray[n17], object2)) {
                    return true;
                }
                ++n17;
            }
            return false;
        }
        return false;
    }

    public static boolean compare_Short(FilterImpl filterImpl, int n, short s, Object object) {
        short s2 = Short.parseShort(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + s + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + s + "," + object + ")");
                }
                return s == s2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + s + "," + object + ")");
                }
                return s == s2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + s + "," + object + ")");
                }
                return s >= s2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + s + "," + object + ")");
                }
                return s <= s2;
            }
        }
        return false;
    }

    public static boolean compare_Unknown(FilterImpl filterImpl, int n, Object object, Object object2) {
        Constructor<?> constructor;
        try {
            constructor = object.getClass().getConstructor(FilterImpl.constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("Type not supported");
            }
            return false;
        }
        try {
            if (!((AccessibleObject)constructor).isAccessible()) {
                AccessController.doPrivileged(new FilterImpl$SetAccessibleAction(constructor));
            }
            object2 = constructor.newInstance(((String)object2).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + object + "," + object2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
        }
        return false;
    }

    public static boolean equals(FilterImpl filterImpl, Object object) {
        if (object == filterImpl) {
            return true;
        }
        if (!(object instanceof FilterImpl)) {
            return false;
        }
        return filterImpl.toString().equals(object.toString());
    }

    public static boolean match(FilterImpl filterImpl, Dictionary dictionary) {
        if (dictionary != null) {
            dictionary = new Headers(dictionary);
        }
        return filterImpl.match0(dictionary);
    }
}

