/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionSet
extends BundlePermissionCollection {
    private static final long serialVersionUID = 3258411750729920566L;
    private ConditionalPermissionInfoImpl[] cpis = ConditionalPermissionAdminImpl.EMPTY_COND_PERM_INFO;
    private HashMap cachedPermissionCollections = new HashMap();
    private boolean hasAllPermission = false;
    private AbstractBundle bundle;
    private Condition[] neededConditions;
    static Class class$0;

    public ConditionalPermissionSet(AbstractBundle abstractBundle, ConditionalPermissionInfoImpl[] conditionalPermissionInfoImplArray, Condition[] conditionArray) {
        this.bundle = abstractBundle;
        this.cpis = conditionalPermissionInfoImplArray;
        this.neededConditions = conditionArray;
        this.checkForAllPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConditionalPermissionInfo(ConditionalPermissionInfoImpl conditionalPermissionInfoImpl) {
        if (this.neededConditions == null || this.neededConditions.length > 0) {
            throw (Throwable)new RuntimeException("Cannot add ConditionalPermissionInfoImpl to a non satisfied set");
        }
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            int n = 0;
            while (n < this.cpis.length) {
                if (this.cpis[n] == null) {
                    this.cpis[n] = conditionalPermissionInfoImpl;
                    this.cachedPermissionCollections.clear();
                    return;
                }
                ++n;
            }
            ConditionalPermissionInfoImpl[] conditionalPermissionInfoImplArray = new ConditionalPermissionInfoImpl[this.cpis.length + 1];
            System.arraycopy(this.cpis, 0, conditionalPermissionInfoImplArray, 0, this.cpis.length);
            conditionalPermissionInfoImplArray[this.cpis.length] = conditionalPermissionInfoImpl;
            this.cpis = conditionalPermissionInfoImplArray;
            this.cachedPermissionCollections.clear();
            this.checkForAllPermission();
        }
    }

    private void checkForAllPermission() {
        if (this.hasAllPermission) {
            return;
        }
        int n = 0;
        block2: while (n < this.cpis.length) {
            if (this.cpis[n] != null) {
                PermissionInfo[] permissionInfoArray = this.cpis[n].perms;
                int n2 = 0;
                while (n2 < permissionInfoArray.length) {
                    String string = permissionInfoArray[n2].getType();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.security.AllPermission");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                        }
                    }
                    if (string.equals(clazz.getName())) {
                        this.hasAllPermission = true;
                        break block2;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNonEmpty() {
        boolean bl = false;
        boolean bl2 = false;
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            int n = 0;
            while (n < this.cpis.length) {
                if (this.cpis[n] != null) {
                    if (this.cpis[n].isDeleted()) {
                        this.cpis[n] = null;
                        bl2 = true;
                        this.cachedPermissionCollections.clear();
                    } else {
                        bl = true;
                    }
                }
                ++n;
            }
            if (!bl) {
                this.cpis = ConditionalPermissionAdminImpl.EMPTY_COND_PERM_INFO;
            }
            if (bl2) {
                this.hasAllPermission = false;
                this.checkForAllPermission();
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    Condition[] getNeededConditions() {
        if (this.neededConditions == null || this.neededConditions.length == 0) {
            return this.neededConditions;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.neededConditions.length) {
            block7: {
                Condition condition = this.neededConditions[n];
                if (condition != null) {
                    if (!condition.isMutable()) {
                        if (condition.isSatisfied()) {
                            this.neededConditions[n] = null;
                            break block7;
                        } else {
                            this.neededConditions = null;
                            break;
                        }
                    }
                    bl = true;
                }
            }
            ++n;
        }
        if (this.neededConditions != null && !bl) {
            this.neededConditions = ConditionalPermissionAdminImpl.EMPTY_COND;
        }
        return this.neededConditions;
    }

    public void add(Permission permission) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        PermissionCollection permissionCollection;
        if (this.hasAllPermission) {
            return true;
        }
        Class<?> clazz = permission.getClass();
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            permissionCollection = (PermissionCollection)this.cachedPermissionCollections.get(clazz);
            if (permissionCollection == null) {
                permissionCollection = permission.newPermissionCollection();
                if (permissionCollection == null) {
                    permissionCollection = new PermissionsHash();
                }
                int n = 0;
                while (n < this.cpis.length) {
                    try {
                        ConditionalPermissionInfoImpl conditionalPermissionInfoImpl = this.cpis[n];
                        if (conditionalPermissionInfoImpl != null) {
                            conditionalPermissionInfoImpl.addPermissions(this.bundle, permissionCollection, clazz);
                        }
                    }
                    catch (Exception exception) {
                        ((Throwable)exception).printStackTrace();
                    }
                    ++n;
                }
                this.cachedPermissionCollections.put(clazz, permissionCollection);
            }
        }
        return permissionCollection.implies(permission);
    }

    public Enumeration elements() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unresolvePermissions() {
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            this.cachedPermissionCollections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean remove(ConditionalPermissionInfoImpl conditionalPermissionInfoImpl) {
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            int n = 0;
            while (true) {
                if (n >= this.cpis.length) {
                    return false;
                }
                if (this.cpis[n] == conditionalPermissionInfoImpl) {
                    this.cpis[n] = null;
                    this.cachedPermissionCollections.clear();
                    return true;
                }
                ++n;
            }
        }
    }
}

