/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleResourceHandler$$Cold;
import org.eclipse.osgi.framework.internal.core.BundleURLConnection;
import org.eclipse.osgi.framework.internal.protocol.ProtocolActivator;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundleResourceHandler
extends URLStreamHandler
implements ProtocolActivator {
    public static final String SECURITY_CHECKED = "SECURITY_CHECKED";
    public static final String SECURITY_UNCHECKED = "SECURITY_UNCHECKED";
    private BaseAdaptor adaptor;
    protected BundleEntry bundleEntry;

    public BundleResourceHandler() {
        this(null, null);
    }

    public BundleResourceHandler(BundleEntry bundleEntry, BaseAdaptor baseAdaptor) {
        this.bundleEntry = bundleEntry;
        this.adaptor = baseAdaptor;
    }

    public void start(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        this.adaptor = (BaseAdaptor)frameworkAdaptor;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        long l;
        if (this.bundleEntry != null) {
            return new BundleURLConnection(uRL, this.bundleEntry);
        }
        String string = uRL.getHost();
        if (string == null) {
            throw (Throwable)new IOException(NLS.bind(AdaptorMsg.URL_NO_BUNDLE_ID, uRL.toExternalForm()));
        }
        AbstractBundle abstractBundle = null;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw (Throwable)new MalformedURLException(NLS.bind(AdaptorMsg.URL_INVALID_BUNDLE_ID, string));
        }
        AbstractBundle abstractBundle2 = abstractBundle = this.adaptor == null ? null : (AbstractBundle)this.adaptor.getContext().getBundle(l);
        if (abstractBundle == null) {
            throw (Throwable)new IOException(NLS.bind(AdaptorMsg.URL_NO_BUNDLE_FOUND, uRL.toExternalForm()));
        }
        if (!uRL.getAuthority().equals(SECURITY_CHECKED)) {
            this.checkAuthorization(abstractBundle);
        }
        return new BundleURLConnection(uRL, this.findBundleEntry(uRL, abstractBundle));
    }

    protected abstract BundleEntry findBundleEntry(URL var1, AbstractBundle var2) throws IOException;

    protected boolean equals(URL uRL, URL uRL2) {
        return this.sameFile(uRL, uRL2);
    }

    protected synchronized InetAddress getHostAddress(URL uRL) {
        return null;
    }

    protected void parseURL(URL uRL, String string, int n, int n2) {
        Bundle bundle;
        int n3;
        if (n2 < n) {
            return;
        }
        if (uRL.getPath() != null) {
            this.bundleEntry = null;
        }
        String string2 = "";
        if (n < n2) {
            string2 = string.substring(n, n2);
        }
        n2 -= n;
        String string3 = uRL.getPath();
        String string4 = uRL.getHost();
        int n4 = 0;
        int n5 = 0;
        if (string2.startsWith("//")) {
            int n6;
            n3 = 2;
            n5 = string2.indexOf(47, n3);
            if (n5 == -1) {
                n5 = n2;
                string3 = "";
            }
            if ((n6 = string2.indexOf(58, n3)) > n5 || n6 == -1) {
                n6 = n5;
            }
            if (n6 < n5 - 1) {
                try {
                    n4 = Integer.parseInt(string2.substring(n6 + 1, n5));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            string4 = string2.substring(n3, n6);
        }
        if (n5 < n2 && string2.charAt(n5) == '/') {
            string3 = string2.substring(n5, n2);
        } else if (n2 > n5) {
            if (string3 == null || string3.equals("")) {
                string3 = "/";
            }
            string3 = (n3 = string3.lastIndexOf(47) + 1) == 0 ? string2.substring(n5, n2) : String.valueOf(string3.substring(0, n3)) + string2.substring(n5, n2);
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string3.endsWith("/.") || string3.endsWith("/..")) {
            string3 = String.valueOf(string3) + '/';
        }
        while ((n3 = string3.indexOf("/./")) >= 0) {
            string3 = String.valueOf(string3.substring(0, n3 + 1)) + string3.substring(n3 + 3);
        }
        while ((n3 = string3.indexOf("/../")) >= 0) {
            string3 = n3 != 0 ? String.valueOf(string3.substring(0, string3.lastIndexOf(47, n3 - 1))) + string3.substring(n3 + 3) : string3.substring(n3 + 3);
        }
        while ((n3 = string3.indexOf("//")) >= 0) {
            string3 = String.valueOf(string3.substring(0, n3 + 1)) + string3.substring(n3 + 2);
        }
        String string5 = SECURITY_UNCHECKED;
        Bundle bundle2 = bundle = this.adaptor == null ? null : this.adaptor.getContext().getBundle(Long.parseLong(string4));
        if (this.checkAuthorization(bundle)) {
            string5 = SECURITY_CHECKED;
        }
        this.setURL(uRL, uRL.getProtocol(), string4, n4, string5, null, string3, null, uRL.getRef());
    }

    protected String toExternalForm(URL uRL) throws  {
        return BundleResourceHandler$$Cold.toExternalForm(this, uRL);
    }

    protected int hashCode(URL uRL) {
        String string;
        int n = 0;
        String string2 = uRL.getProtocol();
        if (string2 != null) {
            n += string2.hashCode();
        }
        if ((string = uRL.getHost()) != null) {
            n += string.hashCode();
        }
        n += uRL.getPort();
        String string3 = uRL.getPath();
        if (string3 != null) {
            n += string3.hashCode();
        }
        if (this.adaptor != null) {
            n += this.adaptor.hashCode();
        }
        return n;
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) throws  {
        return BundleResourceHandler$$Cold.hostsEqual(this, uRL, uRL2);
    }

    protected boolean sameFile(URL uRL, URL uRL2) throws  {
        return BundleResourceHandler$$Cold.sameFile(this, uRL, uRL2);
    }

    protected boolean checkAuthorization(Bundle bundle) throws  {
        return BundleResourceHandler$$Cold.checkAuthorization(this, bundle);
    }

    protected static BaseClassLoader getBundleClassLoader(AbstractBundle abstractBundle) throws  {
        return BundleResourceHandler$$Cold.getBundleClassLoader(abstractBundle);
    }
}

