/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.event.BatchBundleListener;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl$$Cold;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl$1;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl$2;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl$3;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FilteredServiceListener;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    public static final String PROP_SCOPE_SERVICE_EVENTS = "osgi.scopeServiceEvents";
    public static final boolean scopeEvents = Boolean.valueOf(FrameworkProperties.getProperty("osgi.scopeServiceEvents", "true"));
    private volatile boolean valid;
    final BundleHost bundle;
    final Framework framework;
    private HashMap servicesInUse;
    protected EventListeners bundleEvent;
    protected EventListeners bundleEventSync;
    protected EventListeners serviceEvent;
    protected EventListeners frameworkEvent;
    protected BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContextImpl(BundleHost bundleHost) {
        this.bundle = bundleHost;
        this.valid = true;
        this.framework = ((AbstractBundle)bundleHost).framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.serviceEvent = null;
        this.frameworkEvent = null;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceReference[] serviceReferenceArray = this.framework.serviceEvent;
        synchronized (this.framework.serviceEvent) {
            int n;
            if (this.serviceEvent != null) {
                this.framework.serviceEvent.removeListener(this);
                this.serviceEvent = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            serviceReferenceArray = this.framework.frameworkEvent;
            synchronized (serviceReferenceArray) {
                if (this.frameworkEvent != null) {
                    this.framework.frameworkEvent.removeListener(this);
                    this.frameworkEvent = null;
                }
            }
            serviceReferenceArray = this.framework.bundleEvent;
            synchronized (serviceReferenceArray) {
                if (this.bundleEvent != null) {
                    this.framework.bundleEvent.removeListener(this);
                    this.bundleEvent = null;
                }
            }
            serviceReferenceArray = this.framework.bundleEventSync;
            synchronized (serviceReferenceArray) {
                if (this.bundleEventSync != null) {
                    this.framework.bundleEventSync.removeListener(this);
                    this.bundleEventSync = null;
                }
            }
            serviceReferenceArray = null;
            ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
            synchronized (serviceRegistry) {
                serviceReferenceArray = this.framework.serviceRegistry.lookupServiceReferences(this);
            }
            if (serviceReferenceArray != null) {
                int n2 = 0;
                while (n2 < serviceReferenceArray.length) {
                    try {
                        ((ServiceReferenceImpl)serviceReferenceArray[n2]).registration.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    ++n2;
                }
            }
            ServiceRegistrationImpl[] serviceRegistrationImplArray = null;
            Object object = this.contextLock;
            synchronized (object) {
                if (this.servicesInUse == null) {
                    return;
                }
                HashMap hashMap = this.servicesInUse;
                synchronized (hashMap) {
                    n = this.servicesInUse.size();
                    if (n > 0) {
                        if (Debug.DEBUG_SERVICES) {
                            Debug.println("Releasing services");
                        }
                        serviceRegistrationImplArray = new ServiceRegistrationImpl[n];
                        Iterator iterator = this.servicesInUse.keySet().iterator();
                        int n3 = 0;
                        while (n3 < n) {
                            serviceRegistrationImplArray[n3] = (ServiceRegistrationImpl)iterator.next();
                            ++n3;
                        }
                    }
                }
            }
            int n4 = 0;
            while (n4 < n) {
                serviceRegistrationImplArray[n4].releaseService(this);
                ++n4;
            }
            Object object2 = this.contextLock;
            synchronized (object2) {
                this.servicesInUse = null;
            }
            return;
        }
    }

    public String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return this.framework.getProperty(string);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    public Bundle installBundle(String string, InputStream inputStream) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(string, inputStream);
    }

    public Bundle getBundle(long l) {
        return this.framework.getBundle(l);
    }

    public AbstractBundle getBundleByLocation(String string) {
        return this.framework.getBundleByLocation(string);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(serviceListener));
            Debug.println("addServiceListener[" + this.bundle + "](" + (String)object + ", \"" + string + "\")");
        }
        object = new FilteredServiceListener(string, serviceListener, this);
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            this.checkValid();
            if (this.serviceEvent == null) {
                this.serviceEvent = new EventListeners();
                this.framework.serviceEvent.addListener(this, this);
            }
            this.serviceEvent.addListener(serviceListener, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener serviceListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(serviceListener));
            Debug.println("removeServiceListener[" + this.bundle + "](" + (String)object + ")");
        }
        object = this.framework.serviceEvent;
        synchronized (object) {
            if (this.serviceEvent != null) {
                this.serviceEvent.removeListener(serviceListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener bundleListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(bundleListener));
            Debug.println("addBundleListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (bundleListener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            object = this.framework.bundleEventSync;
            synchronized (object) {
                this.checkValid();
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new EventListeners();
                    this.framework.bundleEventSync.addListener(this, this);
                }
                this.bundleEventSync.addListener(bundleListener, bundleListener);
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            this.checkValid();
            if (this.bundleEvent == null) {
                this.bundleEvent = new EventListeners();
                this.framework.bundleEvent.addListener(this, this);
            }
            this.bundleEvent.addListener(bundleListener, bundleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener bundleListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(bundleListener));
            Debug.println("removeBundleListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (bundleListener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            object = this.framework.bundleEventSync;
            synchronized (object) {
                if (this.bundleEventSync != null) {
                    this.bundleEventSync.removeListener(bundleListener);
                }
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            if (this.bundleEvent != null) {
                this.bundleEvent.removeListener(bundleListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener frameworkListener) {
        Object object;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(frameworkListener));
            Debug.println("addFrameworkListener[" + this.bundle + "](" + (String)object + ")");
        }
        object = this.framework.frameworkEvent;
        synchronized (object) {
            this.checkValid();
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new EventListeners();
                this.framework.frameworkEvent.addListener(this, this);
            }
            this.frameworkEvent.addListener(frameworkListener, frameworkListener);
        }
    }

    public ServiceRegistration registerService(String[] stringArray, Object object, Dictionary dictionary) {
        String string;
        this.checkValid();
        if (object == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw (Throwable)new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int n = stringArray.length;
        if (n == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw (Throwable)new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = stringArray.length - 1;
        while (n2 >= 0) {
            stringArray2[n2] = stringArray[n2].intern();
            --n2;
        }
        stringArray = stringArray2;
        this.framework.checkRegisterServicePermission(stringArray);
        if (!(object instanceof ServiceFactory) && (string = BundleContextImpl.checkServiceClass(stringArray, object)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + string);
            }
            throw (Throwable)new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, string));
        }
        return this.createServiceRegistration(stringArray, object, dictionary);
    }

    static String checkServiceClass(String[] stringArray, Object object) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new BundleContextImpl$1(object));
        int n = 0;
        while (n < stringArray.length) {
            block4: {
                try {
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = classLoader == null ? Class.forName(stringArray[n]) : classLoader.loadClass(stringArray[n]);
                    if (!clazz.isInstance(object)) {
                        return stringArray[n];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!BundleContextImpl.extensiveCheckServiceClass(stringArray[n], object.getClass())) break block4;
                    return stringArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    protected ServiceRegistrationImpl createServiceRegistration(String[] stringArray, Object object, Dictionary dictionary) {
        ServiceRegistrationImpl serviceRegistrationImpl = new ServiceRegistrationImpl(this, stringArray, object);
        serviceRegistrationImpl.register(dictionary);
        return serviceRegistrationImpl;
    }

    public ServiceRegistration registerService(String string, Object object, Dictionary dictionary) {
        String[] stringArray = new String[]{string};
        return this.registerService(stringArray, object, dictionary);
    }

    public ServiceReference[] getServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getServiceReferences(" + string + ", \"" + string2 + "\")");
        }
        return this.framework.getServiceReferences(string, string2, this, false);
    }

    public ServiceReference[] getAllServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getAllServiceReferences(" + string + ", \"" + string2 + "\")");
        }
        return this.framework.getServiceReferences(string, string2, this, true);
    }

    public ServiceReference getServiceReference(String string) {
        block12: {
            this.checkValid();
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + string + ")");
            }
            try {
                ServiceReference[] serviceReferenceArray = this.framework.getServiceReferences(string, null, this, false);
                if (serviceReferenceArray != null) {
                    int n = 0;
                    int n2 = serviceReferenceArray.length;
                    if (n2 > 1) {
                        int[] nArray = new int[n2];
                        int n3 = 0;
                        int n4 = Integer.MIN_VALUE;
                        int n5 = 0;
                        while (n5 < n2) {
                            int n6;
                            nArray[n5] = n6 = ((ServiceReferenceImpl)serviceReferenceArray[n5]).getRanking();
                            if (n6 > n4) {
                                n = n5;
                                n4 = n6;
                                n3 = 1;
                            } else if (n6 == n4) {
                                ++n3;
                            }
                            ++n5;
                        }
                        if (n3 > 1) {
                            long l = Long.MAX_VALUE;
                            int n7 = 0;
                            while (n7 < n2) {
                                long l2;
                                if (nArray[n7] == n4 && (l2 = ((ServiceReferenceImpl)serviceReferenceArray[n7]).getId()) < l) {
                                    n = n7;
                                    l = l2;
                                }
                                ++n7;
                            }
                        }
                    }
                    return serviceReferenceArray[n];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block12;
                Debug.println("InvalidSyntaxException w/ null filter" + ((Throwable)invalidSyntaxException).getMessage());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference serviceReference) {
        this.checkValid();
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
        object = ((ServiceReferenceImpl)serviceReference).registration;
        this.framework.checkGetServicePermission(((ServiceRegistrationImpl)object).clazzes);
        return ((ServiceRegistrationImpl)object).getService(this);
    }

    public boolean ungetService(ServiceReference serviceReference) {
        this.checkValid();
        ServiceRegistrationImpl serviceRegistrationImpl = ((ServiceReferenceImpl)serviceReference).registration;
        return serviceRegistrationImpl.ungetService(this);
    }

    protected void start() throws BundleException {
        this.activator = ((AbstractBundle)this.bundle).loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException bundleException) {
                this.activator = null;
                throw (Throwable)bundleException;
            }
        }
    }

    protected void startActivator(BundleActivator bundleActivator) throws BundleException {
        if (Profile.STARTUP) {
            Profile.logEnter("BundleContextImpl.startActivator()", null);
        }
        try {
            try {
                AccessController.doPrivileged(new BundleContextImpl$2(this, bundleActivator));
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(exception);
                }
                String string = null;
                string = bundleActivator.getClass().getName();
                throw (Throwable)new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{string, "start", ((AbstractBundle)this.bundle).getSymbolicName() == null ? "" + ((AbstractBundle)this.bundle).getBundleId() : ((AbstractBundle)this.bundle).getSymbolicName()}), exception);
            }
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("BundleContextImpl.startActivator()");
            }
        }
    }

    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new BundleContextImpl$3(this));
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(exception);
                }
                String string = this.activator == null ? "" : this.activator.getClass().getName();
                throw (Throwable)new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{string, "stop", ((AbstractBundle)this.bundle).getSymbolicName() == null ? "" + ((AbstractBundle)this.bundle).getBundleId() : ((AbstractBundle)this.bundle).getSymbolicName()}), exception);
            }
        }
        finally {
            this.activator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        block17: {
            BundleHost bundleHost = this.bundle;
            try {
                if (!this.isValid()) break block17;
                switch (n) {
                    case 1: 
                    case 2: {
                        Object object4;
                        BundleListener bundleListener = (BundleListener)object2;
                        if (Debug.DEBUG_EVENTS) {
                            object4 = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(bundleListener));
                            Debug.println("dispatchBundleEvent[" + bundleHost + "](" + (String)object4 + ")");
                        }
                        object4 = (BundleEvent)object3;
                        switch (((BundleEvent)object4).getType()) {
                            case -2147483647: {
                                if (bundleListener instanceof BatchBundleListener) {
                                    ((BatchBundleListener)bundleListener).batchBegin();
                                    break;
                                }
                                break block17;
                            }
                            case -2147483648: {
                                if (bundleListener instanceof BatchBundleListener) {
                                    ((BatchBundleListener)bundleListener).batchEnd();
                                    break;
                                }
                                break block17;
                            }
                            default: {
                                bundleListener.bundleChanged((BundleEvent)object3);
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        ServiceEvent serviceEvent = (ServiceEvent)object3;
                        ServiceListener serviceListener = (ServiceListener)object2;
                        if (Debug.DEBUG_EVENTS) {
                            String string = String.valueOf(serviceListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(serviceListener));
                            Debug.println("dispatchServiceEvent[" + bundleHost + "](" + string + ")");
                        }
                        serviceListener.serviceChanged(serviceEvent);
                        break;
                    }
                    case 4: {
                        FrameworkListener frameworkListener = (FrameworkListener)object2;
                        if (Debug.DEBUG_EVENTS) {
                            String string = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(frameworkListener));
                            Debug.println("dispatchFrameworkEvent[" + bundleHost + "](" + string + ")");
                        }
                        frameworkListener.frameworkEvent((FrameworkEvent)object3);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                FrameworkEvent frameworkEvent;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in bottom level event dispatcher: " + throwable.getMessage());
                    Debug.printStackTrace(throwable);
                }
                this.framework.adaptor.handleRuntimeError(throwable);
                if (n == 4 && (frameworkEvent = (FrameworkEvent)object3).getType() == 2) break block17;
                this.framework.publishFrameworkEvent(2, bundleHost, throwable);
            }
        }
    }

    protected boolean hasListenServicePermission(ServiceEvent serviceEvent) {
        BundleProtectionDomain bundleProtectionDomain = ((AbstractBundle)this.bundle).getProtectionDomain();
        if (bundleProtectionDomain != null) {
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)serviceEvent.getServiceReference();
            String[] stringArray = serviceReferenceImpl.getClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (((ProtectionDomain)bundleProtectionDomain).implies(new ServicePermission(stringArray[n2], "get"))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public Filter createFilter(String string) throws InvalidSyntaxException {
        this.checkValid();
        return new FilterImpl(string);
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw (Throwable)new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    boolean isAssignableTo(ServiceReferenceImpl serviceReferenceImpl) {
        if (!scopeEvents) {
            return true;
        }
        String[] stringArray = serviceReferenceImpl.getClasses();
        int n = 0;
        while (n < stringArray.length) {
            if (!serviceReferenceImpl.isAssignableTo(this.bundle, stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Bundle installBundle(String string) throws BundleException {
        return BundleContextImpl$$Cold.installBundle(this, string);
    }

    public void addServiceListener(ServiceListener serviceListener) throws  {
        BundleContextImpl$$Cold.addServiceListener(this, serviceListener);
    }

    public void removeFrameworkListener(FrameworkListener frameworkListener) throws  {
        BundleContextImpl$$Cold.removeFrameworkListener(this, frameworkListener);
    }

    private static boolean extensiveCheckServiceClass(String string, Class clazz) {
        if (string.equals(clazz.getName())) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (!BundleContextImpl.extensiveCheckServiceClass(string, classArray[n])) {
                return false;
            }
            ++n;
        }
        Class clazz2 = clazz.getSuperclass();
        return clazz2 == null || BundleContextImpl.extensiveCheckServiceClass(string, clazz2);
    }

    public File getDataFile(String string) throws  {
        return BundleContextImpl$$Cold.getDataFile(this, string);
    }

    protected ServiceReference[] getRegisteredServices() throws  {
        return BundleContextImpl$$Cold.getRegisteredServices(this);
    }

    /*
     * Exception decompiling
     */
    protected ServiceReferenceImpl[] getServicesInUse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

