/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;

public class DirZipBundleEntry
extends BundleEntry {
    private ZipBundleFile bundleFile;
    String name;

    public DirZipBundleEntry(ZipBundleFile zipBundleFile, String string) {
        this.name = string.length() > 0 && string.charAt(0) == '/' ? string.substring(1) : string;
        this.bundleFile = zipBundleFile;
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public long getSize() {
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return 0L;
    }

    public URL getLocalURL() {
        try {
            return new URL("jar:file:" + ((BundleFile)this.bundleFile).basefile.getAbsolutePath() + "!/" + this.name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getFileURL() {
        try {
            return this.bundleFile.extractDirectory(this.name).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

