/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceBundleStats {
    private String pluginId;
    private String fileName;
    private int keyCount = 0;
    private int keySize = 0;
    private int valueSize = 0;
    private long hashSize = 0L;
    private long fileSize = 0L;

    private static int sizeOf(String string) {
        return 44 + 2 * string.length();
    }

    private static int sizeOf(Properties properties) {
        return (int)Math.round(44.0 + (16.0 + (double)((Hashtable)properties).size() * 1.25 * 4.0) + (double)(24 * ((Hashtable)properties).size()));
    }

    public ResourceBundleStats(String string, String string2, URL uRL) {
        this.pluginId = string;
        this.fileName = string2;
        this.initialize(uRL);
    }

    public ResourceBundleStats(String string, String string2, ResourceBundle resourceBundle) {
        this.pluginId = string;
        this.fileName = string2;
        this.initialize(resourceBundle);
    }

    private void initialize(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.keySize += ResourceBundleStats.sizeOf(string);
            this.valueSize += ResourceBundleStats.sizeOf(resourceBundle.getString(string));
            ++this.keyCount;
        }
    }

    private void initialize(URL uRL) {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            try {
                inputStream = uRL.openStream();
                this.fileSize = inputStream.available();
                properties.load(inputStream);
                Iterator iterator = ((Hashtable)properties).keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.keySize += ResourceBundleStats.sizeOf(string);
                    this.valueSize += ResourceBundleStats.sizeOf(properties.getProperty(string));
                    ++this.keyCount;
                }
                this.hashSize = ResourceBundleStats.sizeOf(properties);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    public long getHashSize() {
        return this.hashSize;
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public long getTotalSize() {
        return (long)(this.keySize + this.valueSize) + this.hashSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

