/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.internal.stats.ClassStats;
import org.eclipse.core.runtime.internal.stats.ClassloaderStats$1;
import org.eclipse.core.runtime.internal.stats.ResourceBundleStats;
import org.eclipse.core.runtime.internal.stats.StatsManager;

public class ClassloaderStats {
    private String id;
    private long loadingTime;
    private int failureCount = 0;
    private Map classes = Collections.synchronizedMap(new HashMap(20));
    private ArrayList bundles = new ArrayList(2);
    private boolean keepTraces = false;
    private static ArrayList packageFilters = new ArrayList(4);
    private static Set pluginFilters = new HashSet(5);
    private static Hashtable classStacks = new Hashtable();
    private static Map loaders = Collections.synchronizedMap(new HashMap(20));
    public static File traceFile;

    static {
        if (StatsManager.TRACE_CLASSES || StatsManager.TRACE_BUNDLES) {
            ClassloaderStats.initializeTraceOptions();
        }
    }

    private static void initializeTraceOptions() {
        String string = StatsManager.TRACE_FILENAME;
        traceFile = new File(string);
        traceFile.delete();
        if (!StatsManager.TRACE_CLASSES) {
            return;
        }
        string = StatsManager.TRACE_FILTERS;
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            File file = new File(string);
            System.out.print("Runtime tracing elements defined in: " + file.getAbsolutePath() + "...");
            FileInputStream fileInputStream = new FileInputStream(file);
            System.out.println("  Loaded.");
            ClassloaderStats$1 classloaderStats$1 = new ClassloaderStats$1();
            try {
                ((Properties)classloaderStats$1).load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            System.out.println("  No trace filters loaded.");
        }
    }

    protected static void addFilters(String string, String string2) {
        String[] stringArray = StatsManager.getArrayFromList(string2);
        if ("plugins".equals(string)) {
            pluginFilters.addAll((Collection)Arrays.asList(stringArray));
        }
        if ("packages".equals(string)) {
            packageFilters.addAll((Collection)Arrays.asList(stringArray));
        }
    }

    public static void startLoadingClass(String string, String string2) {
        ClassloaderStats.findLoader(string).startLoadClass(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassloaderStats findLoader(String string) {
        Map map = loaders;
        synchronized (map) {
            ClassloaderStats classloaderStats = (ClassloaderStats)loaders.get(string);
            if (classloaderStats == null) {
                classloaderStats = new ClassloaderStats(string);
                loaders.put(string, classloaderStats);
            }
            return classloaderStats;
        }
    }

    public static synchronized Stack getClassStack() {
        Stack stack = (Stack)classStacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new Stack();
            classStacks.put(Thread.currentThread(), stack);
        }
        return stack;
    }

    public static ClassloaderStats[] getLoaders() {
        return loaders.values().toArray(new ClassloaderStats[0]);
    }

    public static void endLoadingClass(String string, String string2, boolean bl) {
        ClassloaderStats.findLoader(string).endLoadClass(string2, bl);
    }

    public static void loadedBundle(String string, ResourceBundleStats resourceBundleStats) {
        ClassloaderStats.findLoader(string).loadedBundle(resourceBundleStats);
    }

    public static ClassloaderStats getLoader(String string) {
        return (ClassloaderStats)loaders.get(string);
    }

    public ClassloaderStats(String string) {
        this.id = string;
        this.keepTraces = pluginFilters.contains(string);
    }

    public void addBaseClasses(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (this.classes.get(string) == null) {
                ClassStats classStats = new ClassStats(string, this);
                classStats.toBaseClass();
                this.classes.put(string, classStats);
            }
            ++n;
        }
    }

    private void loadedBundle(ResourceBundleStats resourceBundleStats) {
        this.bundles.add(resourceBundleStats);
    }

    public ArrayList getBundles() {
        return this.bundles;
    }

    private synchronized void startLoadClass(String string) {
        ClassloaderStats.getClassStack().push(this.findClass(string));
    }

    private ClassStats findClass(String string) {
        ClassStats classStats = (ClassStats)this.classes.get(string);
        return classStats == null ? new ClassStats(string, this) : classStats;
    }

    private synchronized void endLoadClass(String string, boolean bl) {
        ClassStats classStats = (ClassStats)ClassloaderStats.getClassStack().pop();
        if (!bl) {
            ++this.failureCount;
            return;
        }
        if (classStats.getLoadOrder() >= 0) {
            return;
        }
        this.classes.put(string, classStats);
        classStats.setLoadOrder(this.classes.size());
        classStats.loadingDone();
        this.traceLoad(string, classStats);
        Stack stack = ClassloaderStats.getClassStack();
        if (((Vector)stack).size() != 0) {
            ClassStats classStats2 = (ClassStats)stack.peek();
            classStats2.addTimeLoadingOthers(classStats.getTimeLoading());
            classStats.setLoadedBy(classStats2);
            classStats2.loaded(classStats);
        } else {
            this.loadingTime += classStats.getTimeLoading();
        }
    }

    private void traceLoad(String string, ClassStats classStats) {
        if (!this.keepTraces) {
            boolean bl = false;
            int n = 0;
            while (!bl && n < packageFilters.size()) {
                if (string.startsWith((String)packageFilters.get(n))) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
        }
        try {
            classStats.setTraceStart(traceFile.length());
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(traceFile.getAbsolutePath(), true));
            try {
                printWriter.println("Loading class: " + string);
                printWriter.println("Class loading stack:");
                printWriter.println("\t" + string);
                Stack stack = ClassloaderStats.getClassStack();
                int n = ((Vector)stack).size() - 1;
                while (n >= 0) {
                    printWriter.println("\t" + ((ClassStats)((Vector)stack).get(n)).getClassName());
                    --n;
                }
                printWriter.println("Stack trace:");
                new Throwable().printStackTrace(printWriter);
            }
            finally {
                printWriter.close();
            }
            classStats.setTraceEnd(traceFile.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            ((Throwable)fileNotFoundException).printStackTrace();
        }
    }

    public int getClassLoadCount() {
        return this.classes.size();
    }

    public long getClassLoadTime() {
        return this.loadingTime;
    }

    public ClassStats[] getClasses() {
        return this.classes.values().toArray(new ClassStats[0]);
    }

    public String getId() {
        return this.id;
    }
}

