/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.util.ArrayList;
import org.eclipse.core.runtime.internal.stats.ClassloaderStats;
import org.eclipse.core.runtime.internal.stats.StatsManager;

public class BundleStats {
    public String symbolicName;
    public long id;
    public int activationOrder;
    private long timestamp;
    private boolean duringStartup;
    private long startupTime;
    private long startupMethodTime;
    private long traceStart = -1L;
    private long traceEnd = -1L;
    private ArrayList bundlesActivated = new ArrayList(3);
    private BundleStats activatedBy = null;

    public BundleStats(String string, long l) {
        this.symbolicName = string;
        this.id = l;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getActivationOrder() {
        return this.activationOrder;
    }

    protected void activated(BundleStats bundleStats) {
        this.bundlesActivated.add(bundleStats);
    }

    public BundleStats getActivatedBy() {
        return this.activatedBy;
    }

    public long getId() {
        return this.id;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public long getStartupMethodTime() {
        return this.startupMethodTime;
    }

    public boolean isStartupBundle() {
        return this.duringStartup;
    }

    public int getClassLoadCount() {
        if (!StatsManager.MONITOR_CLASSES) {
            return 0;
        }
        ClassloaderStats classloaderStats = ClassloaderStats.getLoader(this.symbolicName);
        return classloaderStats == null ? 0 : classloaderStats.getClassLoadCount();
    }

    public long getClassLoadTime() {
        if (!StatsManager.MONITOR_CLASSES) {
            return 0L;
        }
        ClassloaderStats classloaderStats = ClassloaderStats.getLoader(this.symbolicName);
        return classloaderStats == null ? 0L : classloaderStats.getClassLoadTime();
    }

    public ArrayList getBundlesActivated() {
        return this.bundlesActivated;
    }

    public long getTraceStart() {
        return this.traceStart;
    }

    public long getTraceEnd() {
        return this.traceEnd;
    }

    protected void setTimestamp(long l) {
        this.timestamp = l;
    }

    protected void setActivationOrder(int n) {
        this.activationOrder = n;
    }

    protected void setTraceStart(long l) {
        this.traceStart = l;
    }

    protected void setDuringStartup(boolean bl) {
        this.duringStartup = bl;
    }

    protected void endActivation() {
        this.startupTime = System.currentTimeMillis() - this.timestamp;
    }

    protected void setTraceEnd(long l) {
        this.traceEnd = l;
    }

    protected void setActivatedBy(BundleStats bundleStats) {
        this.activatedBy = bundleStats;
    }
}

