/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseCommandProvider$$Cold;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private static final String POLICY_CONSOLE = "org.eclipse.osgi.framework.console";
    private PlatformAdmin platformAdmin;
    private BundleContext context;
    static Class class$0;

    public EclipseCommandProvider(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public String getHelp() throws  {
        return EclipseCommandProvider$$Cold.getHelp(this);
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String string) throws  {
        return EclipseCommandProvider$$Cold.getBundleDescriptionFromToken(this, state, string);
    }

    private PlatformAdmin getPlatformAdmin(CommandInterpreter commandInterpreter) {
        if (this.platformAdmin == null) {
            ServiceReference serviceReference;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
                commandInterpreter.print("  ");
                commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
                return null;
            }
            this.platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
        }
        return this.platformAdmin;
    }

    private void ungetPlatformAdmin() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        ServiceReference serviceReference = this.context.getServiceReference(clazz.getName());
        this.context.ungetService(serviceReference);
    }

    public void _diag(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                commandInterpreter.println(String.valueOf(bundleDescription.getLocation()) + " [" + bundleDescription.getBundleId() + "]");
                VersionConstraint[] versionConstraintArray = this.platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundleDescription);
                ResolverError[] resolverErrorArray = this.platformAdmin.getState(false).getResolverErrors(bundleDescription);
                int n = 0;
                while (n < resolverErrorArray.length) {
                    if ((resolverErrorArray[n].getType() & 0x8007) == 0) {
                        commandInterpreter.print("  ");
                        commandInterpreter.println(resolverErrorArray[n].toString());
                    }
                    ++n;
                }
                if (versionConstraintArray.length == 0 && resolverErrorArray.length == 0) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                }
                if (versionConstraintArray.length > 0) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DIRECT_CONSTRAINTS);
                }
                n = 0;
                while (n < versionConstraintArray.length) {
                    commandInterpreter.print("    ");
                    commandInterpreter.println(MessageHelper.getResolutionFailureMessage(versionConstraintArray[n]));
                    ++n;
                }
                VersionConstraint[] versionConstraintArray2 = this.platformAdmin.getStateHelper().getUnsatisfiedLeaves(new BundleDescription[]{bundleDescription});
                boolean bl = false;
                int n2 = 0;
                while (n2 < versionConstraintArray2.length) {
                    if (versionConstraintArray2[n2].getBundle() != bundleDescription) {
                        if (!bl) {
                            bl = true;
                            commandInterpreter.print("  ");
                            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_LEAF_CONSTRAINTS);
                        }
                        commandInterpreter.print("    ");
                        commandInterpreter.println(String.valueOf(versionConstraintArray2[n2].getBundle().getLocation()) + " [" + versionConstraintArray2[n2].getBundle().getBundleId() + "]");
                        commandInterpreter.print("      ");
                        commandInterpreter.println(MessageHelper.getResolutionFailureMessage(versionConstraintArray2[n2]));
                    }
                    ++n2;
                }
                string = commandInterpreter.nextArgument();
            }
        }
        finally {
            this.ungetPlatformAdmin();
        }
    }

    public void _enableBundle(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                DisabledInfo[] disabledInfoArray = state.getDisabledInfos(bundleDescription);
                int n = 0;
                while (n < disabledInfoArray.length) {
                    this.getPlatformAdmin(commandInterpreter).removeDisabledInfo(disabledInfoArray[n]);
                    ++n;
                }
                string = commandInterpreter.nextArgument();
            }
        }
        finally {
            this.ungetPlatformAdmin();
        }
    }

    public void _disableBundle(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                DisabledInfo disabledInfo = new DisabledInfo(POLICY_CONSOLE, EclipseAdaptorMsg.ECLIPSE_CONSOLE_BUNDLE_DISABLED_MESSAGE, bundleDescription);
                this.getPlatformAdmin(commandInterpreter).addDisabledInfo(disabledInfo);
                string = commandInterpreter.nextArgument();
            }
        }
        finally {
            this.ungetPlatformAdmin();
        }
    }

    public void _disabledBundles(CommandInterpreter commandInterpreter) throws Exception {
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            BundleDescription[] bundleDescriptionArray = state.getDisabledBundles();
            commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_COUNT_MESSAGE, String.valueOf(bundleDescriptionArray.length)));
            if (bundleDescriptionArray.length > 0) {
                commandInterpreter.println();
            }
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                DisabledInfo[] disabledInfoArray = state.getDisabledInfos(bundleDescriptionArray[n]);
                commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_BUNDLE_HEADER, this.formatBundleName(bundleDescriptionArray[n]), String.valueOf(bundleDescriptionArray[n].getBundleId())));
                commandInterpreter.print(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_BUNDLE_REASON1, disabledInfoArray[0].getMessage(), disabledInfoArray[0].getPolicyName()));
                int n2 = 1;
                while (n2 < disabledInfoArray.length) {
                    commandInterpreter.print(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_BUNDLE_REASON1, disabledInfoArray[n2].getMessage(), String.valueOf(disabledInfoArray[n2].getPolicyName())));
                    ++n2;
                }
                commandInterpreter.println();
                ++n;
            }
        }
        finally {
            this.ungetPlatformAdmin();
        }
    }

    private String formatBundleName(BundleDescription bundleDescription) throws  {
        return EclipseCommandProvider$$Cold.formatBundleName(this, bundleDescription);
    }
}

