/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation$$Cold;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation$MockLocker;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.LocationHelper;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaIo;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaNio;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class BasicLocation
implements Location {
    private final boolean isReadOnly;
    private URL location = null;
    private Location parent;
    private final URL defaultValue;
    private final String property;
    private File lockFile;
    private Locker locker;
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    private static String LOCK_FILENAME = ".metadata/.lock";
    public static boolean DEBUG;

    private static boolean isRunningWithNio() {
        try {
            Class.forName("java.nio.channels.FileLock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static Locker createLocker(File file, String string) {
        if (string == null) {
            string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        }
        if ("none".equals(string)) {
            return new BasicLocation$MockLocker();
        }
        if ("java.io".equals(string)) {
            return new Locker_JavaIo(file);
        }
        if ("java.nio".equals(string)) {
            if (BasicLocation.isRunningWithNio()) {
                return new Locker_JavaNio(file);
            }
            return new Locker_JavaIo(file);
        }
        if (BasicLocation.isRunningWithNio()) {
            return new Locker_JavaNio(file);
        }
        return new Locker_JavaIo(file);
    }

    public BasicLocation(String string, URL uRL, boolean bl) {
        this.property = string;
        this.defaultValue = uRL;
        this.isReadOnly = bl;
    }

    public boolean allowsDefault() {
        return this.defaultValue != null;
    }

    public URL getDefault() {
        return this.defaultValue;
    }

    public synchronized Location getParentLocation() {
        return this.parent;
    }

    public synchronized URL getURL() {
        if (this.location == null && this.defaultValue != null) {
            this.setURL(this.defaultValue, false);
        }
        return this.location;
    }

    public synchronized boolean isSet() {
        return this.location != null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean setURL(URL uRL, boolean bl) throws IllegalStateException {
        try {
            return this.set(uRL, bl);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean set(URL uRL, boolean bl) throws IllegalStateException, IOException {
        if (this.location != null) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_CANNOT_CHANGE_LOCATION);
        }
        File file = null;
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            try {
                String string = new File(uRL.getFile()).getCanonicalPath();
                uRL = LocationHelper.buildURL("file:" + string, true);
            }
            catch (IOException iOException) {}
            file = new File(uRL.getFile(), LOCK_FILENAME);
        }
        boolean bl2 = bl = bl && !this.isReadOnly;
        if (bl && !this.lock(file, uRL)) {
            return false;
        }
        this.lockFile = file;
        this.location = uRL;
        if (this.property != null) {
            FrameworkProperties.setProperty(this.property, this.location.toExternalForm());
        }
        return bl;
    }

    public synchronized void setParent(Location location) {
        this.parent = location;
    }

    public synchronized boolean lock() throws IOException {
        if (!this.isSet()) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.location_notSet);
        }
        return this.lock(this.lockFile, this.location);
    }

    public synchronized boolean isLocked() throws IOException {
        if (!this.isSet()) {
            return false;
        }
        return this.isLocked(this.lockFile);
    }

    private boolean lock(File file, URL uRL) throws IOException {
        if (this.isReadOnly) {
            throw (Throwable)new IOException(NLS.bind(EclipseAdaptorMsg.location_folderReadOnly, file));
        }
        if (file == null) {
            if (uRL != null && !"file".equalsIgnoreCase(uRL.getProtocol())) {
                throw (Throwable)new IOException(NLS.bind(EclipseAdaptorMsg.location_notFileProtocol, uRL));
            }
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.location_noLockFile);
        }
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw (Throwable)new IOException(NLS.bind(EclipseAdaptorMsg.location_folderReadOnly, file2));
        }
        this.setLocker(file);
        if (this.locker == null) {
            return true;
        }
        boolean bl = false;
        try {
            boolean bl2 = bl = this.locker.lock();
            return bl2;
        }
        finally {
            if (!bl) {
                this.locker = null;
            }
        }
    }

    private boolean isLocked(File file) throws IOException {
        if (file == null || this.isReadOnly) {
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        this.setLocker(file);
        return this.locker.isLocked();
    }

    private void setLocker(File file) {
        if (this.locker != null) {
            return;
        }
        String string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        this.locker = BasicLocation.createLocker(file, string);
    }

    public synchronized void release() {
        if (this.locker != null) {
            this.locker.release();
        }
    }

    public Location createLocation(Location location, URL uRL, boolean bl) throws  {
        return BasicLocation$$Cold.createLocation(this, location, uRL, bl);
    }
}

