/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.rest;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.workitems.internal.CoreUtil;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineDelimiterErrorHandler {
    private final Map<String, Boolean> lineDelimiterInstructions;
    private final int generalLineDelimiterDirection;
    private final List<LineDelimiterErrorDTO> lineDelimiterErrorsReported;

    public LineDelimiterErrorHandler(ParmsLineDelimiterDilemmaHandler parmsLineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported) {
        if (parmsLineDelimiterDilemmaHandler == null) {
            this.generalLineDelimiterDirection = 2;
            this.lineDelimiterInstructions = Collections.EMPTY_MAP;
        } else {
            this.generalLineDelimiterDirection = this.getDirection(parmsLineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction);
            this.lineDelimiterInstructions = this.initializeLineDelimiterInstructions(parmsLineDelimiterDilemmaHandler.lineDelimiterErrorInstructions);
        }
        this.lineDelimiterErrorsReported = lineDelimiterErrorsReported;
    }

    private HashMap<String, Boolean> initializeLineDelimiterInstructions(ParmsLineDelimiterErrorInstructions[] lineDelimiterErrorInstructions) {
        HashMap<String, Boolean> instructions = new HashMap<String, Boolean>();
        if (lineDelimiterErrorInstructions != null) {
            int i = 0;
            while (i < lineDelimiterErrorInstructions.length) {
                ParmsLineDelimiterErrorInstructions instruction = lineDelimiterErrorInstructions[i];
                IPath path = new Path(instruction.sandboxPath).append(instruction.filePath);
                path.removeTrailingSeparator();
                instructions.put(path.toString(), instruction.forceConsistentDelimiters);
                ++i;
            }
        }
        return instructions;
    }

    private int getDirection(String direction) {
        if ("cancel".equals(direction)) {
            return 1;
        }
        if ("continue".equals(direction)) {
            return 0;
        }
        return 2;
    }

    public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemClientException {
        if (this.lineDelimiterErrorsReported != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)inconsistentDelimiters.size());
            for (IChangePropertiesRequest request : inconsistentDelimiters) {
                SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                FileLineDelimiter d = request.getLineDelimiter((IProgressMonitor)subProgress.newChild(30));
                this.lineDelimiterErrorsReported.add(LineDelimiterErrorHandler.translateLineDelimiterError(request.getShareableToChange(), d, (IProgressMonitor)subProgress.newChild(70)));
            }
        }
        boolean followGeneralInstruction = false;
        for (IChangePropertiesRequest request : inconsistentDelimiters) {
            IPath path = request.getShareableToChange().getFullPath();
            path.removeTrailingSeparator();
            Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
            if (instruction == null) {
                if (this.generalLineDelimiterDirection == 0) {
                    request.setForceLineDelimiterConversion(false);
                }
                followGeneralInstruction = true;
                continue;
            }
            request.setForceLineDelimiterConversion(instruction.booleanValue());
        }
        if (followGeneralInstruction) {
            return this.generalLineDelimiterDirection;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemClientException {
        if (this.lineDelimiterErrorsReported != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * failedFiles.size()));
            List<LineDelimiterErrorDTO> list = this.lineDelimiterErrorsReported;
            synchronized (list) {
                for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                    FileLineDelimiter ld = iLineDelimiterUploadFailure.getShareable().getLineDelimiter((IProgressMonitor)progress.newChild(5));
                    this.lineDelimiterErrorsReported.add(LineDelimiterErrorHandler.translateLineDelimiterError(iLineDelimiterUploadFailure.getShareable(), ld, (IProgressMonitor)progress.newChild(5)));
                }
            }
        }
        int result = 0;
        for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
            IPath path = iLineDelimiterUploadFailure.getShareable().getFullPath();
            path.removeTrailingSeparator();
            Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
            if (instruction == null) {
                if (this.generalLineDelimiterDirection == 0) {
                    iLineDelimiterUploadFailure.setForceConsistentDelimiters(false);
                    continue;
                }
                result = this.generalLineDelimiterDirection;
                break;
            }
            iLineDelimiterUploadFailure.setForceConsistentDelimiters(instruction.booleanValue());
        }
        return result;
    }

    public static LineDelimiterErrorDTO translateLineDelimiterError(IShareable shareable, FileLineDelimiter incompatibleLineDelimiterSetting, IProgressMonitor monitor) throws FileSystemClientException {
        LineDelimiterErrorDTO failedUpload = FilesystemRestClientDTOresourceFactory.eINSTANCE.createLineDelimiterErrorDTO();
        failedUpload.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        failedUpload.setShare(CoreUtil.translateShare(shareable.getShare(monitor)));
        if (incompatibleLineDelimiterSetting != null) {
            failedUpload.setLineDelimiter(LocalContentExaminer.getLineDelimiter((FileLineDelimiter)incompatibleLineDelimiterSetting));
        }
        return failedUpload;
    }
}

