/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.WorkItemUtils;
import com.ibm.team.filesystem.client.workitems.operations.DeliverAndFixParameter;
import com.ibm.team.filesystem.client.workitems.operations.IDeliverAndFixOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DeliverAndFixOperation
extends FileSystemOperation
implements IDeliverAndFixOperation {
    private DeliverAndFixParameter deliverAndFixParameters;
    private DeliverDilemmaHandler dilemmaHandler;
    private boolean refreshBeforeRun = false;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public DeliverAndFixOperation(DeliverDilemmaHandler warnDeliverUser) {
        super((DilemmaHandler)warnDeliverUser);
        this.dilemmaHandler = warnDeliverUser;
    }

    public void deliverAndFix(DeliverAndFixParameter parms) {
        this.deliverAndFixParameters = parms;
    }

    public void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.deliverAndFixParameters.getTarget().teamRepository();
        IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(this.deliverAndFixParameters.getWorkItems());
        Iterator i = workItems.iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
        List fullWorkItems = repo.itemManager().fetchCompleteItems(workItems, 0, (IProgressMonitor)loopProgress.newChild(20));
        for (IWorkItemHandle workItemToAssign : fullWorkItems) {
            boolean associated = false;
            for (IChangeSetHandle changeSet : this.deliverAndFixParameters.getChangeSets()) {
                if (!WorkItemUtils.isWorkItemAssociated(workItemToAssign, repo, changeSet)) continue;
                associated = true;
                break;
            }
            if (associated) continue;
            for (IChangeSetHandle changeSet : this.deliverAndFixParameters.getChangeSets()) {
                workItemManager.createLink(this.deliverAndFixParameters.getTarget().getResolvedWorkspace(), changeSet, new IWorkItemHandle[]{workItemToAssign}, (IProgressMonitor)loopProgress.newChild(1));
            }
        }
        IDeliverOperation deliverOp = IOperationFactory.instance.getDeliverOperation(this.dilemmaHandler);
        deliverOp.setRefreshBeforeRun(this.refreshBeforeRun);
        if (this.nonAtomicCommitIsAnOption) {
            deliverOp.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
        } else {
            deliverOp.disableNonAtomicCommit();
        }
        deliverOp.deliver(this.deliverAndFixParameters.getSource(), this.deliverAndFixParameters.getTarget(), this.deliverAndFixParameters.getSyncReport(), new ArrayList<IChangeSetHandle>(this.deliverAndFixParameters.getChangeSets()));
        boolean addReview = this.deliverAndFixParameters.getReviewers().length > 0;
        workItemManager.deliverAndResolve(this.deliverAndFixParameters.getSyncReport(), this.deliverAndFixParameters.getSource(), this.deliverAndFixParameters.getTarget(), new ArrayList<IChangeSetHandle>(this.deliverAndFixParameters.getChangeSets()), new ArrayList<IWorkItem>(fullWorkItems), this.deliverAndFixParameters.isShouldResolve(), this.deliverAndFixParameters.getComment(), addReview, this.deliverAndFixParameters.getSubject(), Arrays.asList(this.deliverAndFixParameters.getReviewers()), deliverOp, monitor);
        monitor.done();
    }

    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }
}

