/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPreOperationRefresh;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRecomputeLocalChanges;
import com.ibm.team.filesystem.client.workitems.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshUtil {
    public static void recomputeLocalChanges(ParmsRecomputeLocalChanges parm, IProgressMonitor progress) throws TeamRepositoryException {
        block7: {
            try {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)101);
                ISandbox sandbox = SharingManager.getInstance().getSandbox((IPath)new Path(parm.sandboxPath), true);
                if (sandbox == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.RefreshUtil_0, (Object)parm.sandboxPath));
                }
                if (parm.paths == null || parm.paths.length == 0) {
                    SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(null, (IProgressMonitor)monitor.newChild(1));
                    IShare[] shares = sandbox.allShares((IProgressMonitor)monitor.newChild(10));
                    LocalChangeManager.getInstance().refreshChanges(shares, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)monitor.newChild(90));
                    break block7;
                }
                LocalChangeManager lcm = LocalChangeManager.getInstance();
                monitor.setWorkRemaining(10 * parm.paths.length);
                ArrayList<Shareable> shareables = new ArrayList<Shareable>(parm.paths.length);
                String[] stringArray = parm.paths;
                int n = parm.paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    IPath path = sandbox.getRoot().append(string);
                    ResourceType resourceType = PathUtils.getResourceType((IPath)path, (IProgressMonitor)monitor.newChild(1));
                    if (resourceType == null) break;
                    Shareable shareable = new Shareable(sandbox, (IPath)new Path(string), resourceType);
                    shareables.add(shareable);
                    ++n2;
                }
                SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
                for (IShareable iShareable : shareables) {
                    IShare share = iShareable.getShare((IProgressMonitor)monitor.newChild(1));
                    if (share != null) {
                        lcm.refreshChanges(share, iShareable, (IProgressMonitor)monitor.newChild(9));
                        continue;
                    }
                    break;
                }
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException("Failed to recompute local changes", (Throwable)e);
            }
        }
    }

    public static void configureRefresh(ParmsPreOperationRefresh parms, IRefreshingOperation op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        op.setRefreshBeforeRun(parms != null && "complete".equals(parms.refreshMode));
    }
}

