/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.filesystem.client.workitems.IWorkItemOperationFactory;
import com.ibm.team.filesystem.client.workitems.internal.CommitUtil;
import com.ibm.team.filesystem.client.workitems.internal.DeliverUtil;
import com.ibm.team.filesystem.client.workitems.internal.RefreshUtil;
import com.ibm.team.filesystem.client.workitems.internal.SuspendResumeDiscardChangeSetUtil;
import com.ibm.team.filesystem.client.workitems.operations.DeliverAndFixParameter;
import com.ibm.team.filesystem.client.workitems.operations.IDeliverAndFixOperation;
import com.ibm.team.filesystem.client.workitems.operations.ISubmitForReviewOperation;
import com.ibm.team.filesystem.client.workitems.operations.SubmitForReviewParameter;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsChangeSetsToSource;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostChangeSetWorkItem;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostDeliverAndResolve;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostSubmitForReview;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsWorkItem;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.SuspendResultDTO;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.util.RestUtils;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class FileSystemWorkItemRestClient
implements IFileSystemWorkItemRestClient {
    private static final UUID NULL_STATE = null;

    public void postAddWorkItem(ParmsPostChangeSetWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IWorkspace workspace = null;
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.changeSetId), NULL_STATE);
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workItemItemId), NULL_STATE);
        if (RestUtils.isSet((String)parms.workspaceId)) {
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workspaceId), NULL_STATE);
            IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, monitor);
            workspace = connection.getResolvedWorkspace();
        }
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        manager.createLink(workspace, changeSetHandle, new IWorkItemHandle[]{workItemHandle}, monitor);
    }

    public void postRemoveWorkItem(ParmsPostChangeSetWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.changeSetId), NULL_STATE);
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workItemItemId), NULL_STATE);
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List links = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)changeSetHandle, (IProgressMonitor)monitor);
        ILink linkToRemove = null;
        for (ILink link : links) {
            IItemHandle refHandle;
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || !((refHandle = ((IItemReference)targetRef).getReferencedItem()) instanceof IWorkItemHandle) || !refHandle.sameItemId((IItemHandle)workItemHandle)) continue;
            linkToRemove = link;
        }
        manager.deleteLinks(Collections.singletonList(linkToRemove), monitor);
    }

    public DeliverResultDTO postDeliverAndResolve(ParmsPostDeliverAndResolve parms, IProgressMonitor monitor) throws TeamRepositoryException {
        int n;
        int n2;
        Object[] objectArray;
        ITeamRepository repo;
        boolean addReview;
        IWorkspaceConnection source = parms.source.getWorkspaceConnection(monitor);
        IWorkspaceConnection target = parms.target.getWorkspaceConnection(monitor);
        HashSet<IChangeSetHandle> changeSetHandles = new HashSet<IChangeSetHandle>();
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
        HashSet<IContributorHandle> reviewers = new HashSet<IContributorHandle>();
        boolean shouldResolve = parms.shouldResolve;
        boolean bl = addReview = parms.reviewers != null;
        if (addReview) {
            repo = parms.reviewers.getTeamRepository();
            objectArray = parms.reviewers.contributorItemIds;
            n2 = parms.reviewers.contributorItemIds.length;
            n = 0;
            while (n < n2) {
                String reviewer = objectArray[n];
                reviewers.add((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)reviewer), null));
                ++n;
            }
        }
        repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.source.repositoryUrl);
        objectArray = parms.changeSets;
        n2 = parms.changeSets.length;
        n = 0;
        while (n < n2) {
            String changeSetId = objectArray[n];
            IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)changeSetId), NULL_STATE);
            changeSetHandles.add(changeSetHandle);
            ++n;
        }
        objectArray = parms.workItemIds;
        n2 = parms.workItemIds.length;
        n = 0;
        while (n < n2) {
            Object parmWorkItem = objectArray[n];
            workItemHandles.add(((ParmsWorkItem)parmWorkItem).getWorkItem(monitor));
            ++n;
        }
        IChangeHistorySyncReport syncReport = source.compareTo((IFlowNodeConnection)target, WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO, Collections.EMPTY_LIST, null);
        repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.source.repositoryUrl);
        IContributorHandle[] reviewList = new IContributorHandle[reviewers.size()];
        DeliverAndFixParameter opParms = new DeliverAndFixParameter(changeSetHandles, parms.workItemComment, parms.approvalSubject, reviewers.toArray(reviewList), workItemHandles, syncReport, source, target, shouldResolve);
        ParmsDeliver deliverParms = new ParmsDeliver();
        deliverParms.backupDilemmaHandler = parms.backupHandler;
        deliverParms.deliverDilemmaHandler = parms.deliverHandler;
        deliverParms.pendingChangesDilemmaHandler = parms.pendingChangesHandler;
        DeliverResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDeliverResultDTO();
        DeliverDilemmaHandler deliverDilemmaHandler = DeliverUtil.getDeliverDilemmaHandler(deliverParms, result);
        IDeliverAndFixOperation deliverAndFixOperation = IWorkItemOperationFactory.instance.getDeliverAndResolveOperation(deliverDilemmaHandler);
        deliverAndFixOperation.deliverAndFix(opParms);
        RefreshUtil.configureRefresh(parms.preOpRefresh, deliverAndFixOperation);
        CommitUtil.configureCommit(parms.pendingChangesHandler, (ICheckinOptions)deliverAndFixOperation);
        try {
            deliverAndFixOperation.run(monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    public SuspendResultDTO postSubmitForReview(ParmsPostSubmitForReview parms, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<IContributorHandle> reviewers = new HashSet<IContributorHandle>();
        HashSet<IChangeSetHandle> changeSetHandles = new HashSet<IChangeSetHandle>();
        HashSet<SubmitForReviewParameter.ChangeSetReview> changeSetReviews = new HashSet<SubmitForReviewParameter.ChangeSetReview>();
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
        ITeamRepository repo = parms.reviewers.getTeamRepository();
        Object[] objectArray = parms.reviewers.contributorItemIds;
        int n = parms.reviewers.contributorItemIds.length;
        int n2 = 0;
        while (n2 < n) {
            String reviewer = objectArray[n2];
            reviewers.add((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)reviewer), null));
            ++n2;
        }
        objectArray = parms.changeSetsToReview;
        n = parms.changeSetsToReview.length;
        n2 = 0;
        while (n2 < n) {
            Object changeSetsToReview = objectArray[n2];
            String[] stringArray = ((ParmsChangeSetsToSource)changeSetsToReview).changeSetIds;
            int n3 = ((ParmsChangeSetsToSource)changeSetsToReview).changeSetIds.length;
            int n4 = 0;
            while (n4 < n3) {
                String changeSetId = stringArray[n4];
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)changeSetId), NULL_STATE);
                IWorkspaceConnection source = ((ParmsChangeSetsToSource)changeSetsToReview).source.getWorkspaceConnection(monitor);
                SubmitForReviewParameter.ChangeSetReview changeSetReview = new SubmitForReviewParameter.ChangeSetReview(changeSetHandle, source);
                changeSetReviews.add(changeSetReview);
                changeSetHandles.add(changeSetHandle);
                ++n4;
            }
            ++n2;
        }
        objectArray = parms.workItemIds;
        n = parms.workItemIds.length;
        n2 = 0;
        while (n2 < n) {
            Object parmWorkItem = objectArray[n2];
            workItemHandles.add(((ParmsWorkItem)parmWorkItem).getWorkItem(monitor));
            ++n2;
        }
        IContributorHandle[] reviewList = new IContributorHandle[reviewers.size()];
        SuspendResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createSuspendResultDTO();
        SubmitForReviewParameter opParms = new SubmitForReviewParameter(parms.workItemComment, reviewers.toArray(reviewList), parms.suspendChangeSets, parms.approvalSubject, workItemHandles, changeSetReviews, repo);
        ParmsSuspendChangeSets suspendParms = new ParmsSuspendChangeSets();
        suspendParms.backupDilemmaHandler = parms.backupHandler;
        suspendParms.outOfSyncInstructions = parms.outOfSyncInstructions;
        suspendParms.pendingChangesDilemmaHandler = parms.pendingChangesHandler;
        SuspendDilemmaHandler suspendDilemmaHandler = SuspendResumeDiscardChangeSetUtil.getSuspendDilemmaHandler(result.getOutOfSyncShares(), result.getLineDelimiterFailures(), result.getEncodingFailures(), result.getConfigurationsWithUnCheckedInChanges(), result.getBackedUpToShed(), result.getNonAtomicCheckInOffers(), suspendParms);
        ISubmitForReviewOperation submitOp = IWorkItemOperationFactory.instance.getSubmitForReviewOperation(suspendDilemmaHandler);
        submitOp.submitForReview(opParms);
        RefreshUtil.configureRefresh(parms.preOpRefresh, submitOp);
        CommitUtil.configureCommit(parms.pendingChangesHandler, (ICheckinOptions)submitOp);
        try {
            submitOp.run(monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }
}

