/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus$$Cold;
import org.eclipse.core.runtime.Status;

public class MultiStatus
extends Status {
    private IStatus[] children = new IStatus[0];

    public MultiStatus(String string, int n, String string2, Throwable throwable) {
        super(0, string, n, string2, throwable);
    }

    public IStatus[] getChildren() {
        return this.children;
    }

    public boolean isMultiStatus() {
        return true;
    }

    public MultiStatus(String string, int n, IStatus[] iStatusArray, String string2, Throwable throwable) {
        this(string, n, string2, throwable);
        Assert.isLegal(iStatusArray != null);
        int n2 = this.getSeverity();
        int n3 = 0;
        while (n3 < iStatusArray.length) {
            Assert.isLegal(iStatusArray[n3] != null);
            int n4 = iStatusArray[n3].getSeverity();
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        this.children = new IStatus[iStatusArray.length];
        this.setSeverity(n2);
        System.arraycopy(iStatusArray, 0, this.children, 0, iStatusArray.length);
    }

    public void add(IStatus iStatus) {
        Assert.isLegal(iStatus != null);
        IStatus[] iStatusArray = new IStatus[this.children.length + 1];
        System.arraycopy(this.children, 0, iStatusArray, 0, this.children.length);
        iStatusArray[iStatusArray.length - 1] = iStatus;
        this.children = iStatusArray;
        int n = iStatus.getSeverity();
        if (n > this.getSeverity()) {
            this.setSeverity(n);
        }
    }

    public void addAll(IStatus iStatus) throws  {
        MultiStatus$$Cold.addAll(this, iStatus);
    }

    public void merge(IStatus iStatus) throws  {
        MultiStatus$$Cold.merge(this, iStatus);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" children=[");
        int n = 0;
        while (n < this.children.length) {
            if (n != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.children[n].toString());
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

