/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.AdapterManager$$Cold;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;

public final class AdapterManager
implements IAdapterManager {
    private Map adapterLookup;
    private Map classLookup;
    private final Object classLookupLock = new Object();
    private Map classSearchOrderLookup;
    private final HashMap factories = new HashMap(5);
    private final ArrayList lazyFactoryProviders = new ArrayList(1);
    private static final AdapterManager singleton = new AdapterManager();

    public static AdapterManager getDefault() {
        return singleton;
    }

    private AdapterManager() {
    }

    public Object getAdapter(Object object, String string) {
        return this.getAdapter(object, string, false);
    }

    public Object loadAdapter(Object object, String string) {
        return this.getAdapter(object, string, true);
    }

    public synchronized void registerAdapters(IAdapterFactory iAdapterFactory, Class clazz) {
        this.registerFactory(iAdapterFactory, clazz.getName());
        this.flushLookup();
    }

    public synchronized void unregisterAllAdapters() {
        this.factories.clear();
        this.flushLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLazyFactoryProvider(IAdapterManagerProvider iAdapterManagerProvider) {
        ArrayList arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            this.lazyFactoryProviders.add(iAdapterManagerProvider);
        }
    }

    private void addFactoriesFor(String string, Map map) throws  {
        AdapterManager$$Cold.addFactoriesFor(this, string, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheClassLookup(IAdapterFactory iAdapterFactory, Class clazz) {
        Object object = this.classLookupLock;
        synchronized (object) {
            HashMap<String, Class> hashMap;
            HashMap<IAdapterFactory, HashMap<String, Class>> hashMap2 = this.classLookup;
            if (hashMap2 == null) {
                hashMap2 = new HashMap<IAdapterFactory, HashMap<String, Class>>(4);
                this.classLookup = hashMap2;
            }
            if ((hashMap = (HashMap<String, Class>)hashMap2.get(iAdapterFactory)) == null) {
                hashMap = new HashMap<String, Class>(4);
                hashMap2.put(iAdapterFactory, hashMap);
            }
            hashMap.put(clazz.getName(), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class cachedClassForName(IAdapterFactory iAdapterFactory, String string) {
        Object object = this.classLookupLock;
        synchronized (object) {
            HashMap hashMap;
            Class clazz = null;
            Map map = this.classLookup;
            if (map != null && (hashMap = (HashMap)map.get(iAdapterFactory)) != null) {
                clazz = (Class)hashMap.get(string);
            }
            return clazz;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Class classForName(IAdapterFactory var1_1, String var2_2) {
        var3_3 = this.cachedClassForName(var1_1, var2_2);
        if (var3_3 == null) {
            if (var1_1 instanceof IAdapterFactoryExt) {
                var1_1 = ((IAdapterFactoryExt)var1_1).loadFactory(false);
            }
            if (var1_1 != null) {
                block9: {
                    try {
                        var3_3 = var1_1.getClass().getClassLoader().loadClass(var2_2);
                        break block9;
                    }
                    catch (ClassNotFoundException v0) {
                        if (var2_2 == null) {
                            return null;
                        }
                        var4_4 = var1_1.getAdapterList();
                        var3_3 = null;
                        var5_5 = 0;
                        ** while (var5_5 < var4_4.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var2_2.equals(var4_4[var5_5].getName())) {
                            var3_3 = var4_4[var5_5];
                            break;
                        }
                        ++var5_5;
                        continue;
                    }
lbl21:
                    // 2 sources

                    if (var3_3 == null) {
                        return null;
                    }
                }
                this.cacheClassLookup(var1_1, var3_3);
            }
        }
        return var3_3;
    }

    public String[] computeAdapterTypes(Class clazz) {
        Set set = this.getFactories(clazz).keySet();
        return set.toArray(new String[set.size()]);
    }

    private Map getFactories(Class clazz) {
        HashMap hashMap;
        Map map = this.adapterLookup;
        if (map == null) {
            this.adapterLookup = map = Collections.synchronizedMap(new HashMap(30));
        }
        if ((hashMap = (HashMap)map.get(clazz.getName())) == null) {
            hashMap = new HashMap(4);
            Class[] classArray = this.computeClassOrder(clazz);
            int n = 0;
            while (n < classArray.length) {
                this.addFactoriesFor(classArray[n].getName(), hashMap);
                ++n;
            }
            map.put(clazz.getName(), hashMap);
        }
        return hashMap;
    }

    public Class[] computeClassOrder(Class clazz) {
        Class[] classArray = null;
        Map<Class, Class[]> map = this.classSearchOrderLookup;
        if (map == null) {
            this.classSearchOrderLookup = map = Collections.synchronizedMap(new HashMap());
        } else {
            classArray = (Class[])map.get(clazz);
        }
        if (classArray == null) {
            ArrayList arrayList = new ArrayList();
            this.computeClassOrder(clazz, arrayList);
            classArray = arrayList.toArray(new Class[arrayList.size()]);
            map.put(clazz, classArray);
        }
        return classArray;
    }

    private void computeClassOrder(Class clazz, Collection collection) {
        Class clazz2 = clazz;
        HashSet hashSet = new HashSet(4);
        while (clazz2 != null) {
            collection.add(clazz2);
            this.computeInterfaceOrder(clazz2.getInterfaces(), collection, hashSet);
            clazz2 = clazz2.getSuperclass();
        }
    }

    private void computeInterfaceOrder(Class[] classArray, Collection collection, Set set) {
        ArrayList<Class> arrayList = new ArrayList<Class>(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            if (set.add(clazz)) {
                collection.add(clazz);
                arrayList.add(clazz);
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.computeInterfaceOrder(((Class)iterator.next()).getInterfaces(), collection, set);
        }
    }

    public synchronized void flushLookup() {
        this.adapterLookup = null;
        this.classLookup = null;
        this.classSearchOrderLookup = null;
    }

    public Object getAdapter(Object object, Class clazz) {
        IAdapterFactory iAdapterFactory = (IAdapterFactory)this.getFactories(object.getClass()).get(clazz.getName());
        Object object2 = null;
        if (iAdapterFactory != null) {
            object2 = iAdapterFactory.getAdapter(object, clazz);
        }
        if (object2 == null && clazz.isInstance(object)) {
            return object;
        }
        return object2;
    }

    private Object getAdapter(Object object, String string, boolean bl) {
        Class clazz;
        IAdapterFactory iAdapterFactory = (IAdapterFactory)this.getFactories(object.getClass()).get(string);
        if (bl && iAdapterFactory instanceof IAdapterFactoryExt) {
            iAdapterFactory = ((IAdapterFactoryExt)((Object)iAdapterFactory)).loadFactory(true);
        }
        Object object2 = null;
        if (iAdapterFactory != null && (clazz = this.classForName(iAdapterFactory, string)) != null) {
            object2 = iAdapterFactory.getAdapter(object, clazz);
        }
        if (object2 == null && object.getClass().getName().equals(string)) {
            return object;
        }
        return object2;
    }

    public boolean hasAdapter(Object object, String string) {
        return this.getFactories(object.getClass()).get(string) != null;
    }

    public int queryAdapter(Object object, String string) {
        IAdapterFactory iAdapterFactory = (IAdapterFactory)this.getFactories(object.getClass()).get(string);
        if (iAdapterFactory == null) {
            return 0;
        }
        if (iAdapterFactory instanceof IAdapterFactoryExt && (iAdapterFactory = ((IAdapterFactoryExt)((Object)iAdapterFactory)).loadFactory(false)) == null) {
            return 1;
        }
        return 2;
    }

    public void registerFactory(IAdapterFactory iAdapterFactory, String string) {
        ArrayList<IAdapterFactory> arrayList = (ArrayList<IAdapterFactory>)this.factories.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IAdapterFactory>(5);
            this.factories.put(string, arrayList);
        }
        arrayList.add(iAdapterFactory);
    }

    public synchronized void unregisterAdapters(IAdapterFactory iAdapterFactory) {
        Iterator iterator = this.factories.values().iterator();
        while (iterator.hasNext()) {
            ((List)iterator.next()).remove(iAdapterFactory);
        }
        this.flushLookup();
    }

    public synchronized void unregisterAdapters(IAdapterFactory iAdapterFactory, Class clazz) {
        List list = (List)this.factories.get(clazz.getName());
        if (list == null) {
            return;
        }
        list.remove(iAdapterFactory);
        this.flushLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterLazyFactoryProvider(IAdapterManagerProvider iAdapterManagerProvider) {
        ArrayList arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            return ((AbstractCollection)this.lazyFactoryProviders).remove(iAdapterManagerProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getFactories() {
        if (this.lazyFactoryProviders.size() == 0) {
            return this.factories;
        }
        ArrayList arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            while (this.lazyFactoryProviders.size() > 0) {
                IAdapterManagerProvider iAdapterManagerProvider = (IAdapterManagerProvider)this.lazyFactoryProviders.remove(0);
                if (!iAdapterManagerProvider.addFactories(this)) continue;
                this.flushLookup();
            }
        }
        return this.factories;
    }
}

