/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class PlatformURLHandler
extends AbstractURLStreamHandlerService {
    private static Hashtable connectionType = new Hashtable();
    public static final String PROTOCOL = "platform";
    public static final String FILE = "file";
    public static final String JAR = "jar";
    public static final String BUNDLE = "bundle";
    public static final String JAR_SEPARATOR = "!/";
    public static final String PROTOCOL_SEPARATOR = ":";
    static Class class$0;

    public static void register(String string, Class clazz) {
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[0] = clazz2;
            Constructor constructor = clazz.getConstructor(classArray);
            connectionType.put(string, constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public static void unregister(String string) {
        connectionType.remove(string);
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        int n;
        String string = uRL.getFile().trim();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf("/")) == -1) {
            throw (Throwable)new MalformedURLException(NLS.bind((String)CommonMessages.url_invalidURL, (Object)uRL.toExternalForm()));
        }
        String string2 = string.substring(0, n);
        Constructor constructor = (Constructor)connectionType.get(string2);
        if (constructor == null) {
            throw (Throwable)new MalformedURLException(NLS.bind((String)CommonMessages.url_badVariant, (Object)string2));
        }
        PlatformURLConnection platformURLConnection = null;
        try {
            platformURLConnection = (PlatformURLConnection)constructor.newInstance(uRL);
        }
        catch (Exception exception) {
            throw (Throwable)new IOException(NLS.bind((String)CommonMessages.url_createConnection, (Object)((Throwable)exception).getMessage()));
        }
        platformURLConnection.setResolvedURL(platformURLConnection.resolve());
        return platformURLConnection;
    }
}

