/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.SCMPlatform;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class ConfigValueCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final IOptionKey OPT_KEY = new OptionKey("keys");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp("TOOLS: Outputs values of configurations.");
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("content.threads");
        keys.add("repository.timeout");
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(key);
        }
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_KEY, "keys", 0, -1), "The configuration to query, or ignore this field to print all values. Keys: " + builder.toString());
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)config.getConnectionInfo());
        String key = null;
        ICommandLine cli = config.getSubcommandCommandLine();
        if (cli.hasOption(OPT_KEY)) {
            key = cli.getOption(OPT_KEY);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (ConfigValueCmd.printValue(key, "content.threads")) {
            map.put("content.threads", Integer.toString(SCMPlatform.getMaxContentThreads()));
        }
        if (ConfigValueCmd.printValue(key, "repository.timeout")) {
            map.put("repository.timeout", Integer.toString(repo.getConnectionTimeout()));
        }
        CharSequence[] strings = new String[map.size() * 3];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            strings[i++] = (String)entry.getKey();
            strings[i++] = "-";
            strings[i++] = (String)entry.getValue();
        }
        StringUtil.printTable((IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stdout()), (int)3, (boolean)true, (CharSequence[])strings);
    }

    private static boolean printValue(String str, String key) {
        if (str == null) {
            return true;
        }
        return str.equalsIgnoreCase(key);
    }
}

