/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnBackupUser;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnLoadUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarnOutOfSync
extends OutOfSyncDilemmaHandler {
    private final WarnLoadUser warnLoadUser;
    private final WarnBackupUser warnBackupUser;
    private final Shell shell;
    private final String dialogTitle;
    private boolean outOfSyncSharesDetected;

    public WarnOutOfSync(Shell shell, String title) {
        this.shell = shell;
        this.dialogTitle = title;
        this.warnLoadUser = new WarnLoadUser(shell, title);
        this.warnBackupUser = new WarnBackupUser(shell, title);
        this.outOfSyncSharesDetected = false;
    }

    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
        return this.warnLoadUser.collision(collisions, removedShares, sharesOutOfSync);
    }

    public int outOfSync(final Collection<IShareOutOfSync> sharesOutOfSync) {
        if (sharesOutOfSync.isEmpty()) {
            return 0;
        }
        this.outOfSyncSharesDetected = true;
        final int[] result = new int[]{1};
        IShare[] shares = new IShare[sharesOutOfSync.size()];
        int i = 0;
        for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
            shares[i] = shareOutOfSync.getShare();
            ++i;
        }
        ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(shares);
        final String direction = changes.length > 0 ? Messages.WarnOutOfSync_0 : Messages.WarnOutOfSync_1;
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    IStatus[] statuses = new IStatus[sharesOutOfSync.size()];
                    int i = 0;
                    for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                        statuses[i] = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.WarnOutOfSync_2, (Object)shareOutOfSync.getShare().getPath().makeRelative()));
                        ++i;
                    }
                    Arrays.sort(statuses, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String msg1 = ((IStatus)o1).getMessage();
                            String msg2 = ((IStatus)o2).getMessage();
                            return msg1.compareToIgnoreCase(msg2);
                        }
                    });
                    Object status = statuses.length > 1 ? new MultiStatus("com.ibm.team.filesystem.client", 4, statuses, NLS.bind((String)Messages.WarnOutOfSync_3, (Object)statuses.length), null) : statuses[0];
                    StatusDialog dialog = new StatusDialog(DialogUtil.checkShell(WarnOutOfSync.this.shell), WarnOutOfSync.this.dialogTitle, direction, "", (IStatus)status, 7);
                    if (dialog.open() == 0) {
                        result[0] = 100;
                    }
                }
            });
        }
        return result[0];
    }

    public boolean willIgnoreAllSharesOutOfSync() {
        return false;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.warnBackupUser;
    }

    public boolean wasOutOfSync() {
        return this.outOfSyncSharesDetected;
    }
}

